/*      */ package EDU.oswego.cs.dl.util.concurrent;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.lang.reflect.Array;
/*      */ import java.util.AbstractList;
/*      */ import java.util.Collection;
/*      */ import java.util.ConcurrentModificationException;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.ListIterator;
/*      */ import java.util.NoSuchElementException;
/*      */ 
/*      */ public class CopyOnWriteArrayList
/*      */   implements List, Cloneable, Serializable
/*      */ {
/*      */   protected transient Object[] array_;
/*      */ 
/*      */   protected synchronized Object[] array()
/*      */   {
/*   94 */     return this.array_;
/*      */   }
/*      */ 
/*      */   public CopyOnWriteArrayList()
/*      */   {
/*  101 */     this.array_ = new Object[0];
/*      */   }
/*      */ 
/*      */   public CopyOnWriteArrayList(Collection c)
/*      */   {
/*  110 */     this.array_ = new Object[c.size()];
/*  111 */     Iterator i = c.iterator();
/*  112 */     int size = 0;
/*  113 */     while (i.hasNext())
/*  114 */       this.array_[(size++)] = i.next();
/*      */   }
/*      */ 
/*      */   public CopyOnWriteArrayList(Object[] toCopyIn)
/*      */   {
/*  123 */     copyIn(toCopyIn, 0, toCopyIn.length);
/*      */   }
/*      */ 
/*      */   public synchronized void copyIn(Object[] toCopyIn, int first, int n)
/*      */   {
/*  139 */     this.array_ = new Object[n];
/*  140 */     System.arraycopy(toCopyIn, first, this.array_, 0, n);
/*      */   }
/*      */ 
/*      */   public int size()
/*      */   {
/*  149 */     return array().length;
/*      */   }
/*      */ 
/*      */   public boolean isEmpty()
/*      */   {
/*  159 */     return size() == 0;
/*      */   }
/*      */ 
/*      */   public boolean contains(Object elem)
/*      */   {
/*  168 */     Object[] elementData = array();
/*  169 */     int len = elementData.length;
/*  170 */     return indexOf(elem, elementData, len) >= 0;
/*      */   }
/*      */ 
/*      */   public int indexOf(Object elem)
/*      */   {
/*  183 */     Object[] elementData = array();
/*  184 */     int len = elementData.length;
/*  185 */     return indexOf(elem, elementData, len);
/*      */   }
/*      */ 
/*      */   protected static int indexOf(Object elem, Object[] elementData, int len)
/*      */   {
/*  197 */     if (elem == null)
/*  198 */       for (int i = 0; i < len; i++)
/*  199 */         if (elementData[i] == null)
/*  200 */           return i;
/*      */     else {
/*  202 */       for (int i = 0; i < len; i++)
/*  203 */         if (elem.equals(elementData[i]))
/*  204 */           return i;
/*      */     }
/*  206 */     return -1;
/*      */   }
/*      */ 
/*      */   public int indexOf(Object elem, int index)
/*      */   {
/*  224 */     Object[] elementData = array();
/*  225 */     int elementCount = elementData.length;
/*      */ 
/*  227 */     if (elem == null)
/*  228 */       for (int i = index; i < elementCount; i++)
/*  229 */         if (elementData[i] == null)
/*  230 */           return i;
/*      */     else {
/*  232 */       for (int i = index; i < elementCount; i++)
/*  233 */         if (elem.equals(elementData[i]))
/*  234 */           return i;
/*      */     }
/*  236 */     return -1;
/*      */   }
/*      */ 
/*      */   public int lastIndexOf(Object elem)
/*      */   {
/*  248 */     Object[] elementData = array();
/*  249 */     int len = elementData.length;
/*  250 */     return lastIndexOf(elem, elementData, len);
/*      */   }
/*      */ 
/*      */   protected static int lastIndexOf(Object elem, Object[] elementData, int len)
/*      */   {
/*  256 */     if (elem == null)
/*  257 */       for (int i = len - 1; i >= 0; i--)
/*  258 */         if (elementData[i] == null)
/*  259 */           return i;
/*      */     else {
/*  261 */       for (int i = len - 1; i >= 0; i--)
/*  262 */         if (elem.equals(elementData[i]))
/*  263 */           return i;
/*      */     }
/*  265 */     return -1;
/*      */   }
/*      */ 
/*      */   public int lastIndexOf(Object elem, int index)
/*      */   {
/*  281 */     Object[] elementData = array();
/*  282 */     if (elem == null)
/*  283 */       for (int i = index; i >= 0; i--)
/*  284 */         if (elementData[i] == null)
/*  285 */           return i;
/*      */     else {
/*  287 */       for (int i = index; i >= 0; i--)
/*  288 */         if (elem.equals(elementData[i]))
/*  289 */           return i;
/*      */     }
/*  291 */     return -1;
/*      */   }
/*      */ 
/*      */   public Object clone()
/*      */   {
/*      */     try
/*      */     {
/*  302 */       Object[] elementData = array();
/*  303 */       CopyOnWriteArrayList v = (CopyOnWriteArrayList)super.clone();
/*  304 */       v.array_ = new Object[elementData.length];
/*  305 */       System.arraycopy(elementData, 0, v.array_, 0, elementData.length);
/*  306 */       return v;
/*      */     } catch (CloneNotSupportedException e) {
/*      */     }
/*  309 */     throw new InternalError();
/*      */   }
/*      */ 
/*      */   public Object[] toArray()
/*      */   {
/*  318 */     Object[] elementData = array();
/*  319 */     Object[] result = new Object[elementData.length];
/*  320 */     System.arraycopy(elementData, 0, result, 0, elementData.length);
/*  321 */     return result;
/*      */   }
/*      */ 
/*      */   public Object[] toArray(Object[] a)
/*      */   {
/*  346 */     Object[] elementData = array();
/*      */ 
/*  348 */     if (a.length < elementData.length) {
/*  349 */       a = (Object[])
/*  350 */         Array.newInstance(a.getClass().getComponentType(), 
/*  351 */         elementData.length);
/*      */     }
/*  353 */     System.arraycopy(elementData, 0, a, 0, elementData.length);
/*      */ 
/*  355 */     if (a.length > elementData.length) {
/*  356 */       a[elementData.length] = null;
/*      */     }
/*  358 */     return a;
/*      */   }
/*      */ 
/*      */   public Object get(int index)
/*      */   {
/*  371 */     Object[] elementData = array();
/*  372 */     rangeCheck(index, elementData.length);
/*  373 */     return elementData[index];
/*      */   }
/*      */ 
/*      */   public synchronized Object set(int index, Object element)
/*      */   {
/*  387 */     int len = this.array_.length;
/*  388 */     rangeCheck(index, len);
/*  389 */     Object oldValue = this.array_[index];
/*      */ 
/*  391 */     boolean same = (oldValue == element) || (
/*  392 */       (element != null) && (element.equals(oldValue)));
/*  393 */     if (!same) {
/*  394 */       Object[] newArray = new Object[len];
/*  395 */       System.arraycopy(this.array_, 0, newArray, 0, len);
/*  396 */       newArray[index] = element;
/*  397 */       this.array_ = newArray;
/*      */     }
/*  399 */     return oldValue;
/*      */   }
/*      */ 
/*      */   public synchronized boolean add(Object element)
/*      */   {
/*  409 */     int len = this.array_.length;
/*  410 */     Object[] newArray = new Object[len + 1];
/*  411 */     System.arraycopy(this.array_, 0, newArray, 0, len);
/*  412 */     newArray[len] = element;
/*  413 */     this.array_ = newArray;
/*  414 */     return true;
/*      */   }
/*      */ 
/*      */   public synchronized void add(int index, Object element)
/*      */   {
/*  428 */     int len = this.array_.length;
/*  429 */     if ((index > len) || (index < 0)) {
/*  430 */       throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
/*      */     }
/*  432 */     Object[] newArray = new Object[len + 1];
/*  433 */     System.arraycopy(this.array_, 0, newArray, 0, index);
/*  434 */     newArray[index] = element;
/*  435 */     System.arraycopy(this.array_, index, newArray, index + 1, len - index);
/*  436 */     this.array_ = newArray;
/*      */   }
/*      */ 
/*      */   public synchronized Object remove(int index)
/*      */   {
/*  449 */     int len = this.array_.length;
/*  450 */     rangeCheck(index, len);
/*  451 */     Object oldValue = this.array_[index];
/*  452 */     Object[] newArray = new Object[len - 1];
/*  453 */     System.arraycopy(this.array_, 0, newArray, 0, index);
/*  454 */     int numMoved = len - index - 1;
/*  455 */     if (numMoved > 0)
/*  456 */       System.arraycopy(this.array_, index + 1, newArray, index, numMoved);
/*  457 */     this.array_ = newArray;
/*  458 */     return oldValue;
/*      */   }
/*      */ 
/*      */   public synchronized boolean remove(Object element)
/*      */   {
/*  474 */     int len = this.array_.length;
/*  475 */     if (len == 0) return false;
/*      */ 
/*  480 */     int newlen = len - 1;
/*  481 */     Object[] newArray = new Object[newlen];
/*      */ 
/*  483 */     for (int i = 0; i < newlen; i++) {
/*  484 */       if ((element == this.array_[i]) || (
/*  485 */         (element != null) && (element.equals(this.array_[i]))))
/*      */       {
/*  487 */         for (int k = i + 1; k < len; k++) newArray[(k - 1)] = this.array_[k];
/*  488 */         this.array_ = newArray;
/*  489 */         return true;
/*      */       }
/*      */ 
/*  492 */       newArray[i] = this.array_[i];
/*      */     }
/*      */ 
/*  496 */     if ((element == this.array_[newlen]) || (
/*  497 */       (element != null) && (element.equals(this.array_[newlen])))) {
/*  498 */       this.array_ = newArray;
/*  499 */       return true;
/*      */     }
/*      */ 
/*  502 */     return false;
/*      */   }
/*      */ 
/*      */   public synchronized void removeRange(int fromIndex, int toIndex)
/*      */   {
/*  521 */     int len = this.array_.length;
/*      */ 
/*  523 */     if ((fromIndex < 0) || (fromIndex >= len) || 
/*  524 */       (toIndex > len) || (toIndex < fromIndex)) {
/*  525 */       throw new IndexOutOfBoundsException();
/*      */     }
/*  527 */     int numMoved = len - toIndex;
/*  528 */     int newlen = len - (toIndex - fromIndex);
/*  529 */     Object[] newArray = new Object[newlen];
/*  530 */     System.arraycopy(this.array_, 0, newArray, 0, fromIndex);
/*  531 */     System.arraycopy(this.array_, toIndex, newArray, fromIndex, numMoved);
/*  532 */     this.array_ = newArray;
/*      */   }
/*      */ 
/*      */   public synchronized boolean addIfAbsent(Object element)
/*      */   {
/*  546 */     int len = this.array_.length;
/*  547 */     Object[] newArray = new Object[len + 1];
/*  548 */     for (int i = 0; i < len; i++) {
/*  549 */       if ((element == this.array_[i]) || (
/*  550 */         (element != null) && (element.equals(this.array_[i])))) {
/*  551 */         return false;
/*      */       }
/*  553 */       newArray[i] = this.array_[i];
/*      */     }
/*  555 */     newArray[len] = element;
/*  556 */     this.array_ = newArray;
/*  557 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean containsAll(Collection c)
/*      */   {
/*  571 */     Object[] elementData = array();
/*  572 */     int len = elementData.length;
/*  573 */     Iterator e = c.iterator();
/*  574 */     while (e.hasNext()) {
/*  575 */       if (indexOf(e.next(), elementData, len) < 0)
/*  576 */         return false;
/*      */     }
/*  578 */     return true;
/*      */   }
/*      */ 
/*      */   public synchronized boolean removeAll(Collection c)
/*      */   {
/*  591 */     Object[] elementData = this.array_;
/*  592 */     int len = elementData.length;
/*  593 */     if (len == 0) return false;
/*      */ 
/*  596 */     Object[] temp = new Object[len];
/*  597 */     int newlen = 0;
/*  598 */     for (int i = 0; i < len; i++) {
/*  599 */       Object element = elementData[i];
/*  600 */       if (!c.contains(element)) {
/*  601 */         temp[(newlen++)] = element;
/*      */       }
/*      */     }
/*      */ 
/*  605 */     if (newlen == len) return false;
/*      */ 
/*  608 */     Object[] newArray = new Object[newlen];
/*  609 */     System.arraycopy(temp, 0, newArray, 0, newlen);
/*  610 */     this.array_ = newArray;
/*  611 */     return true;
/*      */   }
/*      */ 
/*      */   public synchronized boolean retainAll(Collection c)
/*      */   {
/*  622 */     Object[] elementData = this.array_;
/*  623 */     int len = elementData.length;
/*  624 */     if (len == 0) return false;
/*      */ 
/*  626 */     Object[] temp = new Object[len];
/*  627 */     int newlen = 0;
/*  628 */     for (int i = 0; i < len; i++) {
/*  629 */       Object element = elementData[i];
/*  630 */       if (c.contains(element)) {
/*  631 */         temp[(newlen++)] = element;
/*      */       }
/*      */     }
/*      */ 
/*  635 */     if (newlen == len) return false;
/*      */ 
/*  637 */     Object[] newArray = new Object[newlen];
/*  638 */     System.arraycopy(temp, 0, newArray, 0, newlen);
/*  639 */     this.array_ = newArray;
/*  640 */     return true;
/*      */   }
/*      */ 
/*      */   public synchronized int addAllAbsent(Collection c)
/*      */   {
/*  654 */     int numNew = c.size();
/*  655 */     if (numNew == 0) return 0;
/*      */ 
/*  657 */     Object[] elementData = this.array_;
/*  658 */     int len = elementData.length;
/*      */ 
/*  660 */     Object[] temp = new Object[numNew];
/*  661 */     int added = 0;
/*  662 */     Iterator e = c.iterator();
/*  663 */     while (e.hasNext()) {
/*  664 */       Object element = e.next();
/*  665 */       if ((indexOf(element, elementData, len) >= 0) || 
/*  666 */         (indexOf(element, temp, added) >= 0)) continue;
/*  667 */       temp[(added++)] = element;
/*      */     }
/*      */ 
/*  672 */     if (added == 0) return 0;
/*      */ 
/*  674 */     Object[] newArray = new Object[len + added];
/*  675 */     System.arraycopy(elementData, 0, newArray, 0, len);
/*  676 */     System.arraycopy(temp, 0, newArray, len, added);
/*  677 */     this.array_ = newArray;
/*  678 */     return added;
/*      */   }
/*      */ 
/*      */   public synchronized void clear()
/*      */   {
/*  686 */     this.array_ = new Object[0];
/*      */   }
/*      */ 
/*      */   public synchronized boolean addAll(Collection c)
/*      */   {
/*  697 */     int numNew = c.size();
/*  698 */     if (numNew == 0) return false;
/*      */ 
/*  700 */     int len = this.array_.length;
/*  701 */     Object[] newArray = new Object[len + numNew];
/*  702 */     System.arraycopy(this.array_, 0, newArray, 0, len);
/*  703 */     Iterator e = c.iterator();
/*  704 */     for (int i = 0; i < numNew; i++)
/*  705 */       newArray[(len++)] = e.next();
/*  706 */     this.array_ = newArray;
/*      */ 
/*  708 */     return true;
/*      */   }
/*      */ 
/*      */   public synchronized boolean addAll(int index, Collection c)
/*      */   {
/*  726 */     int len = this.array_.length;
/*  727 */     if ((index > len) || (index < 0)) {
/*  728 */       throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
/*      */     }
/*  730 */     int numNew = c.size();
/*  731 */     if (numNew == 0) return false;
/*      */ 
/*  733 */     Object[] newArray = new Object[len + numNew];
/*  734 */     System.arraycopy(this.array_, 0, newArray, 0, len);
/*  735 */     int numMoved = len - index;
/*  736 */     if (numMoved > 0)
/*  737 */       System.arraycopy(this.array_, index, newArray, index + numNew, numMoved);
/*  738 */     Iterator e = c.iterator();
/*  739 */     for (int i = 0; i < numNew; i++)
/*  740 */       newArray[(index++)] = e.next();
/*  741 */     this.array_ = newArray;
/*      */ 
/*  743 */     return true;
/*      */   }
/*      */ 
/*      */   protected void rangeCheck(int index, int length)
/*      */   {
/*  751 */     if ((index >= length) || (index < 0))
/*  752 */       throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream s)
/*      */     throws IOException
/*      */   {
/*  764 */     s.defaultWriteObject();
/*      */ 
/*  766 */     Object[] elementData = array();
/*      */ 
/*  768 */     s.writeInt(elementData.length);
/*      */ 
/*  771 */     for (int i = 0; i < elementData.length; i++)
/*  772 */       s.writeObject(elementData[i]);
/*      */   }
/*      */ 
/*      */   private synchronized void readObject(ObjectInputStream s)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/*  781 */     s.defaultReadObject();
/*      */ 
/*  784 */     int arrayLength = s.readInt();
/*  785 */     Object[] elementData = new Object[arrayLength];
/*      */ 
/*  788 */     for (int i = 0; i < elementData.length; i++)
/*  789 */       elementData[i] = s.readObject();
/*  790 */     this.array_ = elementData;
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  798 */     StringBuffer buf = new StringBuffer();
/*  799 */     Iterator e = iterator();
/*  800 */     buf.append("[");
/*  801 */     int maxIndex = size() - 1;
/*  802 */     for (int i = 0; i <= maxIndex; i++) {
/*  803 */       buf.append(String.valueOf(e.next()));
/*  804 */       if (i < maxIndex)
/*  805 */         buf.append(", ");
/*      */     }
/*  807 */     buf.append("]");
/*  808 */     return buf.toString();
/*      */   }
/*      */ 
/*      */   public boolean equals(Object o)
/*      */   {
/*  834 */     if (o == this)
/*  835 */       return true;
/*  836 */     if (!(o instanceof Serializable)) {
/*  837 */       return false;
/*      */     }
/*  839 */     List l2 = (Serializable)o;
/*  840 */     if (size() != l2.size()) {
/*  841 */       return false;
/*      */     }
/*  843 */     ListIterator e1 = listIterator();
/*  844 */     ListIterator e2 = l2.listIterator();
/*  845 */     while (e1.hasNext()) {
/*  846 */       Object o1 = e1.next();
/*  847 */       Object o2 = e2.next();
/*  848 */       if (o1 == null ? o2 != null : !o1.equals(o2))
/*  849 */         return false;
/*      */     }
/*  851 */     return true;
/*      */   }
/*      */ 
/*      */   public int hashCode()
/*      */   {
/*  861 */     int hashCode = 1;
/*  862 */     Iterator i = iterator();
/*  863 */     while (i.hasNext()) {
/*  864 */       Object obj = i.next();
/*  865 */       hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
/*      */     }
/*  867 */     return hashCode;
/*      */   }
/*      */ 
/*      */   public Iterator iterator()
/*      */   {
/*  878 */     return new COWIterator(array(), 0);
/*      */   }
/*      */ 
/*      */   public ListIterator listIterator()
/*      */   {
/*  892 */     return new COWIterator(array(), 0);
/*      */   }
/*      */ 
/*      */   public ListIterator listIterator(int index)
/*      */   {
/*  911 */     Object[] elementData = array();
/*  912 */     int len = elementData.length;
/*  913 */     if ((index < 0) || (index > len)) {
/*  914 */       throw new IndexOutOfBoundsException("Index: " + index);
/*      */     }
/*  916 */     return new COWIterator(array(), index);
/*      */   }
/*      */ 
/*      */   public synchronized List subList(int fromIndex, int toIndex)
/*      */   {
/* 1018 */     int len = this.array_.length;
/* 1019 */     if ((fromIndex < 0) || (toIndex > len) || (fromIndex > toIndex))
/* 1020 */       throw new IndexOutOfBoundsException();
/* 1021 */     return new COWSubList(this, fromIndex, toIndex);
/*      */   }
/*      */ 
/*      */   protected static class COWIterator
/*      */     implements ListIterator
/*      */   {
/*      */     protected final Object[] array;
/*      */     protected int cursor;
/*      */ 
/*      */     protected COWIterator(Object[] elementArray, int initialCursor)
/*      */     {
/*  930 */       this.array = elementArray;
/*  931 */       this.cursor = initialCursor;
/*      */     }
/*      */ 
/*      */     public boolean hasNext() {
/*  935 */       return this.cursor < this.array.length;
/*      */     }
/*      */ 
/*      */     public boolean hasPrevious() {
/*  939 */       return this.cursor > 0;
/*      */     }
/*      */ 
/*      */     public Object next() {
/*      */       try {
/*  944 */         return this.array[(this.cursor++)];
/*      */       } catch (IndexOutOfBoundsException ex) {
/*      */       }
/*  947 */       throw new NoSuchElementException();
/*      */     }
/*      */ 
/*      */     public Object previous()
/*      */     {
/*      */       try {
/*  953 */         return this.array[(--this.cursor)]; } catch (IndexOutOfBoundsException e) {
/*      */       }
/*  955 */       throw new NoSuchElementException();
/*      */     }
/*      */ 
/*      */     public int nextIndex()
/*      */     {
/*  960 */       return this.cursor;
/*      */     }
/*      */ 
/*      */     public int previousIndex() {
/*  964 */       return this.cursor - 1;
/*      */     }
/*      */ 
/*      */     public void remove()
/*      */     {
/*  974 */       throw new UnsupportedOperationException();
/*      */     }
/*      */ 
/*      */     public void set(Object o)
/*      */     {
/*  983 */       throw new UnsupportedOperationException();
/*      */     }
/*      */ 
/*      */     public void add(Object o)
/*      */     {
/*  992 */       throw new UnsupportedOperationException();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected static class COWSubList extends AbstractList
/*      */   {
/*      */     protected final CopyOnWriteArrayList l;
/*      */     protected final int offset;
/*      */     protected int size;
/*      */     protected Object[] expectedArray;
/*      */ 
/*      */     protected COWSubList(CopyOnWriteArrayList list, int fromIndex, int toIndex)
/*      */     {
/* 1053 */       this.l = list;
/* 1054 */       this.expectedArray = this.l.array();
/* 1055 */       this.offset = fromIndex;
/* 1056 */       this.size = (toIndex - fromIndex);
/*      */     }
/*      */ 
/*      */     protected void checkForComodification()
/*      */     {
/* 1061 */       if (this.l.array_ != this.expectedArray)
/* 1062 */         throw new ConcurrentModificationException();
/*      */     }
/*      */ 
/*      */     protected void rangeCheck(int index)
/*      */     {
/* 1067 */       if ((index < 0) || (index >= this.size))
/* 1068 */         throw new IndexOutOfBoundsException("Index: " + index + 
/* 1069 */           ",Size: " + this.size);
/*      */     }
/*      */ 
/*      */     public Object set(int index, Object element)
/*      */     {
/* 1074 */       synchronized (this.l) {
/* 1075 */         rangeCheck(index);
/* 1076 */         checkForComodification();
/* 1077 */         Object x = this.l.set(index + this.offset, element);
/* 1078 */         this.expectedArray = this.l.array_;
/* 1079 */         return x;
/*      */       }
/*      */     }
/*      */ 
/*      */     public Object get(int index) {
/* 1084 */       synchronized (this.l) {
/* 1085 */         rangeCheck(index);
/* 1086 */         checkForComodification();
/* 1087 */         return this.l.get(index + this.offset);
/*      */       }
/*      */     }
/*      */ 
/*      */     public int size() {
/* 1092 */       synchronized (this.l) {
/* 1093 */         checkForComodification();
/* 1094 */         return this.size;
/*      */       }
/*      */     }
/*      */ 
/*      */     public void add(int index, Object element) {
/* 1099 */       synchronized (this.l) {
/* 1100 */         checkForComodification();
/* 1101 */         if ((index < 0) || (index > this.size))
/* 1102 */           throw new IndexOutOfBoundsException();
/* 1103 */         this.l.add(index + this.offset, element);
/* 1104 */         this.expectedArray = this.l.array_;
/* 1105 */         this.size += 1;
/*      */       }
/*      */     }
/*      */ 
/*      */     public Object remove(int index) {
/* 1110 */       synchronized (this.l) {
/* 1111 */         rangeCheck(index);
/* 1112 */         checkForComodification();
/* 1113 */         Object result = this.l.remove(index + this.offset);
/* 1114 */         this.expectedArray = this.l.array_;
/* 1115 */         this.size -= 1;
/* 1116 */         return result;
/*      */       }
/*      */     }
/*      */ 
/*      */     public Iterator iterator() {
/* 1121 */       synchronized (this.l) {
/* 1122 */         checkForComodification();
/* 1123 */         return new COWSubListIterator(0);
/*      */       }
/*      */     }
/*      */ 
/*      */     public ListIterator listIterator(int index) {
/* 1128 */       synchronized (this.l) {
/* 1129 */         checkForComodification();
/* 1130 */         if ((index < 0) || (index > this.size))
/* 1131 */           throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
/* 1132 */         return new COWSubListIterator(index);
/*      */       }
/*      */     }
/*      */ 
/*      */     public List subList(int fromIndex, int toIndex)
/*      */     {
/* 1189 */       synchronized (this.l) {
/* 1190 */         checkForComodification();
/* 1191 */         if ((fromIndex < 0) || (toIndex > this.size))
/* 1192 */           throw new IndexOutOfBoundsException();
/* 1193 */         return new COWSubList(this.l, fromIndex + this.offset, toIndex + this.offset);
/*      */       }
/*      */     }
/*      */ 
/*      */     protected class COWSubListIterator
/*      */       implements ListIterator
/*      */     {
/*      */       protected final ListIterator i;
/*      */       protected final int index;
/*      */ 
/*      */       protected COWSubListIterator(int index)
/*      */       {
/* 1140 */         this.index = index;
/* 1141 */         this.i = CopyOnWriteArrayList.COWSubList.this.l.listIterator(index + CopyOnWriteArrayList.COWSubList.this.offset);
/*      */       }
/*      */ 
/*      */       public boolean hasNext() {
/* 1145 */         return nextIndex() < CopyOnWriteArrayList.COWSubList.this.size;
/*      */       }
/*      */ 
/*      */       public Object next() {
/* 1149 */         if (hasNext()) {
/* 1150 */           return this.i.next();
/*      */         }
/* 1152 */         throw new NoSuchElementException();
/*      */       }
/*      */ 
/*      */       public boolean hasPrevious() {
/* 1156 */         return previousIndex() >= 0;
/*      */       }
/*      */ 
/*      */       public Object previous() {
/* 1160 */         if (hasPrevious()) {
/* 1161 */           return this.i.previous();
/*      */         }
/* 1163 */         throw new NoSuchElementException();
/*      */       }
/*      */ 
/*      */       public int nextIndex() {
/* 1167 */         return this.i.nextIndex() - CopyOnWriteArrayList.COWSubList.this.offset;
/*      */       }
/*      */ 
/*      */       public int previousIndex() {
/* 1171 */         return this.i.previousIndex() - CopyOnWriteArrayList.COWSubList.this.offset;
/*      */       }
/*      */ 
/*      */       public void remove() {
/* 1175 */         throw new UnsupportedOperationException();
/*      */       }
/*      */ 
/*      */       public void set(Object o) {
/* 1179 */         throw new UnsupportedOperationException();
/*      */       }
/*      */ 
/*      */       public void add(Object o) {
/* 1183 */         throw new UnsupportedOperationException();
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList
 * JD-Core Version:    0.6.0
 */