/*     */ package EDU.oswego.cs.dl.util.concurrent;
/*     */ 
/*     */ import java.util.Date;
/*     */ 
/*     */ public class ClockDaemon extends ThreadFactoryUser
/*     */ {
/*  57 */   protected final Heap heap_ = new Heap(DefaultChannelCapacity.get());
/*     */   protected Thread thread_;
/*     */   protected final RunLoop runLoop_;
/*     */ 
/*     */   public Object executeAt(Date date, Runnable command)
/*     */   {
/* 103 */     TaskNode task = new TaskNode(date.getTime(), command);
/* 104 */     this.heap_.insert(task);
/* 105 */     restart();
/* 106 */     return task;
/*     */   }
/*     */ 
/*     */   public Object executeAfterDelay(long millisecondsToDelay, Runnable command)
/*     */   {
/* 161 */     long runtime = System.currentTimeMillis() + millisecondsToDelay;
/* 162 */     TaskNode task = new TaskNode(runtime, command);
/* 163 */     this.heap_.insert(task);
/* 164 */     restart();
/* 165 */     return task;
/*     */   }
/*     */ 
/*     */   public Object executePeriodically(long period, Runnable command, boolean startNow)
/*     */   {
/* 228 */     if (period <= 0L) throw new IllegalArgumentException();
/*     */ 
/* 230 */     long firstTime = System.currentTimeMillis();
/* 231 */     if (!startNow) firstTime += period;
/*     */ 
/* 233 */     TaskNode task = new TaskNode(firstTime, command, period);
/* 234 */     this.heap_.insert(task);
/* 235 */     restart();
/* 236 */     return task;
/*     */   }
/*     */ 
/*     */   public static void cancel(Object taskID)
/*     */   {
/* 253 */     ((TaskNode)taskID).setCancelled();
/*     */   }
/*     */ 
/*     */   public synchronized Thread getThread()
/*     */   {
/* 268 */     return this.thread_;
/*     */   }
/*     */ 
/*     */   protected synchronized void clearThread()
/*     */   {
/* 273 */     this.thread_ = null;
/*     */   }
/*     */ 
/*     */   public synchronized void restart()
/*     */   {
/* 284 */     if (this.thread_ == null) {
/* 285 */       this.thread_ = this.threadFactory_.newThread(this.runLoop_);
/* 286 */       this.thread_.start();
/*     */     }
/*     */     else {
/* 289 */       notify();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void shutDown()
/*     */   {
/* 302 */     this.heap_.clear();
/* 303 */     if (this.thread_ != null)
/* 304 */       this.thread_.interrupt();
/* 305 */     this.thread_ = null;
/*     */   }
/*     */ 
/*     */   protected synchronized TaskNode nextTask()
/*     */   {
/*     */     try
/*     */     {
/* 314 */       while (!Thread.interrupted())
/*     */       {
/* 318 */         TaskNode task = (TaskNode)this.heap_.peek();
/*     */ 
/* 320 */         if (task == null) {
/* 321 */           wait();
/*     */         }
/*     */         else {
/* 324 */           long now = System.currentTimeMillis();
/* 325 */           long when = task.getTimeToRun();
/*     */ 
/* 327 */           if (when > now) {
/* 328 */             wait(when - now);
/*     */           }
/*     */           else {
/* 331 */             task = (TaskNode)this.heap_.extract();
/*     */ 
/* 333 */             if (task.getCancelled())
/*     */               continue;
/* 335 */             if (task.period > 0L) {
/* 336 */               task.setTimeToRun(now + task.period);
/* 337 */               this.heap_.insert(task);
/*     */             }
/*     */ 
/* 340 */             return task;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */     catch (InterruptedException localInterruptedException)
/*     */     {
/*     */     }
/* 348 */     return null;
/*     */   }
/*     */ 
/*     */   public ClockDaemon()
/*     */   {
/* 382 */     this.runLoop_ = new RunLoop();
/*     */   }
/*     */ 
/*     */   protected class RunLoop
/*     */     implements Runnable
/*     */   {
/*     */     protected RunLoop()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void run()
/*     */     {
/*     */       try
/*     */       {
/* 362 */         ClockDaemon.TaskNode task = ClockDaemon.this.nextTask();
/* 363 */         if (task != null) {
/* 364 */           task.command.run();
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/* 370 */         ClockDaemon.this.clearThread();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static class TaskNode
/*     */     implements Comparable
/*     */   {
/*     */     final Runnable command;
/*     */     final long period;
/*     */     private long timeToRun_;
/*  69 */     private boolean cancelled_ = false;
/*     */ 
/*     */     synchronized void setCancelled()
/*     */     {
/*  74 */       this.cancelled_ = true; } 
/*  75 */     synchronized boolean getCancelled() { return this.cancelled_; } 
/*     */     synchronized void setTimeToRun(long w) {
/*  77 */       this.timeToRun_ = w; } 
/*  78 */     synchronized long getTimeToRun() { return this.timeToRun_; }
/*     */ 
/*     */     public int compareTo(Object other)
/*     */     {
/*  82 */       long a = getTimeToRun();
/*  83 */       long b = ((TaskNode)other).getTimeToRun();
/*  84 */       return a == b ? 0 : a < b ? -1 : 1;
/*     */     }
/*     */ 
/*     */     TaskNode(long w, Runnable c, long p) {
/*  88 */       this.timeToRun_ = w; this.command = c; this.period = p;
/*     */     }
/*     */     TaskNode(long w, Runnable c) {
/*  91 */       this(w, c, -1L);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     EDU.oswego.cs.dl.util.concurrent.ClockDaemon
 * JD-Core Version:    0.6.0
 */