/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.TypeBinding;
import org.jboss.xb.binding.Util;
import org.jboss.xb.binding.introspection.FieldInfo;

public class MappingObjectModelProvider
implements GenericObjectModelProvider {
    private static final Logger log = Logger.getLogger(MappingObjectModelProvider.class);
    private final Map classMappings = new HashMap();
    private final Map fieldMappings = new HashMap();
    private boolean ignoreLowLine = true;
    private boolean ignoreNotFoundField = true;

    public boolean isIgnoreNotFoundField() {
        return this.ignoreNotFoundField;
    }

    public void setIgnoreNotFoundField(boolean ignoreNotFoundField) {
        this.ignoreNotFoundField = ignoreNotFoundField;
    }

    public void mapClassToElement(Class cls, String namespaceURI, String localName, ObjectModelProvider provider) {
        ClassToElementMapping mapping = new ClassToElementMapping(cls, namespaceURI, localName, provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
        this.classMappings.put(mapping.cls, mapping);
    }

    public void mapFieldToElement(Class cls, String field, String namespaceURI, String localName, TypeBinding converter) {
        FieldToElementMapping mapping = new FieldToElementMapping(cls, field, namespaceURI, localName, converter);
        this.mapFieldToElement(mapping);
    }

    public boolean isIgnoreLowLine() {
        return this.ignoreLowLine;
    }

    public void setIgnoreLowLine(boolean ignoreLowLine) {
        this.ignoreLowLine = ignoreLowLine;
    }

    public Object getChildren(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        Object children = null;
        if (!this.writeAsValue(o.getClass())) {
            children = this.getJavaValue(namespaceURI, localName, null, o, true, this.ignoreNotFoundField);
        }
        return children;
    }

    public Object getElementValue(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        Object value;
        if (this.writeAsValue(o.getClass())) {
            value = o;
        } else {
            String fieldName = null;
            if (ctx != null && ctx.isTypeComplex()) {
                fieldName = ctx.getSimpleContentProperty();
            }
            try {
                value = this.getJavaValue(namespaceURI, localName, fieldName, o, false, false);
            }
            catch (JBossXBRuntimeException e) {
                value = this.getJavaValue(namespaceURI, localName, null, o, false, this.ignoreNotFoundField);
            }
        }
        return value;
    }

    public Object getAttributeValue(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        boolean optional = ctx == null ? this.ignoreNotFoundField : !ctx.isAttributeRequired() || this.ignoreNotFoundField;
        return this.getJavaValue(namespaceURI, localName, null, o, false, optional);
    }

    public Object getRoot(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        return o;
    }

    private void mapFieldToElement(FieldToElementMapping mapping) {
        String mappingKey = mapping.cls.getName() + ":" + mapping.localName;
        this.fieldMappings.put(mappingKey, mapping);
    }

    private Object getJavaValue(String namespaceURI, String localName, String fieldName, Object o, boolean forComplexType, boolean optional) {
        String mappingKey = o.getClass().getName() + ":" + localName;
        FieldToElementMapping mapping = (FieldToElementMapping)this.fieldMappings.get(mappingKey);
        if (mapping == null) {
            if (fieldName == null) {
                fieldName = Util.xmlNameToFieldName(localName, this.ignoreLowLine);
            }
            try {
                mapping = new FieldToElementMapping(o.getClass(), fieldName, namespaceURI, localName, null);
                this.mapFieldToElement(mapping);
            }
            catch (JBossXBRuntimeException e) {
                if (optional) {
                    if (log.isTraceEnabled()) {
                        log.trace(e.getMessage());
                    }
                }
                throw e;
            }
        }
        FieldInfo fieldInfo = null;
        if (mapping != null) {
            fieldInfo = mapping.fieldInfo;
        }
        Object value = null;
        if (fieldInfo != null && (!forComplexType || forComplexType && !this.writeAsValue(fieldInfo.getType()))) {
            value = fieldInfo.getValue(o);
        }
        if (value != null && mapping != null && mapping.converter != null) {
            value = mapping.converter.marshal(value);
        }
        return value;
    }

    private boolean writeAsValue(Class type) {
        return Classes.isPrimitive(type) || type == String.class || type == Date.class || type == BigDecimal.class || type == BigInteger.class;
    }

    private class FieldToElementMapping {
        public final Class cls;
        public final String namespaceURI;
        public final String localName;
        public final TypeBinding converter;
        public final FieldInfo fieldInfo;

        public FieldToElementMapping(Class cls, String field, String namespaceURI, String localName, TypeBinding converter) {
            this.cls = cls;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.converter = converter;
            if (log.isTraceEnabled()) {
                log.trace("new FieldToElementMapping: [cls=" + cls.getName() + ",field=" + field + ",qname=" + new QName(namespaceURI, localName) + "]");
            }
            this.fieldInfo = FieldInfo.getFieldInfo(cls, field, true);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldToElementMapping)) {
                return false;
            }
            FieldToElementMapping fieldToElementMapping = (FieldToElementMapping)o;
            if (this.cls != null ? !this.cls.equals(fieldToElementMapping.cls) : fieldToElementMapping.cls != null) {
                return false;
            }
            if (!this.fieldInfo.getName().equals(fieldToElementMapping.fieldInfo.getName())) {
                return false;
            }
            if (this.localName != null ? !this.localName.equals(fieldToElementMapping.localName) : fieldToElementMapping.localName != null) {
                return false;
            }
            return !(this.namespaceURI != null ? !this.namespaceURI.equals(fieldToElementMapping.namespaceURI) : fieldToElementMapping.namespaceURI != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + this.fieldInfo.getName().hashCode();
            result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
            result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
            return result;
        }
    }

    private class ClassToElementMapping {
        public final Class cls;
        public final String namespaceURI;
        public final String localName;
        public final GenericObjectModelProvider provider;

        public ClassToElementMapping(Class cls, String namespaceURI, String localName, GenericObjectModelProvider provider) {
            this.cls = cls;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.provider = provider;
            if (log.isTraceEnabled()) {
                log.trace("new ClassToElementMapping: [cls=" + cls.getName() + ",qname=" + new QName(namespaceURI, localName) + "]");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassToElementMapping)) {
                return false;
            }
            ClassToElementMapping classToElementMapping = (ClassToElementMapping)o;
            if (this.cls != null ? !this.cls.equals(classToElementMapping.cls) : classToElementMapping.cls != null) {
                return false;
            }
            if (this.localName != null ? !this.localName.equals(classToElementMapping.localName) : classToElementMapping.localName != null) {
                return false;
            }
            return !(this.namespaceURI != null ? !this.namespaceURI.equals(classToElementMapping.namespaceURI) : classToElementMapping.namespaceURI != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
            result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
            return result;
        }
    }
}

