/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSModelImpl;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.utils.JBossWSEntityResolver;
import org.jboss.ws.core.utils.ResourceURL;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSEntityResolver;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSErrorHandler;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xmlschema.WSSchemaUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.helpers.JavaToXSDHelper;
import org.jboss.ws.tools.interfaces.JavaToXSDIntf;
import org.jboss.ws.tools.interfaces.SchemaCreatorIntf;
import org.jboss.xb.binding.sunday.unmarshalling.LSInputAdaptor;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaToXSD
implements JavaToXSDIntf {
    private static final Logger log = Logger.getLogger(JavaToXSD.class);
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected SchemaUtils schemautils = SchemaUtils.getInstance();
    protected String jaxrpcAssert = "JAXRPC2.0 Assertion:";
    protected JavaToXSDHelper helper = new JavaToXSDHelper();

    public JavaToXSD() {
        SchemaCreatorIntf creator = this.helper.getSchemaCreator();
        JBossXSModel xsmodel = creator.getXSModel();
        if (xsmodel == null) {
            creator.setXSModel(new JBossXSModel());
        }
    }

    @Override
    public JBossXSModel generateForSingleType(QName xmlType, Class javaType) throws IOException {
        SchemaCreatorIntf creator = this.helper.getSchemaCreator();
        creator.generateType(xmlType, javaType);
        return creator.getXSModel();
    }

    @Override
    public JBossXSModel generateForSingleType(QName xmlType, Class javaType, Map<String, QName> elementNames) throws IOException {
        SchemaCreatorIntf creator = this.helper.getSchemaCreator();
        creator.generateType(xmlType, javaType, elementNames);
        return creator.getXSModel();
    }

    @Override
    public SchemaCreatorIntf getSchemaCreator() {
        return this.helper.getSchemaCreator();
    }

    public JBossXSModel parseSchema(URL xsdURL) {
        JBossXSErrorHandler xserr = new JBossXSErrorHandler();
        JBossWSEntityResolver resolver = new JBossWSEntityResolver();
        JBossXSEntityResolver xsresolve = new JBossXSEntityResolver(resolver, new HashMap<String, URL>());
        XMLSchemaLoader loader = (XMLSchemaLoader)this.schemautils.getXSLoader(xserr, xsresolve);
        XSModel xsmodel = loader.loadURI(xsdURL.toExternalForm());
        if (xsmodel == null) {
            throw new WSException("Cannot load schema: " + xsdURL);
        }
        WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
        JBossXSModel jbxs = new JBossXSModel();
        sutils.copyXSModel(xsmodel, jbxs);
        return jbxs;
    }

    public JBossXSModel parseSchema(Map<String, URL> locs) {
        if (locs == null || locs.size() == 0) {
            throw new IllegalArgumentException("Illegal schema location map");
        }
        JBossXSErrorHandler xserr = new JBossXSErrorHandler();
        JBossWSEntityResolver resolver = new JBossWSEntityResolver();
        JBossXSEntityResolver xsresolve = new JBossXSEntityResolver(resolver, locs);
        XMLSchemaLoader loader = (XMLSchemaLoader)this.schemautils.getXSLoader(xserr, xsresolve);
        int index = 0;
        SchemaGrammar[] gs = new SchemaGrammar[locs.size()];
        Iterator<String> it = locs.keySet().iterator();
        while (it.hasNext()) {
            try {
                String nsURI = it.next();
                URL orgURL = locs.get(nsURI);
                URL resURL = this.resolveNamespaceURI(resolver, nsURI);
                URL url = resURL != null ? resURL : orgURL;
                log.debug("Load schema: " + nsURI + "=" + url);
                XMLInputSource inputSource = new XMLInputSource(null, url.toExternalForm(), null);
                InputSource tmpSrc = resolver.resolveEntity(null, url.toExternalForm());
                InputStream in = tmpSrc.getByteStream() != null ? tmpSrc.getByteStream() : new ResourceURL(url).openStream();
                inputSource.setByteStream(in);
                SchemaGrammar grammar = (SchemaGrammar)loader.loadGrammar(inputSource);
                if (grammar == null) {
                    throw new IllegalStateException("Cannot load grammar: " + url);
                }
                gs[index++] = grammar;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot parse schema", ex);
            }
        }
        XSModelImpl xsmodel = new XSModelImpl(gs);
        WSSchemaUtils sutils = WSSchemaUtils.getInstance(null, null);
        JBossXSModel jbxs = new JBossXSModel();
        sutils.copyXSModel((XSModel)xsmodel, jbxs);
        return jbxs;
    }

    private URL resolveNamespaceURI(JBossWSEntityResolver resolver, String nsURI) {
        ClassLoader loader;
        URL url = null;
        String resource = (String)resolver.getEntityMap().get(nsURI);
        if (resource != null && (url = (loader = Thread.currentThread().getContextClassLoader()).getResource(resource)) == null) {
            if (resource.endsWith(".dtd")) {
                resource = "dtd/" + resource;
            } else if (resource.endsWith(".xsd")) {
                resource = "schema/" + resource;
            }
            url = loader.getResource(resource);
        }
        return url;
    }

    @Override
    public void setPackageNamespaceMap(Map<String, String> map) {
        this.helper.setPackageNamespaceMap(map);
    }

    @Override
    public void setWSDLStyle(String style) {
        this.helper.setWsdlStyle(style);
    }

    private SchemaBindingResolver getSchemaBindingResolver(final Map<String, URL> map) {
        return new SchemaBindingResolver(){

            public String getBaseURI() {
                throw new UnsupportedOperationException("getBaseURI is not implemented.");
            }

            public void setBaseURI(String baseURI) {
                throw new UnsupportedOperationException("setBaseURI is not implemented.");
            }

            public SchemaBinding resolve(String nsUri, String baseURI, String schemaLocation) {
                throw new UnsupportedOperationException("resolve is not implemented.");
            }

            public LSInput resolveAsLSInput(String nsUri, String baseUri, String schemaLocation) {
                URL url = (URL)map.get(nsUri);
                if (url != null) {
                    try {
                        return new LSInputAdaptor(url.openStream(), null);
                    }
                    catch (IOException e) {
                        log.error("URL is bad for schema parsing");
                    }
                }
                return null;
            }
        };
    }
}

