/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap.attachment;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.internet.MimeMultipart;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import org.jboss.util.Base64;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.attachment.ContentHandlerRegistry;
import org.jboss.wsf.common.IOUtils;

public class AttachmentPartImpl
extends AttachmentPart {
    private MimeHeaders mimeHeaders = new MimeHeaders();
    private DataHandler dataHandler;
    private String cachedContentId;
    private String cachedContentType;
    private String cachedContentLocation;

    public AttachmentPartImpl() {
    }

    public AttachmentPartImpl(DataHandler handler) {
        this.dataHandler = handler;
    }

    private void clearHeaderCache() {
        this.cachedContentId = null;
        this.cachedContentType = null;
        this.cachedContentLocation = null;
    }

    public void addMimeHeader(String name, String value) {
        this.clearHeaderCache();
        this.mimeHeaders.addHeader(name, value);
    }

    public void clearContent() {
        this.dataHandler = null;
    }

    public Iterator getAllMimeHeaders() {
        this.clearHeaderCache();
        return this.mimeHeaders.getAllHeaders();
    }

    public Object getContent() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No content available");
        }
        try {
            return this.dataHandler.getContent();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public DataHandler getDataHandler() throws SOAPException {
        if (this.dataHandler == null) {
            throw new SOAPException("No data handler on attachment");
        }
        return this.dataHandler;
    }

    public Iterator getMatchingMimeHeaders(String[] names) {
        this.clearHeaderCache();
        return this.mimeHeaders.getMatchingHeaders(names);
    }

    public String[] getMimeHeader(String name) {
        return this.mimeHeaders.getHeader(name);
    }

    public String getFirstMimeHeader(String header) {
        String[] values = this.mimeHeaders.getHeader(header.toLowerCase());
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Iterator getNonMatchingMimeHeaders(String[] names) {
        this.clearHeaderCache();
        return this.mimeHeaders.getNonMatchingHeaders(names);
    }

    public int getSize() throws SOAPException {
        if (this.dataHandler == null) {
            return 0;
        }
        try {
            if (!(this.dataHandler.getDataSource() instanceof ByteArrayDataSource)) {
                this.dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(this.dataHandler.getInputStream(), this.dataHandler.getContentType()));
            }
            ByteArrayDataSource ds = (ByteArrayDataSource)this.dataHandler.getDataSource();
            return ds.getSize();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void removeAllMimeHeaders() {
        this.clearHeaderCache();
        this.mimeHeaders.removeAllHeaders();
    }

    public void removeMimeHeader(String name) {
        this.clearHeaderCache();
        this.mimeHeaders.removeHeader(name);
    }

    public void setContent(Object object, String contentType) {
        if (object instanceof MimeMultipart) {
            contentType = ((MimeMultipart)object).getContentType();
        }
        this.dataHandler = new DataHandler(object, contentType);
        this.setContentType(contentType);
    }

    public void setDataHandler(DataHandler dataHandler) {
        if (dataHandler == null) {
            throw new IllegalArgumentException("Null data handler");
        }
        this.dataHandler = dataHandler;
        this.setContentType(dataHandler.getContentType());
    }

    public void setMimeHeader(String name, String value) {
        this.clearHeaderCache();
        this.mimeHeaders.setHeader(name, value);
    }

    public String getContentId() {
        if (this.cachedContentId == null) {
            this.cachedContentId = this.getFirstMimeHeader("Content-Id");
        }
        return this.cachedContentId;
    }

    public String getContentLocation() {
        if (this.cachedContentLocation == null) {
            this.cachedContentLocation = this.getFirstMimeHeader("Content-Location");
        }
        return this.cachedContentLocation;
    }

    public String getContentType() {
        if (this.cachedContentType == null) {
            this.cachedContentType = this.getFirstMimeHeader("Content-Type");
        }
        return this.cachedContentType;
    }

    public void setContentId(String contentId) {
        this.setMimeHeader("Content-Id", contentId);
        this.cachedContentId = contentId;
    }

    public void setContentLocation(String contentLocation) {
        this.setMimeHeader("Content-Location", contentLocation);
        this.cachedContentLocation = contentLocation;
    }

    public void setContentType(String contentType) {
        this.setMimeHeader("Content-Type", contentType);
        this.cachedContentType = contentType;
    }

    public InputStream getBase64Content() throws SOAPException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            IOUtils.copyStream((OutputStream)bout, (InputStream)this.getDataHandler().getInputStream());
            String base64 = Base64.encodeBytes(bout.toByteArray());
            return new ByteArrayInputStream(base64.getBytes());
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public InputStream getRawContent() throws SOAPException {
        try {
            return this.getDataHandler().getInputStream();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public byte[] getRawContentBytes() throws SOAPException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            IOUtils.copyStream((OutputStream)bout, (InputStream)this.getDataHandler().getInputStream());
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void setBase64Content(InputStream content, String contentType) throws SOAPException {
        if (null == content) {
            throw new SOAPException("Content is null");
        }
        try {
            byte[] raw;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IOUtils.copyStream((OutputStream)bout, (InputStream)content);
            content.close();
            byte[] bytes = bout.toByteArray();
            try {
                raw = Base64.decode(bytes, 0, bytes.length);
            }
            catch (Throwable e) {
                throw new SOAPException(e);
            }
            this.dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(raw, contentType));
            this.setContentType(contentType);
        }
        catch (IOException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    public void setRawContent(InputStream content, String contentType) throws SOAPException {
        if (null == content) {
            throw new SOAPException("Content is null");
        }
        this.dataHandler = new DataHandler((DataSource)new ByteArrayDataSource(content, contentType));
        this.setContentType(contentType);
    }

    public void setRawContentBytes(byte[] content, int offset, int len, String contentType) throws SOAPException {
        this.setRawContent(new ByteArrayInputStream(content, offset, len), contentType);
    }

    static {
        ContentHandlerRegistry.register();
    }

    class ByteArrayDataSource
    implements DataSource {
        private byte[] data;
        private String type;

        ByteArrayDataSource(InputStream is, String type) {
            this.type = type;
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                IOUtils.copyStream((OutputStream)os, (InputStream)is);
                this.data = os.toByteArray();
            }
            catch (IOException ioex) {
                throw new WSException(ioex);
            }
        }

        ByteArrayDataSource(byte[] data, String type) {
            this.data = data;
            this.type = type;
        }

        ByteArrayDataSource(String data, String type) {
            try {
                this.data = data.getBytes("iso-8859-1");
            }
            catch (UnsupportedEncodingException uex) {
                throw new WSException(uex);
            }
            this.type = type;
        }

        public InputStream getInputStream() throws IOException {
            if (this.data == null) {
                throw new IOException("no data");
            }
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("cannot do this");
        }

        public String getContentType() {
            return this.type;
        }

        public String getName() {
            return "ByteArrayDataSource";
        }

        public int getSize() {
            return this.data.length;
        }
    }
}

