/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.binding;

import java.util.HashSet;
import java.util.Set;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.binding.BindingImpl;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.metadata.umdm.OperationMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SOAPBindingJAXWS
extends BindingImpl {
    private static Logger log = Logger.getLogger(SOAPBindingJAXWS.class);
    private Set<String> roles = new HashSet<String>();

    SOAPBindingJAXWS() {
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public void setSOAPActionHeader(OperationMetaData opMetaData, SOAPMessage reqMessage) {
        String soapActionProperty;
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        String soapAction = opMetaData.getSOAPAction();
        if (msgContext.get("javax.xml.ws.soap.http.soapaction.use") != null) {
            log.info("Ignore BindingProvider.SOAPACTION_USE_PROPERTY because of BP-1.0 R2745, R2745");
        }
        if ((soapActionProperty = (String)msgContext.get("javax.xml.ws.soap.http.soapaction.uri")) != null) {
            soapAction = soapActionProperty;
        }
        mimeHeaders.addHeader("SOAPAction", soapAction != null ? soapAction : "");
    }
}

