/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.vfs.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.AbstractVirtualFileFilterWithAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixMatchFilter
extends AbstractVirtualFileFilterWithAttributes {
    private static Logger log = Logger.getLogger(SuffixMatchFilter.class);
    private Collection<String> suffixes;
    private boolean trace;

    public SuffixMatchFilter(String suffix) {
        this(suffix, null);
    }

    public SuffixMatchFilter(String suffix, VisitorAttributes attributes) {
        this(Collections.EMPTY_LIST, attributes);
        this.suffixes.add(suffix);
        this.trace = log.isTraceEnabled();
    }

    public SuffixMatchFilter(Collection<String> suffixes) {
        this(suffixes, null);
    }

    public SuffixMatchFilter(Collection<String> suffixes, VisitorAttributes attributes) {
        super(attributes == null ? VisitorAttributes.DEFAULT : attributes);
        if (suffixes == null) {
            throw new IllegalArgumentException("Null suffixes");
        }
        this.suffixes = new ArrayList<String>();
        this.suffixes.addAll(suffixes);
    }

    @Override
    public boolean accepts(VirtualFile file) {
        String name = file.getName();
        boolean accepts = false;
        for (String suffix : this.suffixes) {
            if (!name.endsWith(suffix)) continue;
            accepts = true;
            break;
        }
        if (this.trace) {
            log.trace(file + " accepted: " + accepts);
        }
        return accepts;
    }
}

