/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

public class SARArchiveFilter
implements VirtualFileFilter {
    private final Set<String> patterns;
    private final boolean allowAll;

    public SARArchiveFilter(String patternsString) {
        if (patternsString == null) {
            throw new IllegalArgumentException("Null patternsString");
        }
        StringTokenizer tokens = new StringTokenizer(patternsString, ",");
        this.patterns = new HashSet<String>(tokens.countTokens());
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            this.patterns.add(token.trim());
            ++i;
        }
        this.allowAll = this.patterns.contains("*");
    }

    public boolean accepts(VirtualFile file) {
        if (this.allowAll) {
            return true;
        }
        return this.patterns.contains(file.getName());
    }
}

