/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.ejb;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.HashMap;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRoleRef;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.integration.ejb.SecurityActions;
import org.jboss.security.integration.ejb.SecurityHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBAuthorizationHelper
extends SecurityHelper {
    public EJBAuthorizationHelper(SecurityContext sc) {
        super(sc);
    }

    public boolean authorize(String ejbName, Method ejbMethod, Principal ejbPrincipal, String invocationInterfaceString, CodeSource ejbCS, Subject callerSubject, RunAs callerRunAs, Set<Principal> methodRoles) {
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authorizationManager", am);
        EJBResource ejbResource = new EJBResource(map);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setEjbName(ejbName);
        ejbResource.setEjbMethod(ejbMethod);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setEjbMethodInterface(invocationInterfaceString);
        ejbResource.setCodeSource(ejbCS);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setCallerSubject(callerSubject);
        ejbResource.setMethodRoles(methodRoles);
        boolean isAuthorized = false;
        try {
            int check = am.authorize(ejbResource);
            isAuthorized = check == 1;
            this.authorizationAudit(isAuthorized ? "Success" : "Failure", ejbResource, null);
        }
        catch (Exception e) {
            isAuthorized = false;
            if (log.isTraceEnabled()) {
                log.trace("Error in authorization:", e);
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }

    public Principal getCallerPrincipal(RealmMapping rm) {
        Principal caller = SecurityActions.getCallerPrincipal(this.securityContext);
        if (rm != null) {
            caller = rm.getPrincipal(caller);
        }
        return caller;
    }

    public boolean isCallerInRole(String roleName, String ejbName, Principal ejbPrincipal, Set<SecurityRoleRef> securityRoleRefs) {
        boolean isAuthorized = false;
        AuthorizationManager am = this.securityContext.getAuthorizationManager();
        if (am == null) {
            throw new IllegalStateException("AuthorizationManager is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authorizationManager", am);
        map.put("roleName", roleName);
        map.put("roleRefPermissionCheck", Boolean.TRUE);
        EJBResource ejbResource = new EJBResource(map);
        RunAs callerRunAs = this.securityContext.getIncomingRunAs();
        ejbResource.setEjbName(ejbName);
        ejbResource.setPrincipal(ejbPrincipal);
        ejbResource.setCallerRunAsIdentity(callerRunAs);
        ejbResource.setSecurityRoleReferences(securityRoleRefs);
        try {
            int check = am.authorize(ejbResource);
            isAuthorized = check == 1;
        }
        catch (Exception e) {
            isAuthorized = false;
            if (log.isTraceEnabled()) {
                log.trace(roleName + "::isCallerInRole check failed:" + e.getLocalizedMessage());
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        return isAuthorized;
    }
}

