/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.web;

import java.io.IOException;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.WebResourcePermission;
import javax.security.jacc.WebRoleRefPermission;
import javax.security.jacc.WebUserDataPermission;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.resources.WebResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebJACCPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private Policy policy = Policy.getPolicy();
    private AuthorizationManager authorizationManager;
    private HttpServletRequest request = null;
    private CodeSource webCS = null;
    private String canonicalRequestURI = null;

    public WebJACCPolicyModuleDelegate() {
        log = Logger.getLogger(WebJACCPolicyModuleDelegate.class);
        this.trace = log.isTraceEnabled();
    }

    @Override
    public int authorize(Resource resource) {
        boolean decision;
        block12: {
            if (!(resource instanceof WebResource)) {
                throw new IllegalArgumentException("resource is not a WebResource");
            }
            WebResource webResource = (WebResource)resource;
            Map<String, Object> map = resource.getMap();
            if (map == null) {
                throw new IllegalStateException("Map from the Resource is null");
            }
            this.authorizationManager = (AuthorizationManager)map.get("authorizationManager");
            if (this.authorizationManager == null) {
                throw new IllegalStateException("Authorization Manager is null");
            }
            this.request = (HttpServletRequest)webResource.getServletRequest();
            this.webCS = webResource.getCodeSource();
            this.canonicalRequestURI = webResource.getCanonicalRequestURI();
            Subject callerSubject = webResource.getCallerSubject();
            String roleName = (String)map.get("roleName");
            Principal principal = (Principal)map.get("hasRole.Principal");
            Set roles = (Set)map.get("principal.roles");
            String servletName = (String)map.get("servletName");
            Boolean resourceCheck = this.checkBooleanValue((Boolean)map.get("resourcePermissionCheck"));
            Boolean userDataCheck = this.checkBooleanValue((Boolean)map.get("userDataPermissionCheck"));
            Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
            this.validatePermissionChecks(resourceCheck, userDataCheck, roleRefCheck);
            decision = false;
            try {
                if (resourceCheck.booleanValue()) {
                    decision = this.hasResourcePermission(callerSubject);
                } else if (userDataCheck.booleanValue()) {
                    decision = this.hasUserDataPermission();
                } else if (roleRefCheck.booleanValue()) {
                    decision = this.hasRole(principal, roleName, roles, servletName);
                } else if (this.trace) {
                    log.trace("Check is not for resourcePerm, userDataPerm or roleRefPerm.");
                }
            }
            catch (IOException ioe) {
                if (!this.trace) break block12;
                log.trace("IOException:", ioe);
            }
        }
        return decision ? 1 : -1;
    }

    @Override
    public void setPolicyRegistrationManager(PolicyRegistration authzM) {
        this.policyRegistration = authzM;
    }

    private boolean checkSecurityAssociation(Permission perm, Principal requestPrincpal, Subject caller) {
        Principal[] principals = null;
        if (this.authorizationManager != null) {
            Set<Principal> roleset = this.authorizationManager.getUserRoles(requestPrincpal);
            principals = new Principal[roleset.size()];
            roleset.toArray(principals);
        }
        return this.checkSecurityAssociation(perm, principals);
    }

    private boolean checkSecurityAssociation(Permission perm, Principal[] principals) {
        ProtectionDomain pd = new ProtectionDomain(this.webCS, null, null, principals);
        boolean allowed = this.policy.implies(pd, perm);
        if (this.trace) {
            String msg = (allowed ? "Allowed: " : "Denied: ") + perm;
            log.trace(msg);
        }
        return allowed;
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }

    private boolean hasResourcePermission(Subject caller) throws IOException {
        Principal requestPrincipal = this.request.getUserPrincipal();
        WebResourcePermission perm = new WebResourcePermission(this.canonicalRequestURI, this.request.getMethod());
        boolean allowed = this.checkSecurityAssociation(perm, requestPrincipal, caller);
        if (this.trace) {
            log.trace("hasResourcePermission, perm=" + perm + ", allowed=" + allowed);
        }
        return allowed;
    }

    private boolean hasRole(Principal principal, String roleName, Set<Principal> roles, String servletName) {
        WebRoleRefPermission perm = new WebRoleRefPermission(servletName, roleName);
        Principal[] principals = new Principal[]{principal};
        if (roles != null) {
            principals = new Principal[roles.size()];
            roles.toArray(principals);
        }
        boolean allowed = this.checkSecurityAssociation(perm, principals);
        if (this.trace) {
            log.trace("hasRole, perm=" + perm + ", allowed=" + allowed);
        }
        return allowed;
    }

    private boolean hasUserDataPermission() throws IOException {
        boolean ok;
        block3: {
            WebUserDataPermission perm = new WebUserDataPermission(this.canonicalRequestURI, this.request.getMethod());
            if (this.trace) {
                log.trace("hasUserDataPermission, p=" + perm);
            }
            ok = false;
            try {
                Principal[] principals = null;
                ok = this.checkSecurityAssociation(perm, principals);
            }
            catch (Exception e) {
                if (!this.trace) break block3;
                log.trace("Failed to checkSecurityAssociation", e);
            }
        }
        return ok;
    }

    private void validatePermissionChecks(Boolean resourceCheck, Boolean userDataCheck, Boolean roleRefCheck) {
        if (this.trace) {
            log.trace("resourceCheck=" + resourceCheck + " : userDataCheck=" + userDataCheck + " : roleRefCheck=" + roleRefCheck);
        }
        if (resourceCheck == Boolean.TRUE && userDataCheck == Boolean.TRUE && roleRefCheck == Boolean.TRUE || resourceCheck == Boolean.TRUE && userDataCheck == Boolean.TRUE || userDataCheck == Boolean.TRUE && roleRefCheck == Boolean.TRUE) {
            throw new IllegalStateException("Permission checks must be different");
        }
    }
}

