/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import com.sun.xacml.Indenter;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBXACMLUtil {
    private static Logger log = Logger.getLogger(EJBXACMLUtil.class);
    private boolean trace = log.isTraceEnabled();

    public RequestCtx createXACMLRequest(String ejbName, String methodName, Principal principal, Set<Principal> roles) throws Exception {
        if (principal == null) {
            throw new IllegalArgumentException("principal is null");
        }
        String action = methodName;
        RequestCtx requestCtx = null;
        String username = principal.getName();
        URI subjectAttrUri = new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
        Attribute subjectAttr = new Attribute(subjectAttrUri, null, null, (AttributeValue)new StringAttribute(username));
        HashSet<Attribute> subjectAttrSet = new HashSet<Attribute>();
        subjectAttrSet.add(subjectAttr);
        subjectAttrSet.addAll(this.getXACMLRoleSet(roles));
        HashSet<Subject> subjectSet = new HashSet<Subject>();
        subjectSet.add(new Subject(subjectAttrSet));
        URI resourceUri = new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        Attribute resourceAttr = new Attribute(resourceUri, null, null, (AttributeValue)new StringAttribute(ejbName));
        HashSet<Attribute> resourceSet = new HashSet<Attribute>();
        resourceSet.add(resourceAttr);
        HashSet<Attribute> actionSet = new HashSet<Attribute>();
        actionSet.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:action:action-id"), null, null, (AttributeValue)new StringAttribute(action)));
        HashSet<Attribute> environSet = new HashSet<Attribute>();
        URI currentTimeUri = new URI("urn:oasis:names:tc:xacml:1.0:environment:current-time");
        Attribute currentTimeAttr = new Attribute(currentTimeUri, null, null, (AttributeValue)new TimeAttribute());
        environSet.add(currentTimeAttr);
        requestCtx = new RequestCtx(subjectSet, resourceSet, actionSet, environSet);
        if (this.trace) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            requestCtx.encode((OutputStream)baos, new Indenter());
            log.trace("XACML Request:" + baos.toString());
            baos.close();
        }
        return requestCtx;
    }

    private Set<Attribute> getXACMLRoleSet(Set<Principal> roles) throws Exception {
        Iterator<Principal> iter;
        URI roleURI = new URI("urn:oasis:names:tc:xacml:2.0:subject:role");
        HashSet<Attribute> roleset = new HashSet<Attribute>();
        Iterator<Principal> iterator = iter = roles != null ? roles.iterator() : null;
        while (iter != null && iter.hasNext()) {
            Principal role = iter.next();
            Attribute roleAttr = new Attribute(roleURI, null, null, (AttributeValue)new StringAttribute(role.getName()));
            roleset.add(roleAttr);
        }
        return roleset;
    }
}

