/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.vendor;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.ValidConnectionChecker;

public class MySQLReplicationValidConnectionChecker
implements ValidConnectionChecker,
Serializable {
    private static final long serialVersionUID = 2658231045989623858L;
    private boolean driverHasIsValidMethod = false;
    private boolean driverHasPingMethod = false;
    protected static final String CONNECTION_CLASS = "com.mysql.jdbc.ReplicationConnection";
    private static final Logger log = Logger.getLogger(MySQLReplicationValidConnectionChecker.class);
    private static Object[] timeoutParam = new Object[0];

    public MySQLReplicationValidConnectionChecker() {
        Class<?> mysqlConnection = null;
        try {
            mysqlConnection = Thread.currentThread().getContextClassLoader().loadClass(CONNECTION_CLASS);
            try {
                mysqlConnection.getMethod("isValid", new Class[0]);
                this.driverHasIsValidMethod = true;
            }
            catch (NoSuchMethodException e) {
                log.info("Cannot resolve com.mysq.jdbc.ReplicationConnection.isValid method. Fallback to ping.", e);
            }
            catch (SecurityException e) {
                log.info("Cannot resolve com.mysq.jdbc.ReplicationConnection.isValid method. Fallback to ping.", e);
            }
            if (!this.driverHasIsValidMethod) {
                try {
                    mysqlConnection.getMethod("ping", new Class[0]);
                    this.driverHasPingMethod = true;
                }
                catch (NoSuchMethodException e) {
                    log.warn("Cannot resolve com.mysq.jdbc.ReplicationConnection.ping method. Will use 'SELECT 1' instead.", e);
                }
                catch (SecurityException e) {
                    log.info("Cannot resolve com.mysq.jdbc.ReplicationConnection.ping method. Will use 'SELECT 1' instead.", e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Cannot find the driver class defined in CONNECTION_CLASS", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SQLException isValidConnection(Connection c) {
        if (this.driverHasIsValidMethod) {
            try {
                c.getClass().getMethod("isValid", new Class[0]).invoke((Object)c, timeoutParam);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                log.warn("Unexpected error in ping", e);
                return new SQLException("ping failed: " + e.toString());
            }
        }
        if (this.driverHasPingMethod) {
            try {
                c.getClass().getMethod("ping", new Class[0]).invoke((Object)c, timeoutParam);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    return (SQLException)e;
                }
                log.warn("Unexpected error in ping", e);
                return new SQLException("ping failed: " + e.toString());
            }
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = c.createStatement();
            rs = stmt.executeQuery("SELECT 1");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                SQLException sQLException = (SQLException)e;
                return sQLException;
            }
            log.warn("Unexpected error in ping (SELECT 1)", e);
            SQLException sQLException = new SQLException("ping (SELECT 1) failed: " + e.toString());
            return sQLException;
        }
        finally {
            block60: {
                block59: {
                    if (rs == null) break block59;
                    rs.close();
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    break block60;
                }
                catch (SQLException e) {}
                break block60;
                catch (SQLException e) {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {}
                    catch (Throwable throwable) {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException e3) {}
                        throw throwable;
                    }
                }
            }
        }
        return null;
    }
}

