/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jboss.remoting.samples.chat.client.ChatMessage;
import org.jboss.remoting.samples.chat.client.Closeable;
import org.jboss.remoting.samples.chat.client.CloseableFrame;
import org.jboss.remoting.samples.chat.client.TalkConnectionStrategy;
import org.jboss.remoting.samples.chat.client.TalkFrame_closeButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.TalkFrame_exitButton_actionAdapter;
import org.jboss.remoting.samples.chat.client.TalkFrame_newMessage_actionAdapter;
import org.jboss.remoting.samples.chat.exceptions.TalkConnectionException;

public class TalkFrame
extends CloseableFrame {
    JScrollPane jScrollPane1 = new JScrollPane();
    JButton closeButton = new JButton();
    JButton exitButton = new JButton();
    JTextArea backChatTextArea = new JTextArea();
    JTextField newMessage = new JTextField();
    JLabel talkLabel = new JLabel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private String description;
    private String nickname;
    private String[] backChat;
    private TalkConnectionStrategy tcs;
    private Font plainFont;
    private Font boldFont;
    private String chatKey;
    private static ArrayList talkWindows = new ArrayList();
    public final boolean NEW_CHAT = true;
    public final boolean OLD_CHAT = false;

    public TalkFrame(String description, String nickname, Closeable parent) {
        super(parent);
        this.description = description;
        this.nickname = nickname;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.plainFont = new Font("SanSerif", 0, 12);
        this.boldFont = new Font("SanSerif", 1, 12);
        talkWindows.add(this);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.closeButton.setFont(new Font("SansSerif", 1, 12));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new TalkFrame_closeButton_actionAdapter(this));
        this.exitButton.setFont(new Font("SansSerif", 1, 12));
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new TalkFrame_exitButton_actionAdapter(this));
        this.backChatTextArea.setFont(new Font("Monospaced", 0, 13));
        this.backChatTextArea.setDisabledTextColor(Color.white);
        this.backChatTextArea.setEditable(false);
        this.backChatTextArea.setText("");
        this.newMessage.setText("");
        this.newMessage.addActionListener(new TalkFrame_newMessage_actionAdapter(this));
        this.newMessage.requestFocus();
        this.talkLabel.setFont(new Font("SansSerif", 1, 12));
        this.talkLabel.setText("Talk:");
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.getViewport().setBackground(Color.white);
        this.jScrollPane1.setAutoscrolls(true);
        this.getContentPane().setBackground(SystemColor.control);
        this.getContentPane().add((Component)this.closeButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(28, 204, 21, 0), 6, 0));
        this.getContentPane().add((Component)this.exitButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(28, 17, 21, 280), 18, 0));
        this.getContentPane().add((Component)this.jScrollPane1, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 8, 0, 33), 602, 264));
        this.getContentPane().add((Component)this.talkLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(34, 15, 0, 0), 7, -1));
        this.getContentPane().add((Component)this.newMessage, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(25, 10, 0, 33), 602, 6));
        this.jScrollPane1.getViewport().add((Component)this.backChatTextArea, null);
        this.setTitle(this.description);
        this.pack();
        this.center();
    }

    public void registerStrategy(TalkConnectionStrategy tcs) {
        this.tcs = tcs;
    }

    public void registerChatKey(String chatKey) {
        System.out.println("TalkFrame: registering chat key: " + chatKey);
        this.chatKey = chatKey;
    }

    public void appendMessage(ChatMessage chatMessage) {
        String message = chatMessage.get_message();
        int mark = message.indexOf(58);
        int boundedMark = Math.max(0, mark);
        boundedMark = Math.min(8, boundedMark);
        String name = message.substring(0, boundedMark) + ":" + "        ".substring(0, 8 - boundedMark);
        String content = message.substring(mark + 1) + "\n";
        this.backChatTextArea.append(name + content);
    }

    public void appendMessages(ArrayList messages) {
        for (int i = 0; i < messages.size(); ++i) {
            this.appendMessage((ChatMessage)messages.get(i));
        }
    }

    public static void main(String[] args) {
        String[] backChat = new String[]{"roger: take this", "mike: take that"};
        TalkFrame talkFrame = new TalkFrame("dummy title", "h_brewski", null);
        talkFrame.show();
    }

    void close() {
        if (this.tcs == null) {
            throw new Error("TalkFrame '" + this.description + "' close(): no TalkStrategy registered");
        }
        try {
            this.tcs.leave();
        }
        catch (TalkConnectionException rce) {
            System.out.println("TalkFrame: unable to close");
        }
        this.hide();
        System.out.println("member '" + this.nickname + "' is leaving chat room '" + this.description + "'");
        talkWindows.remove(this);
        this.notifyOnClose(this);
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.close();
    }

    public static void exit() {
        Iterator it = new ArrayList(talkWindows).iterator();
        while (it.hasNext()) {
            ((TalkFrame)it.next()).close();
        }
        System.exit(0);
    }

    void exitButton_actionPerformed(ActionEvent e) {
        TalkFrame.exit();
    }

    void newMessage_actionPerformed(ActionEvent e) {
        if (this.tcs == null) {
            throw new Error("TalkFrame exit button: no TalkStrategy registered");
        }
        try {
            this.tcs.send(new ChatMessage(this.chatKey, this.nickname + ": " + this.newMessage.getText()));
        }
        catch (TalkConnectionException rce) {
            System.out.println("TalkFrame: unable to send new chat line");
        }
        this.newMessage.setText("");
    }
}

