/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.io.Serializable;

public final class TimeFormat
implements Serializable {
    public static final boolean DEBUG = false;
    public static final long ONE_MILLISECOND = 1L;
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final int ROUND_TO_MILLISECOND = 5;
    public static final int ROUND_TO_SECOND = 4;
    public static final int ROUND_TO_MINUTE = 3;
    public static final int ROUND_TO_HOUR = 2;
    public static final int ROUND_TO_DAY = 1;
    private long original = 0L;
    private long time = 0L;
    private long remainder = 0L;
    private long days = 0L;
    private long hours = 0L;
    private long minutes = 0L;
    private long seconds = 0L;
    private long milliseconds = 0L;
    private boolean micro = false;
    private int rounding = 4;

    private TimeFormat(long milliseconds, int round) {
        this.rounding = round;
        this.original = milliseconds;
        if (milliseconds >= 1000L) {
            this.remainder = milliseconds;
            this.getTime();
        } else {
            this.micro = true;
            this.time = milliseconds;
        }
    }

    private TimeFormat(long milliseconds) {
        this(milliseconds, 5);
    }

    public long getDays() {
        return this.days;
    }

    public long getMinutes() {
        return this.minutes;
    }

    public long getHours() {
        return this.hours;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public void add(TimeFormat t) {
        this.days += t.days;
        this.hours += t.hours;
        this.minutes += t.minutes;
        this.seconds += t.seconds;
    }

    public void getDays(TimeFormat t) {
        if (t.remainder >= 86400000L) {
            t.days = t.remainder / 86400000L;
            t.remainder -= t.days * 86400000L;
        }
    }

    public void getHours(TimeFormat t) {
        if (t.remainder >= 3600000L && t.remainder < 86400000L) {
            t.hours = t.remainder / 3600000L;
            t.remainder -= t.hours * 3600000L;
        }
    }

    public void getMinutes(TimeFormat t) {
        if (t.remainder >= 60000L && t.remainder < 3600000L) {
            t.minutes = t.remainder / 60000L;
            t.remainder -= t.minutes * 60000L;
        }
    }

    public void getSeconds(TimeFormat t) {
        if (t.remainder >= 1000L && t.remainder < 60000L) {
            t.seconds = t.remainder / 1000L;
            t.milliseconds = t.remainder -= t.seconds * 1000L;
        } else {
            t.seconds = 0L;
            t.milliseconds = t.remainder;
        }
    }

    public void getTime(TimeFormat t) {
        t.getTime();
    }

    private void getTime() {
        this.getDays(this);
        this.getHours(this);
        this.getMinutes(this);
        this.getSeconds(this);
    }

    public long getMilliseconds() {
        return this.micro ? this.time : this.milliseconds;
    }

    public String toString() {
        return this.format(this.rounding);
    }

    public void setRounding(int r) {
        this.rounding = r;
    }

    public int getRouding() {
        return this.rounding;
    }

    public String format(int round) {
        switch (round) {
            case 1: {
                return this.formatDays(false);
            }
            case 2: {
                return this.formatDays(true) + this.formatHours(false);
            }
            case 3: {
                return this.formatDays(true) + this.formatHours(true) + this.formatMinutes(false);
            }
            case 4: {
                return this.formatDays(true) + this.formatHours(true) + this.formatMinutes(true) + this.formatSeconds(false);
            }
            case 5: {
                return this.formatDays(true) + this.formatHours(true) + this.formatMinutes(true) + this.formatSeconds(true) + (this.micro ? this.time : this.milliseconds) + " ms";
            }
        }
        return this.original + " ms";
    }

    private String formatDays(boolean empty) {
        if (this.days <= 0L) {
            return empty ? "" : "0 days";
        }
        return this.format("day", "days", this.days);
    }

    private String formatHours(boolean empty) {
        if (this.hours <= 0L) {
            return empty ? "" : "0 hours";
        }
        return this.format("hour", "hours", this.hours);
    }

    private String formatMinutes(boolean empty) {
        if (this.minutes <= 0L) {
            return empty ? "" : "0 minutes";
        }
        return this.format("minute", "minutes", this.minutes);
    }

    private String formatSeconds(boolean empty) {
        if (this.seconds <= 0L) {
            return empty ? "" : "0 seconds";
        }
        return this.format("second", "seconds", this.seconds);
    }

    private String format(String single, String plural, long amt) {
        if (amt > 0L) {
            return amt + " " + (amt > 1L ? plural : single) + " ";
        }
        return "";
    }

    public static String valueOf(long t, int round) {
        TimeFormat f = new TimeFormat(t, round);
        return f.toString();
    }

    public static String valueOf(long t) {
        return TimeFormat.valueOf(t, 5);
    }

    public static String format(String format, long time) {
        TimeFormat f = new TimeFormat(time);
        return f.parse(format, f.getDays(), f.getHours(), f.getMinutes(), f.getSeconds(), f.getMilliseconds());
    }

    private String parse(String format, long day, long hour, long minute, long second, long millis) {
        String s = "";
        int start = 0;
        int len = format.length();
        for (int c = 0; c < len; ++c) {
            char tc = format.charAt(c);
            int sc = c;
            int l = 0;
            switch (tc) {
                case ' ': {
                    s = s + " ";
                    break;
                }
                case '\'': {
                    while (++c < len && format.charAt(c) != '\'') {
                    }
                    s = s + format.substring(sc + 1, c);
                    break;
                }
                case 'D': 
                case 'd': {
                    while (++c < len && (format.charAt(c) == 'd' || format.charAt(c) == 'D')) {
                    }
                    l = c - sc;
                    s = s + (sc <= 0 || start < 0 ? "" : format.substring(start, sc));
                    s = s + this.zeroPad(day, l - 1);
                    --c;
                    break;
                }
                case 'H': 
                case 'h': {
                    while (++c < len && (format.charAt(c) == 'h' || format.charAt(c) == 'H')) {
                    }
                    l = c - sc;
                    s = s + (sc <= 0 || start < 0 ? "" : format.substring(start, sc));
                    s = s + this.zeroPad(hour, l - 1);
                    --c;
                    break;
                }
                case 'M': 
                case 'm': {
                    while (++c < len && (format.charAt(c) == 'm' || format.charAt(c) == 'M')) {
                    }
                    l = c - sc;
                    s = s + (sc <= 0 || start < 0 ? "" : format.substring(start, sc));
                    s = s + this.zeroPad(minute, l - 1);
                    --c;
                    break;
                }
                case 'S': 
                case 's': {
                    while (++c < len && (format.charAt(c) == 's' || format.charAt(c) == 'S')) {
                    }
                    l = c - sc;
                    s = s + (sc <= 0 || start < 0 ? "" : format.substring(start, sc));
                    s = s + this.zeroPad(second, l - 1);
                    --c;
                    break;
                }
                case 'Z': 
                case 'z': {
                    while (++c < len && (format.charAt(c) == 'z' || format.charAt(c) == 'Z')) {
                    }
                    l = c - sc;
                    s = s + (sc <= 0 || start < 0 ? "" : format.substring(start, sc));
                    s = s + this.zeroPad(millis, l - 1);
                    --c;
                }
            }
            start = c + 1;
        }
        return s;
    }

    private String zeroPad(long value, int len) {
        String s = String.valueOf(value);
        int l = s.length();
        String r = "";
        for (int c = l; c <= len; ++c) {
            r = r + "0";
        }
        return r + s;
    }

    public static void main(String[] args) {
        String FORMAT = "D 'days,' HH 'hours,' mm 'minutes and ' ss 'seconds, 'zz 'milliseconds'";
        System.out.println(TimeFormat.format(FORMAT, 1000L));
        System.out.println("ONE SECOND: 1000");
        System.out.println("ONE MINUTE: 60000");
        System.out.println("ONE HOUR:   3600000");
        System.out.println("ONE DAY:    86400000");
        for (int c = 0; c <= 5; ++c) {
            System.out.println("============ Round to: " + c + " ==================");
            System.out.println("Time: " + TimeFormat.valueOf(Long.MAX_VALUE, c));
            System.out.println("Time: " + TimeFormat.valueOf(1236371400L, c));
            System.out.println("Time: " + TimeFormat.format(FORMAT, 1236371400L));
            System.out.println("Time: " + TimeFormat.valueOf(123613700L, c));
            System.out.println("Time: " + TimeFormat.valueOf(700L, c));
            System.out.println("Time: " + TimeFormat.valueOf(2001L, c));
            System.out.println("Time: " + TimeFormat.valueOf(2101L, c));
            System.out.println("Time: " + TimeFormat.valueOf(15L, c));
            System.out.println("Time: " + TimeFormat.valueOf(999L, c));
            System.out.println("Time: " + TimeFormat.valueOf(10000L, c));
            System.out.println("Time: " + TimeFormat.valueOf(600000L, c));
            System.out.println("Time: " + TimeFormat.valueOf(864000101L, c));
            System.out.println("Time: " + TimeFormat.valueOf(36000000L, c));
            System.out.println("Time: " + TimeFormat.valueOf(90120000L, c));
            System.out.println("Time: " + TimeFormat.format(FORMAT, 90120000L));
            System.out.println("================================================");
        }
    }
}

