/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.DeliveryObserver;
import org.jboss.messaging.core.contract.Distributor;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.Receiver;
import org.jboss.messaging.core.impl.tx.Transaction;

public class ClusterRoundRobinDistributor
implements Distributor {
    private static final Logger log = Logger.getLogger(ClusterRoundRobinDistributor.class);
    private boolean trace = log.isTraceEnabled();
    private Distributor localDistributor;
    private Distributor remoteDistributor;

    public ClusterRoundRobinDistributor(Distributor local, Distributor remote) {
        this.localDistributor = local;
        this.remoteDistributor = remote;
    }

    public Delivery handle(DeliveryObserver observer, MessageReference ref, Transaction tx) {
        if (this.trace) {
            log.trace(this + " first trying with local distributor");
        }
        Delivery del = this.localDistributor.handle(observer, ref, tx);
        if (this.trace) {
            log.trace(this + " local distributor returned " + del);
        }
        if (del == null) {
            if (this.trace) {
                log.trace(this + " trying with remote distributor");
            }
            del = this.remoteDistributor.handle(observer, ref, tx);
            if (this.trace) {
                log.trace(this + " remote distributor returned " + del);
            }
        }
        return del;
    }

    public synchronized boolean add(Receiver r) {
        throw new IllegalStateException("Not used!");
    }

    public synchronized boolean remove(Receiver r) {
        throw new IllegalStateException("Not used!");
    }

    public synchronized void clear() {
        this.localDistributor.clear();
        this.remoteDistributor.clear();
    }

    public synchronized boolean contains(Receiver r) {
        return this.localDistributor.contains(r) || this.remoteDistributor.contains(r);
    }

    public synchronized Iterator iterator() {
        return this.localDistributor.iterator();
    }

    public synchronized int getNumberOfReceivers() {
        return this.localDistributor.getNumberOfReceivers() + this.remoteDistributor.getNumberOfReceivers();
    }

    public void addLocal(Receiver r) {
        this.localDistributor.add(r);
    }

    public boolean removeLocal(Receiver r) {
        return this.localDistributor.remove(r);
    }

    public void addRemote(Receiver r) {
        this.remoteDistributor.add(r);
    }

    public boolean removeRemote(Receiver r) {
        return this.remoteDistributor.remove(r);
    }
}

