/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.api.annotations.JavaBeanValue;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.kernel.plugins.annotations.PropertyAnnotationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanValueAnnotationPlugin
extends PropertyAnnotationPlugin<JavaBeanValue> {
    static JavaBeanValueAnnotationPlugin INSTANCE = new JavaBeanValueAnnotationPlugin();
    private static Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration();
        }
    });

    public JavaBeanValueAnnotationPlugin() {
        super(JavaBeanValue.class);
    }

    @Override
    public ValueMetaData createValueMetaData(JavaBeanValue annotation) {
        String className = annotation.value();
        if (!JavaBeanValueAnnotationPlugin.isAttributePresent(className)) {
            throw new IllegalArgumentException("Javabean class must be set: " + annotation);
        }
        try {
            BeanInfo beanInfo = configuration.getBeanInfo(className, null);
            return new AbstractValueMetaData(beanInfo.newInstance());
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Exception while creating javabean: " + t);
        }
    }
}

