/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionmanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import org.jboss.jms.delegate.ConnectionEndpoint;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.ClusterNotification;
import org.jboss.messaging.core.contract.ClusterNotificationListener;
import org.jboss.messaging.core.contract.Replicator;
import org.jboss.messaging.util.ConcurrentHashSet;
import org.jboss.messaging.util.Util;
import org.jboss.remoting.Client;
import org.jboss.remoting.ClientDisconnectedException;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class SimpleConnectionManager
implements ConnectionManager,
ConnectionListener,
ClusterNotificationListener {
    private static final Logger log = Logger.getLogger(SimpleConnectionManager.class);
    private static boolean trace = log.isTraceEnabled();
    private Map<String, Map<String, ConnectionEndpoint>> jmsClients = new HashMap<String, Map<String, ConnectionEndpoint>>();
    private Map<String, String> remotingSessions = new HashMap<String, String>();
    private Set<ConnectionEndpoint> activeConnectionEndpoints = new HashSet<ConnectionEndpoint>();
    private Map<String, ConnectionFactoryCallbackInformation> cfCallbackInfo = new ConcurrentHashMap<String, ConnectionFactoryCallbackInformation>();
    private Replicator replicator;

    public synchronized void registerConnection(String jmsClientVMID, String remotingClientSessionID, ConnectionEndpoint endpoint) {
        Map<String, ConnectionEndpoint> endpoints = this.jmsClients.get(jmsClientVMID);
        if (endpoints == null) {
            endpoints = new HashMap<String, ConnectionEndpoint>();
            this.jmsClients.put(jmsClientVMID, endpoints);
        }
        endpoints.put(remotingClientSessionID, endpoint);
        this.remotingSessions.put(remotingClientSessionID, jmsClientVMID);
        this.activeConnectionEndpoints.add(endpoint);
        log.debug("registered connection " + endpoint + " as " + Util.guidToString(remotingClientSessionID));
    }

    public synchronized ConnectionEndpoint unregisterConnection(String jmsClientVMId, String remotingClientSessionID) {
        Map<String, ConnectionEndpoint> endpoints = this.jmsClients.get(jmsClientVMId);
        if (endpoints != null) {
            ConnectionEndpoint e = endpoints.remove(remotingClientSessionID);
            if (e != null) {
                endpoints.remove(e);
                this.activeConnectionEndpoints.remove(e);
            }
            log.debug("unregistered connection " + e + " with remoting session ID " + Util.guidToString(remotingClientSessionID));
            if (endpoints.isEmpty()) {
                this.jmsClients.remove(jmsClientVMId);
            }
            this.remotingSessions.remove(remotingClientSessionID);
            return e;
        }
        return null;
    }

    public synchronized List getActiveConnections() {
        ArrayList<ConnectionEndpoint> list2 = new ArrayList<ConnectionEndpoint>();
        list2.addAll(this.activeConnectionEndpoints);
        return list2;
    }

    public synchronized void handleClientFailure(String remotingSessionID, boolean clientToServer) {
        String jmsClientID = this.remotingSessions.get(remotingSessionID);
        if (jmsClientID == null) {
            log.warn(this + " cannot look up remoting session ID " + remotingSessionID);
        }
        log.warn("A problem has been detected " + (clientToServer ? "with the connection to remote client " : "trying to send a message to remote client ") + remotingSessionID + ", jmsClientID=" + jmsClientID + ". It is possible the client has exited without closing " + "its connection(s) or the network has failed. All connection resources " + "corresponding to that client process will now be removed.");
        this.closeConsumersForClientVMID(jmsClientID);
    }

    public void handleConnectionException(Throwable t, Client client) {
        String remotingSessionID;
        if (t instanceof ClientDisconnectedException) {
            if (trace) {
                log.trace(this + " notified that client " + client + " has disconnected");
            }
            return;
        }
        if (trace) {
            log.trace(this + " detected failure on client " + client, t);
        }
        if ((remotingSessionID = client.getSessionId()) != null) {
            this.handleClientFailure(remotingSessionID, true);
        }
    }

    public synchronized void addConnectionFactoryCallback(String uniqueName, String JVMID, String remotingSessionID, ServerInvokerCallbackHandler handler) {
        this.remotingSessions.put(remotingSessionID, JVMID);
        this.getCFInfo(uniqueName).addClient(JVMID, handler);
    }

    public synchronized void removeConnectionFactoryCallback(String uniqueName, String JVMID, ServerInvokerCallbackHandler handler) {
        this.getCFInfo(uniqueName).removeHandler(JVMID, handler);
    }

    public synchronized ServerInvokerCallbackHandler[] getConnectionFactoryCallback(String uniqueName) {
        return this.getCFInfo(uniqueName).getAllHandlers();
    }

    public void notify(ClusterNotification notification) {
        if (notification.type == 5) {
            log.trace("SimpleConnectionManager was notified about node leaving from node " + notification.nodeID);
            try {
                Map ids = this.replicator.get((Serializable)((Object)"JVMID"));
                if (ids == null) {
                    log.trace("Cannot find jvmid map");
                    throw new IllegalStateException("Cannot find jvmid map");
                }
                int failedNodeID = notification.nodeID;
                String clientVMID = (String)ids.get(new Integer(failedNodeID));
                if (clientVMID == null) {
                    log.error("Cannot find ClientVMID for failed node " + failedNodeID);
                    throw new IllegalStateException("Cannot find clientVMID for failed node " + failedNodeID);
                }
                log.trace("Closing consumers for clientVMID=" + clientVMID);
                this.closeConsumersForClientVMID(clientVMID);
            }
            catch (Exception e) {
                log.error("Failed to process failover start", e);
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public synchronized boolean containsRemotingSession(String remotingClientSessionID) {
        return this.remotingSessions.containsKey(remotingClientSessionID);
    }

    public synchronized Map getClients() {
        return Collections.unmodifiableMap(this.jmsClients);
    }

    public void injectReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    public String toString() {
        return "ConnectionManager[" + Integer.toHexString(this.hashCode()) + "]";
    }

    private ConnectionFactoryCallbackInformation getCFInfo(String uniqueName) {
        ConnectionFactoryCallbackInformation callback = this.cfCallbackInfo.get(uniqueName);
        if (callback == null) {
            callback = new ConnectionFactoryCallbackInformation(uniqueName);
            this.cfCallbackInfo.put(uniqueName, callback);
            callback = this.cfCallbackInfo.get(uniqueName);
        }
        return callback;
    }

    private synchronized void closeConsumersForClientVMID(String jmsClientID) {
        if (jmsClientID == null) {
            return;
        }
        Map<String, ConnectionEndpoint> endpoints = this.jmsClients.get(jmsClientID);
        if (endpoints != null) {
            ArrayList<ConnectionEndpoint> sces = new ArrayList<ConnectionEndpoint>();
            for (Map.Entry<String, ConnectionEndpoint> entry : endpoints.entrySet()) {
                ConnectionEndpoint sce = entry.getValue();
                sces.add(sce);
            }
            for (ConnectionEndpoint sce : sces) {
                try {
                    log.debug("clPearing up state for connection " + sce);
                    sce.closing(-1L);
                    sce.close();
                    log.debug("cleared up state for connection " + sce);
                }
                catch (JMSException e) {
                    log.error("Failed to close connection", e);
                }
            }
        }
        for (ConnectionFactoryCallbackInformation cfInfo : this.cfCallbackInfo.values()) {
            ServerInvokerCallbackHandler[] handlers;
            for (ServerInvokerCallbackHandler handler : handlers = cfInfo.getAllHandlers(jmsClientID)) {
                try {
                    handler.getCallbackClient().disconnect();
                }
                catch (Throwable e) {
                    log.warn(e, e);
                }
                try {
                    handler.destroy();
                }
                catch (Throwable e) {
                    log.warn(e, e);
                }
                cfInfo.removeHandler(jmsClientID, handler);
            }
        }
    }

    private void dump() {
        log.debug("***********Dumping conn map");
        for (Map.Entry<String, Map<String, ConnectionEndpoint>> entry : this.jmsClients.entrySet()) {
            String jmsClientVMID = entry.getKey();
            Map<String, ConnectionEndpoint> endpoints = entry.getValue();
            log.debug(jmsClientVMID + "----->");
            for (Map.Entry<String, ConnectionEndpoint> entry2 : endpoints.entrySet()) {
                String sessionID = entry2.getKey();
                ConnectionEndpoint endpoint = entry2.getValue();
                log.debug("            " + sessionID + "------>" + System.identityHashCode(endpoint));
            }
        }
        log.debug("*** Dumped conn map");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionFactoryCallbackInformation {
        String uniqueName;
        Map<String, ConcurrentHashSet<ServerInvokerCallbackHandler>> clientHandlersByVM;
        ConcurrentHashSet<ServerInvokerCallbackHandler> clientHandlers;

        public ConnectionFactoryCallbackInformation(String uniqueName) {
            this.uniqueName = uniqueName;
            this.clientHandlersByVM = new ConcurrentHashMap<String, ConcurrentHashSet<ServerInvokerCallbackHandler>>();
            this.clientHandlers = new ConcurrentHashSet();
        }

        public void addClient(String vmID, ServerInvokerCallbackHandler handler) {
            this.clientHandlers.add(handler);
            this.getHandlersList(vmID).add(handler);
        }

        public ServerInvokerCallbackHandler[] getAllHandlers(String vmID) {
            ConcurrentHashSet<ServerInvokerCallbackHandler> list2 = this.getHandlersList(vmID);
            ServerInvokerCallbackHandler[] array = new ServerInvokerCallbackHandler[list2.size()];
            return list2.toArray(array);
        }

        public ServerInvokerCallbackHandler[] getAllHandlers() {
            ServerInvokerCallbackHandler[] array = new ServerInvokerCallbackHandler[this.clientHandlers.size()];
            return this.clientHandlers.toArray(array);
        }

        public void removeHandler(String vmID, ServerInvokerCallbackHandler handler) {
            this.clientHandlers.remove(handler);
            this.getHandlersList(vmID).remove(handler);
        }

        private ConcurrentHashSet<ServerInvokerCallbackHandler> getHandlersList(String vmID) {
            ConcurrentHashSet<ServerInvokerCallbackHandler> perVMList = this.clientHandlersByVM.get(vmID);
            if (perVMList == null) {
                perVMList = new ConcurrentHashSet();
                this.clientHandlersByVM.put(vmID, perVMList);
                perVMList = this.clientHandlersByVM.get(vmID);
            }
            return perVMList;
        }
    }
}

