/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.pool;

import java.util.Map;
import org.jboss.ejb3.pool.PoolFactory;
import org.jboss.ejb3.pool.PoolFactoryNotRegisteredException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolFactoryRegistry {
    private Map<String, Class<? extends PoolFactory>> factories;

    public Map<String, Class<? extends PoolFactory>> getFactories() {
        return this.factories;
    }

    public void setFactories(Map<String, Class<? extends PoolFactory>> factories) {
        this.factories = factories;
    }

    public PoolFactory getPoolFactory(String name) throws PoolFactoryNotRegisteredException {
        Class<? extends PoolFactory> poolFactory = this.factories.get(name);
        if (poolFactory == null) {
            throw new PoolFactoryNotRegisteredException("Pool Factory with name " + name + " is not registered.");
        }
        try {
            return poolFactory.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error in instanciating pool factory " + poolFactory.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

