/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.CreateException;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import javax.interceptor.InvocationContext;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.interceptor.InterceptorInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;
import org.jboss.metadata.ejb.spec.InterceptorOrderMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorInfoRepository {
    private static Logger log = Logger.getLogger(InterceptorInfoRepository.class);
    private ClassLoader classLoader;
    private Set<String> beanClasses = new HashSet<String>();
    private InterceptorsMetaData interceptorsXml;
    private InterceptorBindingsMetaData bindingsXml;
    private ConcurrentMap<Class<?>, InterceptorInfo> infos = new ConcurrentHashMap();
    private ConcurrentMap<String, InterceptorInfo> ejbInfos = new ConcurrentHashMap<String, InterceptorInfo>();
    private LinkedHashSet<InterceptorInfo> defaultInterceptors = null;
    private InterceptorSorter sorter = new InterceptorSorter();

    public InterceptorInfoRepository(ClassLoader classLoader) {
        assert (classLoader != null) : "classLoader is null";
        this.classLoader = classLoader;
    }

    public void initialise(JBossMetaData dd) {
        this.interceptorsXml = dd.getInterceptors();
        if (dd.getAssemblyDescriptor() != null) {
            this.bindingsXml = dd.getAssemblyDescriptor().getInterceptorBindings();
        }
        this.initialiseInfosFromXml();
        this.initialiseDefaultInterceptors();
    }

    public void addBeanClass(String classname) {
        this.beanClasses.add(classname);
    }

    public InterceptorInfo getInterceptorInfo(Class clazz) {
        this.initialiseInfosFromXml();
        return (InterceptorInfo)this.infos.get(clazz);
    }

    public HashSet<InterceptorInfo> getDefaultInterceptors() {
        return this.defaultInterceptors;
    }

    public boolean hasDefaultInterceptors() {
        return this.defaultInterceptors.size() > 0;
    }

    public ArrayList<InterceptorInfo> getClassInterceptors(EJBContainer container) {
        Interceptors interceptors = (Interceptors)container.resolveAnnotation(Interceptors.class);
        ArrayList<InterceptorInfo> infos = this.getInterceptorsFromAnnotation(container, interceptors);
        return infos;
    }

    public ArrayList<InterceptorInfo> getMethodInterceptors(EJBContainer container, Method m) {
        Interceptors interceptors = (Interceptors)container.resolveAnnotation(m, Interceptors.class);
        ArrayList<InterceptorInfo> infos = this.getInterceptorsFromAnnotation(container, interceptors);
        return infos;
    }

    public Method[] getBeanClassAroundInvokes(EJBContainer container) {
        return this.getBeanClassInterceptors(container, AroundInvoke.class);
    }

    public Method[] getBeanClassPostConstructs(EJBContainer container) {
        return this.getBeanClassInterceptors(container, PostConstruct.class);
    }

    public Method[] getBeanClassPostActivates(EJBContainer container) {
        return this.getBeanClassInterceptors(container, PostActivate.class);
    }

    public Method[] getBeanClassPrePassivates(EJBContainer container) {
        return this.getBeanClassInterceptors(container, PrePassivate.class);
    }

    public Method[] getBeanClassPreDestroys(EJBContainer container) {
        return this.getBeanClassInterceptors(container, PreDestroy.class);
    }

    private Method[] getBeanClassInterceptors(EJBContainer container, Class type) {
        InterceptorInfo info = this.getOrInitialiseFromAnnotations(container);
        return this.getMethodsForEvent(info, type);
    }

    public InterceptorInfo[] getBusinessInterceptors(EJBContainer container, Method method) {
        return this.getInterceptors(container, AroundInvoke.class, method);
    }

    public InterceptorInfo[] getPostConstructInterceptors(EJBContainer container) {
        return this.getInterceptors(container, PostConstruct.class, null);
    }

    public InterceptorInfo[] getPostActivateInterceptors(EJBContainer container) {
        return this.getInterceptors(container, PostActivate.class, null);
    }

    public InterceptorInfo[] getPrePassivateInterceptors(EJBContainer container) {
        return this.getInterceptors(container, PrePassivate.class, null);
    }

    public InterceptorInfo[] getPreDestroyInterceptors(EJBContainer container) {
        return this.getInterceptors(container, PreDestroy.class, null);
    }

    private InterceptorInfo[] getInterceptors(EJBContainer container, Class type, Method method) {
        Collection<InterceptorInfo> infos;
        ArrayList<InterceptorInfo> interceptors = new ArrayList<InterceptorInfo>();
        if (!this.hasAnnotation(container, ExcludeDefaultInterceptors.class, method)) {
            infos = this.getDefaultInterceptors();
            if (infos != null) {
                interceptors.addAll(this.trimUnwanted(infos, type));
            }
            this.sorter.sortDefaultInterceptors(container, interceptors);
        }
        if (!this.hasAnnotation(container, ExcludeClassInterceptors.class, method)) {
            infos = container.getClassInterceptors();
            if (infos != null) {
                interceptors.addAll(this.trimUnwanted(infos, type));
            }
            if (type != AroundInvoke.class) {
                List<InterceptorInfo> methodOnlyInterceptors = this.getMethodOnlyInterceptorsForLifecycle(container, type, interceptors);
                if (infos != null) {
                    interceptors.addAll(methodOnlyInterceptors);
                }
            }
            this.sorter.sortClassInterceptors(container, interceptors);
        }
        if (type == AroundInvoke.class) {
            infos = this.getMethodInterceptors(container, method);
            if (infos != null) {
                interceptors.addAll(this.trimUnwanted(infos, type));
            }
            this.sorter.sortMethodInterceptors(container, method, interceptors);
        }
        InterceptorInfo[] ints = interceptors.toArray(new InterceptorInfo[interceptors.size()]);
        return ints;
    }

    private List<InterceptorInfo> getMethodOnlyInterceptorsForLifecycle(EJBContainer container, Class type, List<InterceptorInfo> infos) {
        HashSet methodLevelInterceptors = (HashSet)container.getApplicableInterceptors().clone();
        for (InterceptorInfo info : infos) {
            if (!methodLevelInterceptors.contains(info)) continue;
            methodLevelInterceptors.remove(info);
        }
        if (this.defaultInterceptors != null) {
            for (InterceptorInfo info : this.defaultInterceptors) {
                if (!methodLevelInterceptors.contains(info)) continue;
                methodLevelInterceptors.remove(info);
            }
        }
        List<InterceptorInfo> trimmedInfos = this.trimUnwanted(methodLevelInterceptors, type);
        return trimmedInfos;
    }

    private boolean hasAnnotation(EJBContainer container, Class annotation, Method method) {
        if (container.resolveAnnotation(annotation) != null) {
            return true;
        }
        if (method != null) {
            return container.resolveAnnotation(method, annotation) != null;
        }
        return false;
    }

    private List<InterceptorInfo> trimUnwanted(Collection<InterceptorInfo> interceptors, Class type) {
        ArrayList<InterceptorInfo> ints = new ArrayList<InterceptorInfo>(interceptors.size());
        ints.addAll(interceptors);
        Iterator it = ints.iterator();
        while (it.hasNext()) {
            InterceptorInfo info = (InterceptorInfo)it.next();
            if (this.hasMethodsForEvent(info, type)) continue;
            it.remove();
        }
        return ints;
    }

    private boolean hasMethodsForEvent(InterceptorInfo info, Class type) {
        return this.getMethodsForEvent(info, type) != null;
    }

    private Method[] getMethodsForEvent(InterceptorInfo info, Class type) {
        if (type == AroundInvoke.class) {
            return info.getAroundInvokes();
        }
        if (type == PostConstruct.class) {
            return info.getPostConstructs();
        }
        if (type == PostActivate.class) {
            return info.getPostActivates();
        }
        if (type == PrePassivate.class) {
            return info.getPrePassivates();
        }
        if (type == PreDestroy.class) {
            return info.getPreDestroys();
        }
        return null;
    }

    private ArrayList<InterceptorInfo> getInterceptorsFromAnnotation(EJBContainer container, Interceptors interceptors) {
        ArrayList<InterceptorInfo> inters = new ArrayList<InterceptorInfo>();
        if (interceptors == null) {
            return inters;
        }
        for (Class clazz : interceptors.value()) {
            InterceptorInfo info = this.getOrInitialiseFromAnnotations(clazz);
            this.validateInterceptorForContainer(container, info.getClazz());
            inters.add(info);
        }
        return inters;
    }

    private void validateInterceptorForContainer(EJBContainer container, Class interceptor) {
        if (this.beanClasses.contains(interceptor.getName()) && !interceptor.equals(container.getClazz())) {
            throw new RuntimeException("Bean class " + interceptor.getName() + " cannot be used as an interceptor for " + container.getEjbName());
        }
    }

    private void initialiseInfosFromXml() {
        if (this.interceptorsXml != null) {
            HashMap<String, AnnotationInitialiser> initialisers = new HashMap<String, AnnotationInitialiser>();
            for (InterceptorMetaData xml : this.interceptorsXml) {
                XmlInitialiser init = new XmlInitialiser(xml);
                initialisers.put(xml.getInterceptorClass(), init);
            }
            for (InterceptorMetaData xml : this.interceptorsXml) {
                String clazz = xml.getInterceptorClass();
                this.initialiseSuperClassesFirstFromXmlOrAnnotations(initialisers, clazz);
            }
        }
    }

    private InterceptorInfo initialiseSuperClassesFirstFromXmlOrAnnotations(HashMap<String, AnnotationInitialiser> initialisers, String superClassName) {
        if ("java.lang.Object".equals(superClassName)) {
            return null;
        }
        AnnotationInitialiser initialiser = initialisers.get(superClassName);
        if (initialiser == null) {
            initialiser = new AnnotationInitialiser(superClassName, InterceptorSignatureValidator.instance);
            initialisers.put(initialiser.getClazz().getName(), initialiser);
        }
        InterceptorInfo superInfo = this.initialiseSuperClassesFirstFromXmlOrAnnotations(initialisers, initialiser.getClazz().getSuperclass().getName());
        InterceptorInfo info = initialiser.getInfo();
        info.calculateHierarchy(superInfo);
        this.infos.put(info.getClazz(), info);
        return info;
    }

    private void initialiseDefaultInterceptors() {
        this.defaultInterceptors = new LinkedHashSet();
        if (this.bindingsXml != null) {
            for (InterceptorBindingMetaData bindingXml : this.bindingsXml) {
                if (!bindingXml.getEjbName().equals("*") || bindingXml.getMethod() != null) continue;
                for (String classname : bindingXml.getInterceptorClasses()) {
                    if (this.beanClasses.contains(classname)) {
                        throw new RuntimeException("Bean class defined in default binding " + classname);
                    }
                    InterceptorInfo info = this.getOrInitialiseFromAnnotations(classname);
                    this.defaultInterceptors.add(info);
                }
            }
        }
    }

    private InterceptorInfo getOrInitialiseFromAnnotations(String classname) {
        Class<?> clazz = this.loadClass(classname);
        return this.getOrInitialiseFromAnnotations(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterceptorInfo getOrInitialiseFromAnnotations(Class clazz) {
        InterceptorInfo info = (InterceptorInfo)this.infos.get(clazz);
        if (info == null) {
            InterceptorInfoRepository interceptorInfoRepository = this;
            synchronized (interceptorInfoRepository) {
                info = (InterceptorInfo)this.infos.get(clazz);
                if (info == null) {
                    info = this.initialiseFromAnnotations(clazz);
                    this.infos.put(clazz, info);
                }
            }
        }
        return info;
    }

    private InterceptorInfo initialiseFromAnnotations(Class clazz) {
        InterceptorInfo superInfo = null;
        if (clazz.getSuperclass() != Object.class) {
            superInfo = this.getOrInitialiseFromAnnotations(clazz.getSuperclass());
        }
        AnnotationInitialiser init = new AnnotationInitialiser(clazz, InterceptorSignatureValidator.instance);
        InterceptorInfo info = init.getInfo();
        info.calculateHierarchy(superInfo);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterceptorInfo getOrInitialiseFromAnnotations(EJBContainer container) {
        InterceptorInfo info = (InterceptorInfo)this.ejbInfos.get(container.getEjbName());
        if (info == null) {
            InterceptorInfoRepository interceptorInfoRepository = this;
            synchronized (interceptorInfoRepository) {
                info = (InterceptorInfo)this.ejbInfos.get(container.getEjbName());
                if (info == null) {
                    info = this.initialiseFromAnnotations(container);
                    this.ejbInfos.put(container.getEjbName(), info);
                }
            }
        }
        return info;
    }

    private InterceptorInfo initialiseFromAnnotations(EJBContainer container) {
        InterceptorInfo superInfo = this.initialiseContainerSuperClassFromAnnotationsOnly(container.getClazz().getSuperclass());
        ContainerInitialiser init = new ContainerInitialiser(container);
        InterceptorInfo info = init.getInfo();
        info.calculateHierarchy(superInfo);
        return info;
    }

    private InterceptorInfo initialiseContainerSuperClassFromAnnotationsOnly(Class clazz) {
        InterceptorInfo superInfo = null;
        if (clazz != Object.class) {
            superInfo = this.initialiseContainerSuperClassFromAnnotationsOnly(clazz.getSuperclass());
        }
        AnnotationInitialiser init = new AnnotationInitialiser(clazz, BeanSignatureValidator.instance);
        InterceptorInfo info = init.getInfo();
        info.calculateHierarchy(superInfo);
        return info;
    }

    private Class<?> loadClass(String name) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("Loading interceptor " + name + " from " + this.classLoader);
            }
            return this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Interceptor class not found: " + name + " in class loader " + this.classLoader, e);
        }
    }

    private static boolean checkExceptions(Class<?>[] allowedExceptions, Method method) {
        for (Class<?> exception : method.getExceptionTypes()) {
            boolean isAllowed = false;
            for (Class<?> allowed : allowedExceptions) {
                if (!allowed.isAssignableFrom(exception)) continue;
                isAllowed = true;
            }
            if (isAllowed) continue;
            log.warn("Illegal exception '" + exception.getName() + "' in lifecycle signature (EJB3 12.4.2): " + method);
            return false;
        }
        return true;
    }

    public static boolean checkValidBusinessSignature(Method method) {
        Class<?>[] exceptions;
        Class<?>[] params;
        int modifiers = method.getModifiers();
        return !Modifier.isStatic(modifiers) && method.getReturnType().equals(Object.class) && (params = method.getParameterTypes()).length == 1 && params[0].equals(InvocationContext.class) && (exceptions = method.getExceptionTypes()).length == 1 && exceptions[0].equals(Exception.class);
    }

    public static boolean checkValidLifecycleSignature(Method method) {
        Class<?>[] params;
        int modifiers = method.getModifiers();
        return !Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && (params = method.getParameterTypes()).length == 1 && params[0].equals(InvocationContext.class);
    }

    public static boolean checkValidBeanLifecycleSignature(Method method) {
        int modifiers = method.getModifiers();
        if (method.getName().equals("ejbCreate")) {
            if (!Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && method.getExceptionTypes().length <= 1) {
                return InterceptorInfoRepository.checkExceptions(new Class[]{RuntimeException.class, CreateException.class, RemoteException.class}, method);
            }
        } else if (!Modifier.isStatic(modifiers) && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0) {
            return InterceptorInfoRepository.checkExceptions(new Class[]{RuntimeException.class, RemoteException.class}, method);
        }
        return false;
    }

    public static String simpleType(Class type) {
        Class<?> ret = type;
        if (ret.isArray()) {
            Class<?> arr = ret;
            String array = "";
            while (arr.isArray()) {
                array = array + "[]";
                arr = arr.getComponentType();
            }
            return arr.getName() + array;
        }
        return ret.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InterceptorComparator
    implements Comparator<InterceptorInfo> {
        List<String> ordered;

        InterceptorComparator(InterceptorOrderMetaData ordered) {
            assert (ordered != null) : "ordered is null";
            this.ordered = new ArrayList<String>(ordered);
        }

        @Override
        public int compare(InterceptorInfo o1, InterceptorInfo o2) {
            int pos1 = this.ordered.indexOf(o1.getClazz().getName());
            int pos2 = this.ordered.indexOf(o2.getClazz().getName());
            if (pos1 < 0) {
                pos1 = Integer.MAX_VALUE;
            }
            if (pos2 < 0) {
                pos2 = Integer.MAX_VALUE;
            }
            if (pos1 < pos2) {
                return -1;
            }
            if (pos1 > pos2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InterceptorSorter {
        boolean initialised;
        List<InterceptorBindingMetaData> orderedBindings;

        private InterceptorSorter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initialise() {
            if (!this.initialised) {
                InterceptorSorter interceptorSorter = this;
                synchronized (interceptorSorter) {
                    if (InterceptorInfoRepository.this.bindingsXml != null) {
                        for (InterceptorBindingMetaData binding : InterceptorInfoRepository.this.bindingsXml) {
                            if (!binding.isTotalOrdering()) continue;
                            HashSet<String> names = new HashSet<String>();
                            for (String className : binding.getInterceptorOrder()) {
                                if (names.contains(className)) {
                                    throw new RuntimeException(className + " occurs more than once in ordered binding " + this.getInterceptorBindingString(binding));
                                }
                                names.add(className);
                            }
                            if (this.orderedBindings == null) {
                                this.orderedBindings = new ArrayList<InterceptorBindingMetaData>();
                            }
                            this.orderedBindings.add(binding);
                        }
                    }
                }
                log.trace("orderedBindings = " + this.orderedBindings);
                this.initialised = true;
            }
        }

        void sortDefaultInterceptors(EJBContainer container, ArrayList<InterceptorInfo> infos) {
            this.initialise();
            if (this.orderedBindings == null) {
                return;
            }
            InterceptorOrderMetaData bindingOrder = null;
            for (InterceptorBindingMetaData binding : this.orderedBindings) {
                if (!binding.getEjbName().equals("*")) continue;
                if (bindingOrder != null) {
                    throw new RuntimeException("There should only be one interceptor-binding specifying the order of default interceptors " + this.getInterceptorBindingString(binding));
                }
                bindingOrder = binding.getInterceptorOrder();
            }
            this.sortInterceptors(infos, bindingOrder);
        }

        void sortClassInterceptors(EJBContainer container, ArrayList<InterceptorInfo> infos) {
            this.initialise();
            if (this.orderedBindings == null) {
                return;
            }
            InterceptorOrderMetaData bindingOrder = null;
            for (InterceptorBindingMetaData binding : this.orderedBindings) {
                if (binding.getMethod() != null || !binding.getEjbName().equals(container.getEjbName())) continue;
                if (bindingOrder != null) {
                    throw new RuntimeException("There should only be one interceptor-binding specifying the order of class interceptors: " + this.getInterceptorBindingString(binding));
                }
                bindingOrder = binding.getInterceptorOrder();
            }
            this.sortInterceptors(infos, bindingOrder);
        }

        void sortMethodInterceptors(EJBContainer container, Method method, ArrayList<InterceptorInfo> infos) {
            this.initialise();
            if (this.orderedBindings == null) {
                return;
            }
            InterceptorOrderMetaData methodNoParamsOrder = null;
            InterceptorOrderMetaData methodParamsOrder = null;
            for (InterceptorBindingMetaData binding : this.orderedBindings) {
                NamedMethodMetaData bindingMethod;
                if (!binding.getEjbName().equals(container.getEjbName()) || (bindingMethod = binding.getMethod()) == null) continue;
                if (bindingMethod.getMethodParams() == null) {
                    if (methodNoParamsOrder != null) {
                        throw new RuntimeException("There should only be one interceptor-binding specifying the order of method interceptors: " + this.getInterceptorBindingString(binding));
                    }
                    methodNoParamsOrder = binding.getInterceptorOrder();
                    continue;
                }
                Class<?>[] params = method.getParameterTypes();
                MethodParametersMetaData methodParams = bindingMethod.getMethodParams();
                if (methodParams.size() != params.length) continue;
                boolean matches = true;
                for (int i = 0; i < params.length; ++i) {
                    if (InterceptorInfoRepository.simpleType(params[i]).equals(methodParams.get(i))) continue;
                    matches = false;
                    break;
                }
                if (!matches) continue;
                if (methodParamsOrder != null) {
                    boolean first = false;
                    StringBuffer paramBuf = new StringBuffer();
                    paramBuf.append("(");
                    for (String par : methodParams) {
                        if (!first) {
                            paramBuf.append(",");
                        }
                        paramBuf.append(par);
                    }
                    paramBuf.append(")");
                    throw new RuntimeException("There should only be one interceptor-binding specifying the order of method interceptors: " + this.getInterceptorBindingString(binding));
                }
                methodParamsOrder = binding.getInterceptorOrder();
            }
            if (methodParamsOrder != null) {
                this.sortInterceptors(infos, methodParamsOrder);
            } else {
                this.sortInterceptors(infos, methodNoParamsOrder);
            }
        }

        void sortInterceptors(ArrayList<InterceptorInfo> infos, InterceptorOrderMetaData interceptorOrder) {
            if (interceptorOrder == null) {
                return;
            }
            Collections.sort(infos, new InterceptorComparator(interceptorOrder));
        }

        String getInterceptorBindingString(InterceptorBindingMetaData binding) {
            StringBuffer buf = new StringBuffer();
            buf.append(binding.getEjbName());
            NamedMethodMetaData method = binding.getMethod();
            if (method != null) {
                buf.append("." + method.getMethodName());
                MethodParametersMetaData methodParams = method.getMethodParams();
                if (methodParams != null) {
                    buf.append("(");
                    int i = 0;
                    while (i < methodParams.size()) {
                        if (i == 0) {
                            buf.append(",");
                        }
                        buf.append((String)methodParams.get(i));
                    }
                    buf.append(")");
                }
            }
            return buf.toString();
        }
    }

    private class XmlInitialiser
    extends AnnotationInitialiser {
        InterceptorMetaData xml;

        XmlInitialiser(InterceptorMetaData xml) {
            super(xml.getInterceptorClass(), InterceptorSignatureValidator.instance);
            this.xml = xml;
        }

        InterceptorInfo getInfo() {
            this.info.setAroundInvoke(this.findInterceptorMethodFromXml("around-invoke-method", this.xml.getAroundInvokes()));
            this.info.setPostConstruct(this.findInterceptorMethodFromXml("post-construct-method", this.xml.getPostConstructs()));
            this.info.setPostActivate(this.findInterceptorMethodFromXml("post-activate-method", this.xml.getPostActivates()));
            this.info.setPreDestroy(this.findInterceptorMethodFromXml("pre-destroy-method", this.xml.getPreDestroys()));
            this.info.setPrePassivate(this.findInterceptorMethodFromXml("pre-passivate-method", this.xml.getPrePassivates()));
            super.getInfo();
            this.info.setXml(this.xml);
            return this.info;
        }

        Method findInterceptorMethodFromXml(String lookingFor, AroundInvokesMetaData aroundInvokes) {
            if (aroundInvokes == null) {
                return null;
            }
            if (aroundInvokes.size() != 1) {
                throw new RuntimeException("NYI");
            }
            AroundInvokeMetaData aroundInvoke = (AroundInvokeMetaData)aroundInvokes.get(0);
            return this.findInterceptorMethodFromXml(lookingFor, aroundInvoke.getClassName(), aroundInvoke.getMethodName());
        }

        Method findInterceptorMethodFromXml(String lookingFor, LifecycleCallbacksMetaData lifecycleCallbacks) {
            if (lifecycleCallbacks == null) {
                return null;
            }
            if (lifecycleCallbacks.size() != 1) {
                throw new RuntimeException("NYI");
            }
            LifecycleCallbackMetaData lifecycleCallback = (LifecycleCallbackMetaData)lifecycleCallbacks.get(0);
            return this.findInterceptorMethodFromXml(lookingFor, lifecycleCallback.getClassName(), lifecycleCallback.getMethodName());
        }

        Method findInterceptorMethodFromXml(String lookingFor, String className, String methodName) {
            if (this.xml == null) {
                return null;
            }
            Class cls = className == null ? this.clazz : InterceptorInfoRepository.this.loadClass(className);
            if (methodName == null || methodName.trim().equals("")) {
                throw new RuntimeException(lookingFor + " must contain a valid method name for interceptor " + this.clazz.getName());
            }
            ArrayList<Method> possible = new ArrayList<Method>();
            for (Method method : cls.getDeclaredMethods()) {
                if (!methodName.equals(method.getName())) continue;
                possible.add(method);
            }
            if (possible.size() == 0) {
                throw new RuntimeException(lookingFor + " can't find method " + methodName + " on " + cls.getName());
            }
            Method found = null;
            for (Method method : possible) {
                if (lookingFor.equals("around-invoke-method")) {
                    if (!this.signatureValidator.checkValidAround(method)) continue;
                    found = method;
                    continue;
                }
                if (!this.signatureValidator.checkValidLifecycle(method)) continue;
                found = method;
            }
            if (found == null) {
                throw new RuntimeException(lookingFor + " has the wrong method signature for interceptor " + this.clazz.getName());
            }
            return found;
        }
    }

    private class ContainerInitialiser
    extends AnnotationInitialiser {
        EJBContainer container;

        public ContainerInitialiser(EJBContainer container) {
            super(container.getBeanClass(), BeanSignatureValidator.instance);
            this.container = container;
        }

        Object getAnnotation(Method method, Class annotation) {
            return this.container.resolveAnnotation(method, annotation);
        }

        Method resolveLifecycleMethod(Method method, Annotation ann) {
            if (ann != null) {
                if (!this.signatureValidator.checkValidLifecycle(method)) {
                    throw new RuntimeException("@" + ann.annotationType().getName() + " annotated method has the wrong signature - " + method + " (EJB3 12.4)");
                }
                return method;
            }
            return null;
        }
    }

    private class AnnotationInitialiser {
        SignatureValidator signatureValidator;
        Class clazz;
        InterceptorInfo info;

        AnnotationInitialiser(String classname, SignatureValidator signatureValidator) {
            this.clazz = InterceptorInfoRepository.this.loadClass(classname);
            this.signatureValidator = signatureValidator;
            this.info = new InterceptorInfo(this.clazz);
        }

        AnnotationInitialiser(Class clazz, SignatureValidator signatureValidator) {
            this.clazz = clazz;
            this.signatureValidator = signatureValidator;
            this.info = new InterceptorInfo(clazz);
        }

        public Class getClazz() {
            return this.clazz;
        }

        InterceptorInfo getInfo() {
            for (Method method : this.clazz.getDeclaredMethods()) {
                this.info.setAroundInvoke(this.resolveAroundInvoke(method));
                this.info.setPostConstruct(this.resolvePostConstruct(method));
                this.info.setPostActivate(this.resolvePostActivate(method));
                this.info.setPreDestroy(this.resolvePreDestroy(method));
                this.info.setPrePassivate(this.resolvePrePassivate(method));
            }
            return this.info;
        }

        Method resolveAroundInvoke(Method method) {
            AroundInvoke ann = (AroundInvoke)this.getAnnotation(method, AroundInvoke.class);
            if (ann != null) {
                if (!this.signatureValidator.checkValidAround(method)) {
                    throw new RuntimeException("@" + ann.annotationType().getName() + " annotated method in has the wrong signature - " + method);
                }
                return method;
            }
            return null;
        }

        Method resolvePostConstruct(Method method) {
            PostConstruct ann = (PostConstruct)this.getAnnotation(method, PostConstruct.class);
            return this.resolveLifecycleMethod(method, ann);
        }

        Method resolvePostActivate(Method method) {
            PostActivate ann = (PostActivate)this.getAnnotation(method, PostActivate.class);
            return this.resolveLifecycleMethod(method, ann);
        }

        Method resolvePreDestroy(Method method) {
            PreDestroy ann = (PreDestroy)this.getAnnotation(method, PreDestroy.class);
            return this.resolveLifecycleMethod(method, ann);
        }

        Method resolvePrePassivate(Method method) {
            PrePassivate ann = (PrePassivate)this.getAnnotation(method, PrePassivate.class);
            return this.resolveLifecycleMethod(method, ann);
        }

        Method resolveLifecycleMethod(Method method, Annotation ann) {
            if (ann != null) {
                if (!this.signatureValidator.checkValidLifecycle(method)) {
                    throw new RuntimeException("@" + ann.annotationType().getName() + " annotated method  has the wrong signature - " + method);
                }
                return method;
            }
            return null;
        }

        Object getAnnotation(Method method, Class annotation) {
            return method.getAnnotation(annotation);
        }
    }

    private static class BeanSignatureValidator
    implements SignatureValidator {
        static SignatureValidator instance = new BeanSignatureValidator();

        private BeanSignatureValidator() {
        }

        public boolean checkValidAround(Method m) {
            return InterceptorInfoRepository.checkValidBusinessSignature(m);
        }

        public boolean checkValidLifecycle(Method m) {
            return InterceptorInfoRepository.checkValidBeanLifecycleSignature(m);
        }
    }

    private static class InterceptorSignatureValidator
    implements SignatureValidator {
        static SignatureValidator instance = new InterceptorSignatureValidator();

        private InterceptorSignatureValidator() {
        }

        public boolean checkValidAround(Method m) {
            return InterceptorInfoRepository.checkValidBusinessSignature(m);
        }

        public boolean checkValidLifecycle(Method m) {
            return InterceptorInfoRepository.checkValidLifecycleSignature(m);
        }
    }

    private static interface SignatureValidator {
        public boolean checkValidLifecycle(Method var1);

        public boolean checkValidAround(Method var1);
    }
}

