/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.PayloadKey;

public class ClientInterceptorUtil {
    public static final String CLIENT_METADATA = "jboss.ejb3.client.invocation.metadata";

    public static void addMetadata(Invocation invocation, Object key, Object value, PayloadKey payload) {
        invocation.getMetaData().addMetaData(CLIENT_METADATA, key, value, payload);
    }

    public static void addMetadata(Invocation invocation, Object key, Object value) {
        invocation.getMetaData().addMetaData(CLIENT_METADATA, key, value);
    }

    public static Object getMetadata(Invocation invocation, Object key) {
        return invocation.getMetaData().getMetaData(CLIENT_METADATA, key);
    }

    static Map getClientMetadataMap(Invocation invocation) {
        HashMap map = invocation.getMetaData().tag(CLIENT_METADATA);
        if (map != null) {
            return new ClientValueMap(map);
        }
        return null;
    }

    private static class ClientValueMap
    implements Map {
        Map marshalledMap;
        boolean haveUnmarshalledAllEntries;

        private ClientValueMap(Map marshalledMap) {
            this.marshalledMap = marshalledMap;
        }

        public void clear() {
            this.marshalledMap.clear();
        }

        public boolean containsKey(Object key) {
            return this.marshalledMap.containsKey(key);
        }

        public boolean containsValue(Object value) {
            this.unmarshallAllEntries();
            return this.marshalledMap.containsValue(value);
        }

        public Set entrySet() {
            this.unmarshallAllEntries();
            return this.marshalledMap.entrySet();
        }

        public boolean equals(Object o) {
            return ((Object)this.marshalledMap).equals(o);
        }

        public Object get(Object key) {
            return this.unmarshallEntry(key);
        }

        public int hashCode() {
            return ((Object)this.marshalledMap).hashCode();
        }

        public boolean isEmpty() {
            return this.marshalledMap.isEmpty();
        }

        public Set keySet() {
            return this.marshalledMap.keySet();
        }

        public Object put(Object key, Object value) {
            return this.marshalledMap.put(key, value);
        }

        public void putAll(Map t) {
            this.marshalledMap.putAll(t);
        }

        public Object remove(Object key) {
            return this.marshalledMap.remove(key);
        }

        public int size() {
            return this.marshalledMap.size();
        }

        public Collection values() {
            this.unmarshallAllEntries();
            return this.marshalledMap.values();
        }

        private void unmarshallAllEntries() {
            if (this.haveUnmarshalledAllEntries) {
                return;
            }
            Iterator keys = this.marshalledMap.keySet().iterator();
            while (keys.hasNext()) {
                this.unmarshallEntry(keys.next());
            }
            this.haveUnmarshalledAllEntries = true;
        }

        private Object unmarshallEntry(Object key) {
            try {
                Object obj = this.marshalledMap.get(key);
                if (obj instanceof SimpleMetaData.MetaDataValue) {
                    Object realObj = ((SimpleMetaData.MetaDataValue)obj).get();
                    this.marshalledMap.put(key, realObj);
                    return realObj;
                }
                return obj;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

