/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.schema;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Table;
import org.jboss.logging.Logger;

public class RelationTable
implements Table {
    private static final byte CREATED = 1;
    private static final byte DELETED = 2;
    private final Schema schema;
    private final int tableId;
    private final DataSource ds;
    private final String tableName;
    private final JDBCCMRFieldBridge2 leftField;
    private final JDBCCMRFieldBridge2 rightField;
    private final Logger log;
    private String insertSql;
    private String deleteSql;

    public RelationTable(JDBCCMRFieldBridge2 leftField, JDBCCMRFieldBridge2 rightField, Schema schema, int tableId) throws DeploymentException {
        int i;
        this.schema = schema;
        this.tableId = tableId;
        this.leftField = leftField;
        this.rightField = rightField;
        JDBCRelationMetaData metadata = leftField.getMetaData().getRelationMetaData();
        this.ds = metadata.getDataSource();
        this.tableName = SQLUtil.fixTableName(metadata.getDefaultTableName(), this.ds);
        this.log = Logger.getLogger(this.getClass().getName() + "." + this.tableName);
        this.insertSql = "insert into " + this.tableName + " (";
        JDBCCMPFieldBridge2[] keyFields = (JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
        this.insertSql = this.insertSql + keyFields[0].getColumnName();
        for (i = 1; i < keyFields.length; ++i) {
            this.insertSql = this.insertSql + ", " + keyFields[i].getColumnName();
        }
        keyFields = (JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
        this.insertSql = this.insertSql + ", " + keyFields[0].getColumnName();
        for (i = 1; i < keyFields.length; ++i) {
            this.insertSql = this.insertSql + ", " + keyFields[i].getColumnName();
        }
        this.insertSql = this.insertSql + ") values (?";
        for (i = 1; i < this.leftField.getTableKeyFields().length + this.rightField.getTableKeyFields().length; ++i) {
            this.insertSql = this.insertSql + ", ?";
        }
        this.insertSql = this.insertSql + ")";
        this.log.debug("insert sql: " + this.insertSql);
        this.deleteSql = "delete from " + this.tableName + " where ";
        keyFields = (JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
        this.deleteSql = this.deleteSql + keyFields[0].getColumnName() + "=?";
        for (i = 1; i < keyFields.length; ++i) {
            this.deleteSql = this.deleteSql + " and " + keyFields[i].getColumnName() + "=?";
        }
        keyFields = (JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
        this.deleteSql = this.deleteSql + " and " + keyFields[0].getColumnName() + "=?";
        for (i = 1; i < keyFields.length; ++i) {
            this.deleteSql = this.deleteSql + " and " + keyFields[i].getColumnName() + "=?";
        }
        this.log.debug("delete sql: " + this.deleteSql);
    }

    public void addRelation(JDBCCMRFieldBridge2 field1, Object key1, JDBCCMRFieldBridge2 field2, Object key2) {
        View view = this.getView();
        if (field1 == this.leftField) {
            view.addKeys(key1, key2);
        } else {
            view.addKeys(key2, key1);
        }
    }

    public void removeRelation(JDBCCMRFieldBridge2 field1, Object key1, JDBCCMRFieldBridge2 field2, Object key2) {
        View view = this.getView();
        if (field1 == this.leftField) {
            view.removeKeys(key1, key2);
        } else {
            view.removeKeys(key2, key1);
        }
    }

    public int getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Table.View createView(Transaction tx) {
        return new View();
    }

    private void delete(View view) throws SQLException {
        if (view.deleted == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("no rows to delete");
            }
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            block11: {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("executing : " + this.deleteSql);
                    }
                    con = this.ds.getConnection();
                    ps = con.prepareStatement(this.deleteSql);
                    int batchCount = 0;
                    while (view.deleted != null) {
                        Object fieldValue;
                        JDBCCMPFieldBridge2 pkField;
                        int pkInd;
                        RelationKeys keys = view.deleted;
                        int paramInd = 1;
                        JDBCCMPFieldBridge2[] keyFields = (JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
                        for (pkInd = 0; pkInd < keyFields.length; ++pkInd) {
                            pkField = keyFields[pkInd];
                            fieldValue = pkField.getPrimaryKeyValue(keys.leftKey);
                            paramInd = pkField.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        keyFields = (JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
                        for (pkInd = 0; pkInd < keyFields.length; ++pkInd) {
                            pkField = keyFields[pkInd];
                            fieldValue = pkField.getPrimaryKeyValue(keys.rightKey);
                            paramInd = pkField.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        ps.addBatch();
                        ++batchCount;
                        keys.dereference();
                    }
                    ps.executeBatch();
                    if (view.deleted != null) {
                        throw new IllegalStateException("There are still rows to delete!");
                    }
                    if (!this.log.isTraceEnabled()) break block11;
                    this.log.trace("deleted rows: " + batchCount);
                }
                catch (SQLException e) {
                    this.log.error("Failed to delete view: " + e.getMessage(), e);
                    throw e;
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
    }

    private void insert(View view) throws SQLException {
        if (view.created == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("no rows to insert");
            }
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        try {
            block10: {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("executing : " + this.insertSql);
                    }
                    con = this.ds.getConnection();
                    ps = con.prepareStatement(this.insertSql);
                    int batchCount = 0;
                    while (view.created != null) {
                        Object fieldValue;
                        JDBCCMPFieldBridge2 field;
                        int fInd;
                        RelationKeys keys = view.created;
                        JDBCCMPFieldBridge2[] keyFields = (JDBCCMPFieldBridge2[])this.leftField.getTableKeyFields();
                        int paramInd = 1;
                        for (fInd = 0; fInd < keyFields.length; ++fInd) {
                            field = keyFields[fInd];
                            fieldValue = field.getPrimaryKeyValue(keys.leftKey);
                            paramInd = field.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        keyFields = (JDBCCMPFieldBridge2[])this.rightField.getTableKeyFields();
                        for (fInd = 0; fInd < keyFields.length; ++fInd) {
                            field = keyFields[fInd];
                            fieldValue = field.getPrimaryKeyValue(keys.rightKey);
                            paramInd = field.setArgumentParameters(ps, paramInd, fieldValue);
                        }
                        ps.addBatch();
                        ++batchCount;
                        keys.dereference();
                    }
                    ps.executeBatch();
                    if (!this.log.isTraceEnabled()) break block10;
                    this.log.trace("inserted rows: " + batchCount);
                }
                catch (SQLException e) {
                    this.log.error("Failed to insert new rows: " + e.getMessage(), e);
                    throw e;
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
    }

    private View getView() {
        return (View)this.schema.getView(this);
    }

    private class RelationKeys {
        private final View view;
        private final Object leftKey;
        private final Object rightKey;
        private byte state;
        private RelationKeys next;
        private RelationKeys prev;

        public RelationKeys(View view, Object leftKey, Object rightKey) {
            this.view = view;
            this.leftKey = leftKey;
            this.rightKey = rightKey;
        }

        public boolean equals(Object leftKey, Object rightKey) {
            return this.leftKey.equals(leftKey) && this.rightKey.equals(rightKey);
        }

        public void dereference() {
            if (this.state == 1 && this == this.view.created) {
                this.view.created = this.next;
            } else if (this.state == 2 && this == this.view.deleted) {
                this.view.deleted = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = null;
            this.prev = null;
        }
    }

    private class View
    implements Table.View {
        private RelationKeys created;
        private RelationKeys deleted;

        private View() {
        }

        public void addKeys(Object leftKey, Object rightKey) {
            RelationKeys keys = this.deleted;
            while (keys != null) {
                if (keys.equals(leftKey, rightKey)) {
                    keys.dereference();
                    return;
                }
                keys = keys.next;
            }
            keys = new RelationKeys(this, leftKey, rightKey);
            if (this.created != null) {
                keys.next = this.created;
                this.created.prev = keys;
            }
            this.created = keys;
            keys.state = (byte)1;
        }

        public void removeKeys(Object leftKey, Object rightKey) {
            RelationKeys keys = this.created;
            while (keys != null) {
                if (keys.equals(leftKey, rightKey)) {
                    keys.dereference();
                    return;
                }
                keys = keys.next;
            }
            keys = new RelationKeys(this, leftKey, rightKey);
            if (this.deleted != null) {
                keys.next = this.deleted;
                this.deleted.prev = keys;
            }
            this.deleted = keys;
            keys.state = (byte)2;
        }

        public void flushDeleted(Schema.Views views) throws SQLException {
            RelationTable.this.delete(this);
        }

        public void flushCreated(Schema.Views views) throws SQLException {
            RelationTable.this.insert(this);
        }

        public void flushUpdated() throws SQLException {
        }

        public void beforeCompletion() {
        }

        public void committed() {
        }

        public void rolledback() {
        }
    }
}

