/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2.schema;

import java.io.Serializable;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.invalidation.Invalidatable;
import org.jboss.cache.invalidation.InvalidationGroup;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache;
import org.jboss.logging.Logger;

public class CacheInvalidator
implements Invalidatable {
    private static final Logger log = Logger.getLogger(CacheInvalidator.class);
    private final Cache cache;
    private final TransactionManager tm;
    private final InvalidationGroup group;

    public CacheInvalidator(Cache cache, TransactionManager tm, InvalidationGroup group) {
        this.cache = cache;
        this.tm = tm;
        this.group = group;
        group.register(this);
        log.debug("registered to group " + group.getGroupName());
    }

    public void unregister() {
        this.group.unregister(this);
        log.debug("unregistered from group " + this.group.getGroupName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isInvalid(Serializable key) {
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
        }
        catch (SystemException e) {
            log.error("Failed to obtain the current transaction", e);
            throw new IllegalStateException("Failed to obtain the current transaction: " + e.getMessage());
        }
        if (log.isTraceEnabled()) {
            log.trace("invalidating key=" + key);
        }
        this.cache.lock(key);
        try {
            try {
                this.cache.remove(tx, key);
            }
            catch (Cache.RemoveException e) {
                if (log.isTraceEnabled()) {
                    log.trace(e.getMessage());
                }
                Object var5_6 = null;
                this.cache.unlock(key);
            }
            Object var5_5 = null;
            this.cache.unlock(key);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.cache.unlock(key);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void areInvalid(Serializable[] keys) {
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
        }
        catch (SystemException e) {
            log.error("Failed to obtain the current transaction", e);
            throw new IllegalStateException("Failed to obtain the current transaction: " + e.getMessage());
        }
        boolean trace = log.isTraceEnabled();
        for (int i = 0; i < keys.length; ++i) {
            Object var7_7;
            if (trace) {
                log.trace("invalidating key[" + i + "]=" + keys[i]);
            }
            this.cache.lock(keys[i]);
            try {
                try {
                    this.cache.remove(tx, keys[i]);
                }
                catch (Cache.RemoveException e) {
                    if (trace) {
                        log.trace(e.getMessage());
                    }
                    var7_7 = null;
                    this.cache.unlock(keys[i]);
                    continue;
                }
                var7_7 = null;
                this.cache.unlock(keys[i]);
                continue;
            }
            catch (Throwable throwable) {
                var7_7 = null;
                this.cache.unlock(keys[i]);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        this.cache.lock();
        try {
            this.cache.flush();
            Object var2_1 = null;
            this.cache.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.cache.unlock();
            throw throwable;
        }
    }
}

