/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;

public class JDBCOracleCreateCommand
extends JDBCIdentityColumnCreateCommand {
    private String sequence;
    private int jdbcType;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        super.init(manager);
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        super.initEntityCommand(entityCommand);
        this.sequence = entityCommand.getAttribute("sequence");
        if (this.sequence == null) {
            throw new DeploymentException("Sequence must be specified");
        }
    }

    protected void initInsertSQL() {
        this.jdbcType = this.pkField.getJDBCType().getJDBCTypes()[0];
        StringBuffer sql = new StringBuffer();
        sql.append("{call INSERT INTO ").append(this.entity.getQualifiedTableName());
        sql.append(" (");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(", ");
        SQLUtil.getColumnNamesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" VALUES (");
        sql.append(this.sequence + ".NEXTVAL, ");
        SQLUtil.getValuesClause(this.insertFields, sql);
        sql.append(")");
        sql.append(" RETURNING ");
        SQLUtil.getColumnNamesClause(this.pkField, sql).append(" INTO ? }");
        this.insertSQL = sql.toString();
        if (this.debug) {
            this.log.debug("Insert Entity SQL: " + this.insertSQL);
        }
    }

    protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx) throws SQLException {
        return c.prepareCall(sql);
    }

    protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        CallableStatement cs = (CallableStatement)ps;
        cs.registerOutParameter(paramIndex, this.jdbcType);
        cs.execute();
        Object pk = JDBCUtil.getParameter(this.log, cs, paramIndex, this.jdbcType, this.pkField.getFieldType());
        this.pkField.setInstanceValue(ctx, pk);
        return 1;
    }
}

