/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.plugins.cmp.bridge.EntityBridgeInvocationHandler;
import org.jboss.ejb.plugins.cmp.bridge.FieldBridge;
import org.jboss.ejb.plugins.cmp.bridge.SelectorBridge;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.proxy.compiler.InvocationHandler;
import org.jboss.proxy.compiler.Proxy;

public final class JDBCCreateBeanClassInstanceCommand {
    private final JDBCEntityBridge entityBridge;
    private final Class beanClass;
    private final Constructor beanProxyConstructor;
    private final Map fieldMap;
    private final Map selectorMap;

    public JDBCCreateBeanClassInstanceCommand(JDBCStoreManager manager) throws Exception {
        EntityContainer theContainer = manager.getContainer();
        this.entityBridge = (JDBCEntityBridge)manager.getEntityBridge();
        this.beanClass = theContainer.getBeanClass();
        this.fieldMap = this.createFieldMap();
        this.selectorMap = this.createSelectorMap();
        EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
        Class[] classes = new Class[]{this.beanClass};
        ClassLoader classLoader = this.beanClass.getClassLoader();
        Object o = Proxy.newProxyInstance(classLoader, classes, handler);
        this.beanProxyConstructor = o.getClass().getConstructor(InvocationHandler.class);
        this.execute();
    }

    public void destroy() {
        Proxy.forgetProxyForClass(this.beanClass);
    }

    public Object execute() throws Exception {
        EntityBridgeInvocationHandler handler = new EntityBridgeInvocationHandler(this.fieldMap, this.selectorMap, this.beanClass);
        return this.beanProxyConstructor.newInstance(handler);
    }

    private Map getAbstractAccessors() {
        Method[] methods = this.beanClass.getMethods();
        HashMap<String, Method> abstractAccessors = new HashMap<String, Method>(methods.length);
        for (int i = 0; i < methods.length; ++i) {
            String methodName;
            if (!Modifier.isAbstract(methods[i].getModifiers()) || !(methodName = methods[i].getName()).startsWith("get") && !methodName.startsWith("set")) continue;
            abstractAccessors.put(methodName, methods[i]);
        }
        return abstractAccessors;
    }

    private Map createFieldMap() throws DeploymentException {
        Map abstractAccessors = this.getAbstractAccessors();
        List fields = this.entityBridge.getFields();
        HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker> map = new HashMap<String, EntityBridgeInvocationHandler.BridgeInvoker>(fields.size() * 2);
        for (int i = 0; i < fields.size(); ++i) {
            FieldBridge field = (FieldBridge)fields.get(i);
            String fieldName = field.getFieldName();
            String fieldBaseName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            String getterName = "get" + fieldBaseName;
            String setterName = "set" + fieldBaseName;
            Method getterMethod = (Method)abstractAccessors.get(getterName);
            Method setterMethod = (Method)abstractAccessors.get(setterName);
            if (getterMethod != null && setterMethod == null) {
                throw new DeploymentException("Getter was found but no setter was found for field " + fieldName + " in entity " + this.entityBridge.getEntityName());
            }
            if (getterMethod == null && setterMethod != null) {
                throw new DeploymentException("Setter was found but no getter was found for field " + fieldName + " in entity " + this.entityBridge.getEntityName());
            }
            if (getterMethod == null || setterMethod == null) continue;
            map.put(getterMethod.getName(), new EntityBridgeInvocationHandler.FieldGetInvoker(field));
            map.put(setterMethod.getName(), new EntityBridgeInvocationHandler.FieldSetInvoker(field));
            abstractAccessors.remove(getterName);
            abstractAccessors.remove(setterName);
        }
        return Collections.unmodifiableMap(map);
    }

    private Map createSelectorMap() {
        Collection selectors = this.entityBridge.getSelectors();
        HashMap<Method, SelectorBridge> map = new HashMap<Method, SelectorBridge>(selectors.size());
        for (SelectorBridge selector : selectors) {
            map.put(selector.getMethod(), selector);
        }
        return Collections.unmodifiableMap(map);
    }
}

