/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb.EJBPermissionMapping;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.web.WebPermissionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaccPolicyUtil {
    public static String IGNORE_ME_NAME = "org.jboss.deployment.security.ignoreMe";

    public static List<String> getJaccDeployments(VFSDeploymentUnit unit, Collection<String> ignoreSuffix) {
        ArrayList<String> list2 = new ArrayList<String>();
        List<VFSDeploymentUnit> children = unit.getVFSChildren();
        for (VFSDeploymentUnit child : children) {
            String childName = child.getSimpleName();
            boolean tobeIgnored = false;
            if (ignoreSuffix != null) {
                for (String ignoreStr : ignoreSuffix) {
                    tobeIgnored = false;
                    if (!childName.endsWith(ignoreStr)) continue;
                    tobeIgnored = true;
                    break;
                }
            }
            if (childName.endsWith("jar") && !tobeIgnored && !JaccPolicyUtil.isEJBDeployment(child) || tobeIgnored) continue;
            list2.add(childName);
        }
        return list2;
    }

    public static boolean isEJBDeployment(VFSDeploymentUnit du) {
        Boolean ignoreMe = du.getAttachment(IGNORE_ME_NAME, Boolean.class);
        if (ignoreMe != null && ignoreMe.booleanValue()) {
            return false;
        }
        boolean ejbxml = du.getMetaDataFile("ejb-jar.xml") != null;
        boolean jbossxml = du.getMetaDataFile("jboss.xml") != null;
        return ejbxml || jbossxml;
    }

    public static void createPermissions(PolicyConfiguration policyConfiguration, Object metadata) throws PolicyContextException {
        if (metadata == null) {
            throw new IllegalArgumentException("Meta Data is null");
        }
        if (policyConfiguration == null) {
            throw new IllegalArgumentException("Policy Configuration is null");
        }
        if (metadata instanceof JBossWebMetaData) {
            JBossWebMetaData wmd = (JBossWebMetaData)metadata;
            WebPermissionMapping.createPermissions(wmd, policyConfiguration);
        } else if (metadata instanceof JBossEnterpriseBeanMetaData) {
            JBossEnterpriseBeanMetaData bmd = (JBossEnterpriseBeanMetaData)metadata;
            EJBPermissionMapping.createPermissions(bmd, policyConfiguration);
        } else if (metadata instanceof JBossMetaData) {
            JBossMetaData jmd = (JBossMetaData)metadata;
            JBossEnterpriseBeansMetaData beans = jmd.getEnterpriseBeans();
            for (JBossEnterpriseBeanMetaData bmd : beans) {
                EJBPermissionMapping.createPermissions(bmd, policyConfiguration);
            }
        } else {
            throw new IllegalStateException("Unknown metadata");
        }
    }
}

