/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.helpers.AbstractStructureBuilder;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentContext;
import org.jboss.deployers.vfs.plugins.structure.SecurityActions;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;

public class VFSStructureBuilder
extends AbstractStructureBuilder {
    private static final Logger log = Logger.getLogger(VFSStructureBuilder.class);

    protected DeploymentContext createRootDeploymentContext(Deployment deployment) throws Exception {
        if (deployment instanceof VFSDeployment) {
            VFSDeployment vfsDeployment = (VFSDeployment)deployment;
            return new AbstractVFSDeploymentContext(vfsDeployment.getRoot(), "");
        }
        return super.createRootDeploymentContext(deployment);
    }

    protected DeploymentContext createChildDeploymentContext(DeploymentContext parent, ContextInfo child) throws Exception {
        if (parent instanceof VFSDeploymentContext) {
            VFSDeploymentContext vfsParent = (VFSDeploymentContext)parent;
            String path = child.getPath();
            try {
                VirtualFile parentFile = vfsParent.getRoot();
                VirtualFile file = parentFile.findChild(path);
                return new AbstractVFSDeploymentContext(file, path);
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException("Unable to determine child " + path + " from parent " + vfsParent.getRoot().getName(), t);
            }
        }
        return super.createChildDeploymentContext(parent, child);
    }

    protected void applyContextInfo(DeploymentContext context, ContextInfo contextInfo) throws Exception {
        super.applyContextInfo(context, contextInfo);
        if (context instanceof VFSDeploymentContext) {
            boolean trace = log.isTraceEnabled();
            log.trace("Apply context: " + context.getName() + " " + contextInfo);
            VFSDeploymentContext vfsContext = (VFSDeploymentContext)context;
            List<String> metaDataPath = contextInfo.getMetaDataPath();
            if (metaDataPath != null && !metaDataPath.isEmpty()) {
                vfsContext.setMetaDataPath(contextInfo.getMetaDataPath());
            }
            boolean classPathHadVF = false;
            List<ClassPathEntry> classPathEntries = contextInfo.getClassPath();
            VFSDeploymentContext top = vfsContext.getTopLevel();
            VirtualFile root = top.getRoot();
            ArrayList<VirtualFile> classPath = new ArrayList<VirtualFile>();
            if (classPathEntries != null) {
                for (ClassPathEntry entry : classPathEntries) {
                    VirtualFile child;
                    if (trace) {
                        log.trace("Resolving classpath entry " + entry + " for " + context.getName());
                    }
                    String suffixes = entry.getSuffixes();
                    if (entry.getPath().length() == 0) {
                        child = root;
                    } else {
                        try {
                            child = root.findChild(entry.getPath());
                        }
                        catch (Throwable t) {
                            throw DeploymentException.rethrowAsDeploymentException("Unable to find class path entry " + entry + " from " + root.getName(), t);
                        }
                    }
                    if (suffixes == null) {
                        classPath.add(child);
                        if (classPathHadVF) continue;
                        classPathHadVF = child.equals(root);
                        continue;
                    }
                    String[] suffs = suffixes.split(",");
                    SuffixMatchFilter filter = new SuffixMatchFilter(Arrays.asList(suffs), VisitorAttributes.DEFAULT);
                    List<VirtualFile> matches = child.getChildren(filter);
                    if (matches == null) continue;
                    classPath.addAll(matches);
                    if (trace) {
                        log.trace("Added classpath matches: " + matches);
                    }
                    for (VirtualFile file : matches) {
                        VFSUtils.addManifestLocations(file, classPath);
                        if (classPathHadVF) continue;
                        classPathHadVF = file.equals(root);
                    }
                }
            }
            VirtualFile file = vfsContext.getRoot();
            if (!classPathHadVF && !SecurityActions.isLeaf(file)) {
                VFSUtils.addManifestLocations(file, classPath);
            }
            if (!classPath.isEmpty()) {
                vfsContext.setClassPath(classPath);
            }
        }
    }
}

