/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.MutableLifecycleHolder;
import org.jboss.beans.metadata.spi.AutowireType;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject
public class AbstractBeanMetaData
extends AbstractFeatureMetaData
implements BeanMetaData,
BeanMetaDataFactory,
MutableLifecycleHolder,
Serializable {
    private static final long serialVersionUID = 2L;
    protected String bean;
    protected String name;
    protected Set<Object> aliases;
    protected String parent;
    protected boolean isAbstract;
    protected AutowireType autowireType;
    protected ControllerMode mode;
    protected boolean autowireCandidate = true;
    private Set<PropertyMetaData> properties;
    protected ClassLoaderMetaData classLoader;
    protected ConstructorMetaData constructor;
    protected LifecycleMetaData create;
    protected LifecycleMetaData start;
    protected LifecycleMetaData stop;
    protected LifecycleMetaData destroy;
    protected Set<DemandMetaData> demands;
    protected Set<SupplyMetaData> supplies;
    protected Set<DependencyMetaData> depends;
    protected List<InstallMetaData> installs;
    protected List<InstallMetaData> uninstalls;
    protected List<CallbackMetaData> installCallbacks;
    protected List<CallbackMetaData> uninstallCallbacks;
    protected transient ControllerContext context;

    public AbstractBeanMetaData() {
    }

    public AbstractBeanMetaData(String bean) {
        this.bean = bean;
    }

    public AbstractBeanMetaData(String name, String bean) {
        this.name = name;
        this.bean = bean;
    }

    @Override
    public List<BeanMetaData> getBeans() {
        List<BeanMetaData> nestedBeans = this.findNestedBeans();
        if (nestedBeans.isEmpty()) {
            return Collections.singletonList(this);
        }
        nestedBeans.add(this);
        return nestedBeans;
    }

    protected List<BeanMetaData> findNestedBeans() {
        ArrayList<BeanMetaData> allBeans = new ArrayList<BeanMetaData>();
        this.addBeans(this, allBeans);
        return allBeans;
    }

    protected void addBeans(MetaDataVisitorNode current, List<BeanMetaData> list2) {
        Iterator<? extends MetaDataVisitorNode> children = current.getChildren();
        while (children != null && children.hasNext()) {
            MetaDataVisitorNode next = children.next();
            if (next instanceof BeanMetaDataFactory) {
                list2.addAll(((BeanMetaDataFactory)((Object)next)).getBeans());
                continue;
            }
            this.addBeans(next, list2);
            if (!(next instanceof BeanMetaData)) continue;
            list2.add((BeanMetaData)current);
        }
    }

    @Override
    public String getBean() {
        return this.bean;
    }

    public void setBean(String bean) {
        this.bean = bean;
        this.flushJBossObjectCache();
    }

    public PropertyMetaData getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (PropertyMetaData prop : this.properties) {
                if (!name.equals(prop.getName())) continue;
                return prop;
            }
        }
        return null;
    }

    public void addProperty(PropertyMetaData property) {
        if (property == null) {
            throw new IllegalArgumentException("Null property");
        }
        if (this.properties == null) {
            this.properties = new HashSet<PropertyMetaData>();
        }
        this.properties.add(property);
        this.flushJBossObjectCache();
    }

    public void setProperties(Set<PropertyMetaData> properties) {
        this.properties = properties;
        this.flushJBossObjectCache();
    }

    @Override
    public ClassLoaderMetaData getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoaderMetaData classLoader) {
        this.classLoader = classLoader;
    }

    public void setConstructor(ConstructorMetaData constructor) {
        this.constructor = constructor;
    }

    public void setDemands(Set<DemandMetaData> demands) {
        this.demands = demands;
        this.flushJBossObjectCache();
    }

    public void setSupplies(Set<SupplyMetaData> supplies) {
        this.supplies = supplies;
        this.flushJBossObjectCache();
    }

    public void setDepends(Set<DependencyMetaData> depends) {
        this.depends = depends;
        this.flushJBossObjectCache();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.flushJBossObjectCache();
    }

    @Override
    public Set<Object> getAliases() {
        return this.aliases;
    }

    public void setAliases(Set<Object> aliases) {
        this.aliases = aliases;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    @Override
    public AutowireType getAutowireType() {
        return this.autowireType;
    }

    public void setAutowireType(AutowireType autowireType) {
        this.autowireType = autowireType;
    }

    @Override
    public ControllerMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(ControllerMode mode) {
        this.mode = mode;
        this.flushJBossObjectCache();
    }

    @Override
    public boolean isAutowireCandidate() {
        return this.autowireCandidate;
    }

    public void setAutowireCandidate(boolean autowireCandidate) {
        this.autowireCandidate = autowireCandidate;
    }

    @Override
    public Set<PropertyMetaData> getProperties() {
        return this.properties;
    }

    @Override
    public ConstructorMetaData getConstructor() {
        return this.constructor;
    }

    @Override
    public LifecycleMetaData getCreate() {
        return this.create;
    }

    @Override
    public void setCreate(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.CREATE);
        this.create = lifecycle;
    }

    @Override
    public LifecycleMetaData getStart() {
        return this.start;
    }

    @Override
    public void setStart(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.START);
        this.start = lifecycle;
    }

    @Override
    public LifecycleMetaData getStop() {
        return this.stop;
    }

    @Override
    public void setStop(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.START);
        this.stop = lifecycle;
    }

    @Override
    public LifecycleMetaData getDestroy() {
        return this.destroy;
    }

    @Override
    public void setDestroy(LifecycleMetaData lifecycle) {
        lifecycle.setState(ControllerState.CREATE);
        this.destroy = lifecycle;
    }

    @Override
    public Set<DemandMetaData> getDemands() {
        return this.demands;
    }

    @Override
    public Set<SupplyMetaData> getSupplies() {
        return this.supplies;
    }

    @Override
    public Set<DependencyMetaData> getDepends() {
        return this.depends;
    }

    @Override
    public List<InstallMetaData> getInstalls() {
        return this.installs;
    }

    public void setInstalls(List<InstallMetaData> installs) {
        this.installs = installs;
        this.flushJBossObjectCache();
    }

    @Override
    public List<InstallMetaData> getUninstalls() {
        return this.uninstalls;
    }

    public void setUninstalls(List<InstallMetaData> uninstalls) {
        this.uninstalls = uninstalls;
        this.flushJBossObjectCache();
    }

    @Override
    public List<CallbackMetaData> getInstallCallbacks() {
        return this.installCallbacks;
    }

    public void setInstallCallbacks(List<CallbackMetaData> installCallbacks) {
        this.installCallbacks = installCallbacks;
        this.flushJBossObjectCache();
    }

    @Override
    public List<CallbackMetaData> getUninstallCallbacks() {
        return this.uninstallCallbacks;
    }

    public void setUninstallCallbacks(List<CallbackMetaData> uninstallCallbacks) {
        this.uninstallCallbacks = uninstallCallbacks;
        this.flushJBossObjectCache();
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        boolean isInnerBean;
        KernelControllerContext ctx = visitor.getControllerContext();
        if (ctx.getBeanMetaData() == this) {
            this.context = ctx;
        }
        boolean bl = isInnerBean = !visitor.visitorNodeStack().isEmpty();
        if (isInnerBean) {
            Object name = ctx.getName();
            Object iDependOn = this.getUnderlyingValue();
            ControllerState whenRequired = visitor.getContextState();
            AbstractDependencyItem di = new AbstractDependencyItem(name, iDependOn, whenRequired, ControllerState.INSTALLED);
            visitor.addDependency(di);
        }
        super.initialVisit(visitor);
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.classLoader != null && this.classLoader.getClassLoader() != this) {
            children.add(this.classLoader);
        }
        if (this.constructor != null) {
            children.add(this.constructor);
        }
        if (this.properties != null) {
            children.addAll(this.properties);
        }
        if (this.create != null) {
            children.add(this.create);
        }
        if (this.start != null) {
            children.add(this.start);
        }
        if (this.stop != null) {
            children.add(this.stop);
        }
        if (this.destroy != null) {
            children.add(this.destroy);
        }
        if (this.demands != null) {
            children.addAll(this.demands);
        }
        if (this.supplies != null) {
            children.addAll(this.supplies);
        }
        if (this.depends != null) {
            children.addAll(this.depends);
        }
        if (this.installs != null) {
            children.addAll(this.installs);
        }
        if (this.uninstalls != null) {
            children.addAll(this.uninstalls);
        }
        if (this.installCallbacks != null) {
            children.addAll(this.installCallbacks);
        }
        if (this.uninstallCallbacks != null) {
            children.addAll(this.uninstallCallbacks);
        }
    }

    @Override
    public TypeInfo getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        throw new IllegalArgumentException("Cannot determine inject class type: " + this);
    }

    @Override
    public Object getUnderlyingValue() {
        return this.name;
    }

    @Override
    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        Controller controller = this.context.getController();
        ControllerContext lookup = controller.getInstalledContext(this.name);
        if (lookup == null || lookup.getTarget() == null) {
            if (info == null && this.classLoader != null && this.classLoader.getClassLoader() == this) {
                return cl;
            }
            throw new IllegalArgumentException("Bean not yet installed: " + this.name);
        }
        Object target = lookup.getTarget();
        if (info != null && !info.getType().isAssignableFrom(target.getClass())) {
            throw new ClassCastException(target + " is not a " + info);
        }
        return target;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.name);
        if (this.aliases != null) {
            buffer.append(" aliases=").append(this.aliases);
        }
        buffer.append(" bean=").append(this.bean);
        buffer.append(" properties=");
        JBossObject.list(buffer, this.properties);
        if (this.classLoader != null && this.classLoader.getClassLoader() != this) {
            buffer.append(" classLoader=").append(this.classLoader);
        }
        buffer.append(" constructor=").append(this.constructor);
        buffer.append(" autowireCandidate=").append(this.autowireCandidate);
        if (this.create != null) {
            buffer.append(" create=").append(this.create);
        }
        if (this.start != null) {
            buffer.append(" start=").append(this.start);
        }
        if (this.stop != null) {
            buffer.append(" stop=").append(this.stop);
        }
        if (this.destroy != null) {
            buffer.append(" destroy=").append(this.destroy);
        }
        if (this.demands != null) {
            buffer.append(" demands=");
            JBossObject.list(buffer, this.demands);
        }
        super.toString(buffer);
        if (this.supplies != null) {
            buffer.append(" supplies=");
            JBossObject.list(buffer, this.supplies);
        }
        if (this.depends != null) {
            buffer.append(" depends=");
            JBossObject.list(buffer, this.depends);
        }
        if (this.installs != null) {
            buffer.append(" installs=");
            JBossObject.list(buffer, this.installs);
        }
        if (this.uninstalls != null) {
            buffer.append(" uninstalls=");
            JBossObject.list(buffer, this.uninstalls);
        }
        if (this.installCallbacks != null) {
            buffer.append(" installCallbacks=");
            JBossObject.list(buffer, this.installCallbacks);
        }
        if (this.uninstallCallbacks != null) {
            buffer.append(" uninstallCallbacks=");
            JBossObject.list(buffer, this.uninstallCallbacks);
        }
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.bean);
        buffer.append('/');
        buffer.append(this.name);
    }
}

