/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.annotation.AnnotationElement;
import org.jboss.aop.pointcut.AdvisorMatcherStrategy;
import org.jboss.aop.pointcut.ProxyMatcherStrategy;
import org.jboss.aop.pointcut.SecurityActions;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.util.logging.AOPLogger;
import org.jboss.logging.Logger;

public abstract class MatcherStrategy {
    private static final Logger logger = AOPLogger.getLogger(MatcherStrategy.class);
    private static final MatcherStrategy ADVISOR_MATCHER_STRATEGY = new AdvisorMatcherStrategy();
    private static final MatcherStrategy PROXY_MATCHER_STRATEGY = new ProxyMatcherStrategy();

    public static MatcherStrategy getMatcher(Advisor advisor) {
        if (advisor instanceof ClassProxyContainer) {
            return PROXY_MATCHER_STRATEGY;
        }
        return ADVISOR_MATCHER_STRATEGY;
    }

    public boolean subtypeOf(Class clazz, ClassExpression instanceOf, Advisor advisor) {
        block10: {
            if (clazz == null) {
                return false;
            }
            if (instanceOf.isInstanceOfAnnotated()) {
                String sub = instanceOf.getInstanceOfAnnotation().substring(1);
                try {
                    Class<?> annotation = SecurityActions.getContextClassLoader().loadClass(sub);
                    if (AnnotationElement.getAnyAnnotation(clazz, annotation) != null) {
                        return true;
                    }
                    break block10;
                }
                catch (ClassNotFoundException e) {
                    if (AspectManager.verbose) {
                        logger.warn("The annotation @" + sub + " referenced in one of your pointcut expressions can not be found");
                    }
                    return false;
                }
            }
            if (instanceOf.matches(clazz.getName())) {
                return true;
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.subtypeOf(interfaces[i], instanceOf, advisor)) continue;
            return true;
        }
        if (clazz.isInterface()) {
            return false;
        }
        if (this.checkIntroductions(clazz, instanceOf, advisor)) {
            return true;
        }
        return this.subtypeOf(clazz.getSuperclass(), instanceOf, advisor);
    }

    protected abstract boolean checkIntroductions(Class var1, ClassExpression var2, Advisor var3);

    public abstract Class getDeclaringClass(Advisor var1, Method var2);
}

