/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.instrument.GeneratedAdvisorInstrumentor;
import org.jboss.aop.instrument.Instrumentor;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.MethodJoinPointGenerator;
import org.jboss.aop.util.JavassistMethodHashing;

public class GeneratedAdvisorMethodExecutionTransformer
extends MethodExecutionTransformer {
    public GeneratedAdvisorMethodExecutionTransformer(GeneratedAdvisorInstrumentor instrumentor) {
        super(instrumentor);
    }

    private String addMethodInfoFieldToGenAdvisor(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException, CannotCompileException {
        GeneratedAdvisorInstrumentor instrumentor = (GeneratedAdvisorInstrumentor)trans.getInstrumentor();
        CtClass genadvisor = instrumentor.getGenadvisor();
        String miname = this.addMethodInfoField(4, genadvisor, trans);
        this.addJoinpoint(miname, trans);
        instrumentor.initaliseMethodInfo(miname, trans.getHash(), JavassistMethodHashing.methodHash(trans.getMethod()));
        return miname;
    }

    protected boolean addInfoAsWeakReference() {
        return false;
    }

    public static String getJoinPointFieldName(MethodExecutionTransformer.MethodTransformation trans) {
        return MethodJoinPointGenerator.getGeneratedJoinPointFieldName(trans.getOriginalName(), trans.getHash());
    }

    private void addJoinpoint(String miname, MethodExecutionTransformer.MethodTransformation trans) throws CannotCompileException, NotFoundException {
        CtClass joinpoint = this.createJoinpointClass(miname, trans);
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)trans.getInstrumentor()).getGenadvisor();
        CtField field = new CtField(joinpoint, GeneratedAdvisorMethodExecutionTransformer.getJoinPointFieldName(trans), genadvisor);
        field.setModifiers(4);
        genadvisor.addField(field);
    }

    private CtClass createJoinpointClass(String miname, MethodExecutionTransformer.MethodTransformation trans) throws CannotCompileException, NotFoundException {
        return MethodJoinPointGenerator.createJoinpointBaseClass((GeneratedAdvisorInstrumentor)trans.getInstrumentor(), trans.getClazz(), trans.getMethod(), trans.getWMethod(), miname, trans.getOriginalName(), trans.getWrappedName(), trans.getHash());
    }

    public CtMethod addMixinWrappersAndInfo(GeneratedAdvisorInstrumentor instrumentor, CtClass clazz, CtClass mixinClass, String initializer, CtClass genadvisor, CtMethod mixinMethod) throws CannotCompileException, NotFoundException {
        String originalName = mixinMethod.getName();
        String originalBody = "{   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(mixinMethod) + " " + Instrumentor.mixinFieldName(mixinClass) + "." + mixinMethod.getName() + "($$);" + "}";
        CtMethod original = CtNewMethod.make((int)1, (CtClass)mixinMethod.getReturnType(), (String)mixinMethod.getName(), (CtClass[])mixinMethod.getParameterTypes(), (CtClass[])mixinMethod.getExceptionTypes(), (String)originalBody, (CtClass)clazz);
        clazz.addMethod(original);
        long hash = JavassistMethodHashing.methodHash(original);
        this.moveAnnotationsAndCopySignature(mixinMethod, original);
        String wrappedName = ClassAdvisor.notAdvisedMethodName(clazz.getName(), originalName);
        CtMethod wmethod = CtNewMethod.copy((CtMethod)original, (CtClass)clazz, null);
        wmethod.setName(wrappedName);
        clazz.addMethod(wmethod);
        this.moveAnnotationsAndCopySignature(original, wmethod);
        original.setName(wrappedName);
        wmethod.setName(originalName);
        MethodExecutionTransformer.MethodTransformation trans = new MethodExecutionTransformer.MethodTransformation(this, instrumentor, clazz, original, originalName, wmethod, wrappedName, hash);
        String methodInfoField = this.addMethodInfoFieldToGenAdvisor(trans);
        this.addMethodToGeneratedAdvisor(trans, methodInfoField);
        String wrapperBody = "{   if (" + Instrumentor.mixinFieldName(mixinClass) + " == null)" + "   {" + "      " + Instrumentor.mixinFieldName(mixinClass) + " = " + initializer + ";" + "   }" + "   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getMethod()) + " ((" + GeneratedAdvisorInstrumentor.getAdvisorFQN(trans.getClazz()) + ")" + "getCurrentAdvisor$aop()" + ")." + this.getAdvisorMethodName(trans) + "(this,$$);" + "}";
        wmethod.setBody(wrapperBody);
        return wmethod;
    }

    protected void transformMethod(MethodExecutionTransformer.MethodTransformation trans, boolean wrap) throws CannotCompileException, NotFoundException {
        String wrappedName = ClassAdvisor.notAdvisedMethodName(trans.getClazzName(), trans.getMethod().getName());
        CtMethod wmethod = CtNewMethod.copy((CtMethod)trans.getMethod(), (CtClass)trans.getClazz(), null);
        String originalName = trans.getOriginalName();
        wmethod.setName(wrappedName);
        trans.getClazz().addMethod(wmethod);
        this.moveAnnotationsAndCopySignature(trans.getMethod(), wmethod);
        trans.getMethod().setName(wrappedName);
        wmethod.setName(originalName);
        trans.setWMethod(wmethod, wrappedName);
        String methodInfoField = this.addMethodInfoFieldToGenAdvisor(trans);
        this.addMethodToGeneratedAdvisor(trans, methodInfoField);
        GeneratedAdvisorMethodExecutionTransformer.getWrapper().prepareForWrapping((CtMember)wmethod, 0);
        if (wrap) {
            GeneratedAdvisorMethodExecutionTransformer.getWrapper().wrap((CtMember)wmethod, 0);
            this.setWrapperBody(trans, methodInfoField);
        }
    }

    protected void doWrap(MethodExecutionTransformer.MethodTransformation trans, String methodInfoFieldName) throws NotFoundException, Exception {
    }

    private void setWrapperBody(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField) throws NotFoundException {
        String code = null;
        String className = GeneratedAdvisorInstrumentor.getAdvisorFQN(trans.getClazz());
        try {
            if (Modifier.isStatic((int)trans.getMethod().getModifiers())) {
                code = "{   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getMethod()) + " ((" + className + ")" + "aop$classAdvisor$aop" + ")." + this.getAdvisorMethodName(trans) + "($$);" + "}";
                trans.setWMethodBody(code);
            } else {
                code = "{   " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getMethod()) + " ((" + className + ")" + "getCurrentAdvisor$aop()" + ")." + this.getAdvisorMethodName(trans) + "(this,$$);" + "}";
                trans.setWMethodBody(code);
            }
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            throw new RuntimeException("code was: " + code + " for method " + trans.getOriginalName());
        }
    }

    protected static CtClass[] addTargetToParamsForNonStaticMethod(CtClass outer, CtMethod method) throws NotFoundException {
        CtClass[] params = method.getParameterTypes();
        if (!Modifier.isStatic((int)method.getModifiers())) {
            CtClass[] tempParams = params;
            params = new CtClass[params.length + 1];
            params[0] = outer;
            System.arraycopy(tempParams, 0, params, 1, tempParams.length);
        }
        return params;
    }

    private String getAdvisorMethodName(MethodExecutionTransformer.MethodTransformation trans) {
        if (trans.getHash() >= 0L) {
            return trans.getOriginalName() + trans.getHash();
        }
        return trans.getOriginalName() + "_N_" + Math.abs(trans.getHash());
    }

    private void addMethodToGeneratedAdvisor(MethodExecutionTransformer.MethodTransformation trans, String methodInfoField) throws CannotCompileException, NotFoundException {
        CtClass genadvisor = ((GeneratedAdvisorInstrumentor)trans.getInstrumentor()).getGenadvisor();
        CtClass[] params = GeneratedAdvisorMethodExecutionTransformer.addTargetToParamsForNonStaticMethod(trans.getClazz(), trans.getWMethod());
        String code = this.createAdvisorMethodBody(trans);
        try {
            CtMethod advisorMethod = CtNewMethod.make((int)4, (CtClass)trans.getWMethod().getReturnType(), (String)this.getAdvisorMethodName(trans), (CtClass[])params, (CtClass[])trans.getWMethod().getExceptionTypes(), (String)code, (CtClass)genadvisor);
            genadvisor.addMethod(advisorMethod);
            advisorMethod.setModifiers(Modifier.setProtected((int)advisorMethod.getModifiers()));
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("code was: " + code + " for method " + this.getAdvisorMethodName(trans), e);
        }
    }

    private String createAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException {
        if (Modifier.isStatic((int)trans.getWMethod().getModifiers())) {
            return this.createStaticAdvisorMethodBody(trans);
        }
        return this.createNonStaticAdvisorMethodBody(trans);
    }

    private String createStaticAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException {
        String joinpointName = GeneratedAdvisorMethodExecutionTransformer.getJoinPointFieldName(trans);
        String infoName = GeneratedAdvisorMethodExecutionTransformer.getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
        String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "       super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      " + GeneratedAdvisorMethodExecutionTransformer.getReturnStr(trans.getWMethod()) + trans.getClazzName() + "." + trans.getWrappedName() + "($$);" + "   }" + "   else" + "   {" + "    " + GeneratedAdvisorMethodExecutionTransformer.getAopReturnStr(trans.getWMethod()) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
        return code;
    }

    private String createNonStaticAdvisorMethodBody(MethodExecutionTransformer.MethodTransformation trans) throws NotFoundException {
        String joinpointName = GeneratedAdvisorMethodExecutionTransformer.getJoinPointFieldName(trans);
        String infoName = GeneratedAdvisorMethodExecutionTransformer.getMethodInfoFieldName(trans.getOriginalName(), trans.getHash());
        String code = "{   if (" + joinpointName + " == null && " + infoName + " != null && " + infoName + ".hasAdvices())" + "   {" + "       super." + "generateJoinPointClass" + "(" + infoName + ");" + "   }" + "   if (" + joinpointName + " == null)" + "   { " + "      " + GeneratedAdvisorMethodExecutionTransformer.getAopReturnStr(trans.getWMethod()) + "$1." + trans.getWrappedName() + "(" + GeneratedAdvisorMethodExecutionTransformer.getNonStaticJavasistParamString(trans.getWMethod().getParameterTypes().length) + ");" + "   }" + "   else" + "   {" + "    " + GeneratedAdvisorMethodExecutionTransformer.getAopReturnStr(trans.getWMethod()) + joinpointName + "." + "invokeJoinpoint" + "($$);" + "   }" + "}";
        return code;
    }

    public static String getNonStaticJavasistParamString(long parameterLength) throws NotFoundException {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while ((long)i < parameterLength) {
            if (i > 0) {
                str.append(", ");
            }
            str.append("$" + (i + 2));
            ++i;
        }
        return str.toString();
    }
}

