/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jta.jca;

import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxImporter;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.TxWorkManager;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.WorkSynchronization;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.XATerminatorImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca.TransactionImple;
import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
import com.arjuna.ats.jta.TransactionManager;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.JBossXATerminator;
import org.jboss.util.UnexpectedThrowable;

public class XATerminator
extends XATerminatorImple
implements JBossXATerminator {
    public void registerWork(Work work, Xid xid, long timeout) throws WorkCompletedException {
        try {
            TransactionImple tx = TxImporter.importTransaction(xid, (int)timeout);
            switch (tx.getStatus()) {
                case 5: 
                case 6: {
                    throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.inactive"), "3");
                }
                case 0: {
                    break;
                }
                default: {
                    throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.completing"), "2");
                }
            }
            TxWorkManager.addWork(work, tx);
            tx.registerSynchronization(new WorkSynchronization(tx));
        }
        catch (WorkCompletedException ex) {
            throw ex;
        }
        catch (XAException ex) {
            throw new WorkCompletedException(ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.unknown"), "-1");
        }
    }

    public void startWork(Work work, Xid xid) throws WorkCompletedException {
        try {
            TransactionImple tx = TxImporter.importTransaction(xid);
            if (!TxWorkManager.getWork(tx).equals(work)) {
                throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.unknownwork"), "-1");
            }
            TransactionManager.transactionManager().resume(tx);
        }
        catch (XAException ex) {
            throw new WorkCompletedException(ex);
        }
        catch (InvalidTransactionException ex) {
            throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.inactive"), "3");
        }
        catch (SystemException ex) {
            throw new WorkCompletedException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.jca.unknown"), "-1");
        }
    }

    public void endWork(Work work, Xid xid) {
        try {
            TransactionImple tx = TxImporter.importTransaction(xid);
            TransactionManager.transactionManager().suspend();
            TxWorkManager.removeWork(work, tx);
        }
        catch (Exception ex) {
            throw new UnexpectedThrowable(ex);
        }
    }

    public void cancelWork(Work work, Xid xid) {
        try {
            TransactionImple tx = TxImporter.importTransaction(xid);
            TxWorkManager.removeWork(work, tx);
        }
        catch (Exception ex) {
            throw new UnexpectedThrowable(ex);
        }
    }
}

