/*     */ package org.jnp.server;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.RefAddr;
/*     */ import javax.naming.Reference;
/*     */ import javax.naming.StringRefAddr;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.naming.ENCFactory;
/*     */ import org.jnp.interfaces.Naming;
/*     */ import org.jnp.interfaces.NamingContext;
/*     */ 
/*     */ public class NamingBeanImpl
/*     */   implements NamingBean
/*     */ {
/*  48 */   private static Logger log = Logger.getLogger(NamingBeanImpl.class);
/*     */   protected Naming theServer;
/*  53 */   protected boolean InstallGlobalService = true;
/*     */ 
/*  55 */   protected boolean UseGlobalService = true;
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  61 */     new Main().start();
/*     */   }
/*     */ 
/*     */   public Naming getNamingInstance()
/*     */   {
/*  72 */     return this.theServer;
/*     */   }
/*     */ 
/*     */   public boolean getInstallGlobalService()
/*     */   {
/*  77 */     return this.InstallGlobalService;
/*     */   }
/*     */ 
/*     */   public void setInstallGlobalService(boolean flag) {
/*  81 */     this.InstallGlobalService = flag;
/*     */   }
/*     */ 
/*     */   public boolean getUseGlobalService() {
/*  85 */     return this.UseGlobalService;
/*     */   }
/*     */ 
/*     */   public void setUseGlobalService(boolean flag) {
/*  89 */     this.UseGlobalService = flag;
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*  96 */     if (this.theServer == null)
/*     */     {
/*  99 */       if (this.UseGlobalService == true) {
/* 100 */         this.theServer = NamingContext.localServer;
/*     */       }
/* 102 */       if (this.theServer == null) {
/* 103 */         this.theServer = new NamingServer();
/*     */       }
/*     */       else
/*     */       {
/* 107 */         NamingServerWrapper wrapper = new NamingServerWrapper(this.theServer);
/* 108 */         this.theServer = wrapper;
/*     */       }
/* 110 */       log.debug("Using NamingServer: " + this.theServer);
/* 111 */       if (this.InstallGlobalService == true)
/*     */       {
/* 114 */         NamingContext.setLocal(this.theServer);
/* 115 */         log.debug("Installed global NamingServer: " + this.theServer);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 123 */     InitialContext iniCtx = new InitialContext();
/* 124 */     Hashtable env = iniCtx.getEnvironment();
/* 125 */     log.debug("InitialContext Environment: ");
/* 126 */     Object providerURL = null;
/* 127 */     for (Enumeration keys = env.keys(); keys.hasMoreElements(); )
/*     */     {
/* 129 */       Object key = keys.nextElement();
/* 130 */       Object value = env.get(key);
/* 131 */       String type = value == null ? "" : value.getClass().getName();
/* 132 */       log.debug("key=" + key + ", value(" + type + ")=" + value);
/* 133 */       if (key.equals("java.naming.provider.url")) {
/* 134 */         providerURL = value;
/*     */       }
/*     */     }
/* 137 */     if (providerURL != null) {
/* 138 */       log.warn("Context.PROVIDER_URL in server jndi.properties, url=" + providerURL);
/*     */     }
/*     */ 
/* 144 */     ClassLoader topLoader = Thread.currentThread().getContextClassLoader();
/* 145 */     ENCFactory.setTopClassLoader(topLoader);
/* 146 */     RefAddr refAddr = new StringRefAddr("nns", "ENC");
/* 147 */     Reference envRef = new Reference("javax.namingMain.Context", refAddr, ENCFactory.class.getName(), null);
/* 148 */     Context ctx = (Context)iniCtx.lookup("java:");
/* 149 */     ctx.rebind("comp", envRef);
/* 150 */     ctx.close();
/* 151 */     iniCtx.close();
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.server.NamingBeanImpl
 * JD-Core Version:    0.6.0
 */