/*    */ package org.jnp.interfaces;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import javax.naming.CompoundName;
/*    */ import javax.naming.Context;
/*    */ import javax.naming.Name;
/*    */ import javax.naming.NamingException;
/*    */ import javax.naming.RefAddr;
/*    */ import javax.naming.Reference;
/*    */ import javax.naming.spi.InitialContextFactory;
/*    */ import javax.naming.spi.ObjectFactory;
/*    */ 
/*    */ public class NamingContextFactory
/*    */   implements InitialContextFactory, ObjectFactory
/*    */ {
/*    */   public Context getInitialContext(Hashtable env)
/*    */     throws NamingException
/*    */   {
/* 46 */     String providerURL = (String)env.get("java.naming.provider.url");
/* 47 */     Name prefix = null;
/*    */ 
/* 51 */     int comma = providerURL != null ? providerURL.indexOf(',') : -1;
/* 52 */     if ((providerURL != null) && (comma < 0))
/*    */     {
/* 54 */       Name name = new CompoundName(providerURL, NamingParser.syntax);
/* 55 */       String serverInfo = NamingContext.parseNameForScheme(name, env);
/* 56 */       if (serverInfo != null)
/*    */       {
/* 58 */         env = (Hashtable)env.clone();
/*    */ 
/* 60 */         env.put("java.naming.provider.url", serverInfo);
/*    */ 
/* 62 */         Name parsedName = (Name)env.get("jnp.parsedName");
/* 63 */         if (parsedName != null)
/* 64 */           prefix = parsedName;
/*    */         else
/* 66 */           prefix = name;
/*    */       }
/*    */     }
/* 69 */     return new NamingContext(env, prefix, null);
/*    */   }
/*    */ 
/*    */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*    */     throws Exception
/*    */   {
/* 80 */     Context ctx = getInitialContext(environment);
/* 81 */     Reference ref = (Reference)obj;
/* 82 */     return ctx.lookup((String)ref.get("URL").getContent());
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jnp.interfaces.NamingContextFactory
 * JD-Core Version:    0.6.0
 */