/*     */ package org.jboss.xb.spi;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
/*     */ 
/*     */ public abstract class BeanAdapterFactory
/*     */ {
/*     */   private Map<QName, AbstractPropertyHandler> properties;
/*     */   private AbstractPropertyHandler wildcardHandler;
/*     */ 
/*     */   public AbstractPropertyHandler getPropertyHandler(QName qName)
/*     */   {
/*  53 */     if (this.properties == null)
/*  54 */       return null;
/*  55 */     return (AbstractPropertyHandler)this.properties.get(qName);
/*     */   }
/*     */ 
/*     */   public Map<QName, AbstractPropertyHandler> getProperties()
/*     */   {
/*  65 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void addProperty(QName qName, AbstractPropertyHandler propertyHandler)
/*     */   {
/*  76 */     if (qName == null)
/*  77 */       throw new IllegalArgumentException("Null qName");
/*  78 */     if (propertyHandler == null) {
/*  79 */       throw new IllegalArgumentException("Null property handler");
/*     */     }
/*  81 */     if (this.properties == null)
/*  82 */       this.properties = new HashMap();
/*  83 */     this.properties.put(qName, propertyHandler);
/*     */   }
/*     */ 
/*     */   public String getAvailable()
/*     */   {
/*  92 */     if (this.properties == null) {
/*  93 */       return "<nothing>";
/*     */     }
/*  95 */     return this.properties.keySet().toString();
/*     */   }
/*     */ 
/*     */   public AbstractPropertyHandler getWildcardHandler()
/*     */   {
/* 105 */     return this.wildcardHandler;
/*     */   }
/*     */ 
/*     */   public void setWildcardHandler(AbstractPropertyHandler wildcardHandler)
/*     */   {
/* 115 */     this.wildcardHandler = wildcardHandler;
/*     */   }
/*     */ 
/*     */   public abstract BeanAdapter newInstance();
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.spi.BeanAdapterFactory
 * JD-Core Version:    0.6.0
 */