/*    */ package org.jboss.xb.binding.sunday.unmarshalling;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*    */ import org.w3c.dom.DOMError;
/*    */ import org.w3c.dom.DOMErrorHandler;
/*    */ import org.w3c.dom.DOMLocator;
/*    */ 
/*    */ public class XsdBinderTerminatingErrorHandler
/*    */   implements DOMErrorHandler
/*    */ {
/*    */   private static XsdBinderTerminatingErrorHandler errorHandler;
/*    */ 
/*    */   public static XsdBinderTerminatingErrorHandler newInstance()
/*    */   {
/* 22 */     if (errorHandler == null)
/*    */     {
/* 24 */       errorHandler = new XsdBinderTerminatingErrorHandler();
/*    */     }
/* 26 */     return errorHandler;
/*    */   }
/*    */ 
/*    */   public boolean handleError(DOMError error)
/*    */   {
/* 35 */     switch (error.getSeverity())
/*    */     {
/*    */     case 2:
/* 38 */       throw new JBossXBRuntimeException(formatMessage(error));
/*    */     case 3:
/* 40 */       throw new JBossXBRuntimeException(formatMessage(error));
/*    */     case 1:
/* 42 */       XsdBinder.log.warn(formatMessage(error));
/*    */     }
/*    */ 
/* 45 */     return false;
/*    */   }
/*    */ 
/*    */   String formatMessage(DOMError error)
/*    */   {
/* 50 */     StringBuffer buf = new StringBuffer();
/* 51 */     DOMLocator location = error.getLocation();
/* 52 */     if (location != null)
/*    */     {
/* 54 */       buf.append(location.getLineNumber()).append(':').append(location.getColumnNumber());
/*    */     }
/*    */     else
/*    */     {
/* 60 */       buf.append("[location unavailable]");
/*    */     }
/*    */ 
/* 63 */     buf.append(' ').append(error.getMessage());
/* 64 */     return buf.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.XsdBinderTerminatingErrorHandler
 * JD-Core Version:    0.6.0
 */