/*    */ package org.jboss.xb.binding.sunday.unmarshalling;
/*    */ 
/*    */ import org.jboss.logging.Logger;
/*    */ import org.w3c.dom.DOMError;
/*    */ import org.w3c.dom.DOMErrorHandler;
/*    */ import org.w3c.dom.DOMLocator;
/*    */ 
/*    */ public class XsdBinderLoggingErrorHandler
/*    */   implements DOMErrorHandler
/*    */ {
/*    */   private static XsdBinderLoggingErrorHandler errorHandler;
/*    */ 
/*    */   public static XsdBinderLoggingErrorHandler newInstance()
/*    */   {
/* 21 */     if (errorHandler == null)
/*    */     {
/* 23 */       errorHandler = new XsdBinderLoggingErrorHandler();
/*    */     }
/* 25 */     return errorHandler;
/*    */   }
/*    */ 
/*    */   public boolean handleError(DOMError error)
/*    */   {
/* 34 */     switch (error.getSeverity())
/*    */     {
/*    */     case 2:
/* 37 */       XsdBinder.log.error(formatMessage(error));
/*    */     case 3:
/* 39 */       XsdBinder.log.fatal(formatMessage(error));
/*    */     case 1:
/* 41 */       XsdBinder.log.warn(formatMessage(error));
/*    */     }
/*    */ 
/* 44 */     return false;
/*    */   }
/*    */ 
/*    */   String formatMessage(DOMError error)
/*    */   {
/* 49 */     StringBuffer buf = new StringBuffer();
/* 50 */     DOMLocator location = error.getLocation();
/* 51 */     if (location != null)
/*    */     {
/* 53 */       buf.append(location.getLineNumber()).append(':').append(location.getColumnNumber());
/*    */     }
/*    */     else
/*    */     {
/* 57 */       buf.append("[location unavailable]");
/*    */     }
/*    */ 
/* 60 */     buf.append(' ').append(error.getMessage());
/* 61 */     return buf.toString();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.XsdBinderLoggingErrorHandler
 * JD-Core Version:    0.6.0
 */