/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public abstract class ModelGroupBinding extends TermBinding
/*     */   implements Cloneable
/*     */ {
/*  45 */   protected final Logger log = Logger.getLogger(getClass());
/*     */   protected QName qName;
/*     */   protected boolean requiredParticle;
/*  51 */   protected ParticleHandler handler = DefaultHandlers.MODEL_GROUP_HANDLER;
/*     */ 
/*     */   protected ModelGroupBinding(SchemaBinding schema)
/*     */   {
/*  55 */     super(schema);
/*     */   }
/*     */ 
/*     */   public QName getQName()
/*     */   {
/*  65 */     return this.qName;
/*     */   }
/*     */ 
/*     */   public void setQName(QName name)
/*     */   {
/*  76 */     if (name == null)
/*  77 */       throw new IllegalArgumentException("Null name");
/*  78 */     this.qName = name;
/*     */   }
/*     */ 
/*     */   public ParticleHandler getHandler()
/*     */   {
/*  83 */     return this.handler;
/*     */   }
/*     */ 
/*     */   public void setHandler(ParticleHandler handler)
/*     */   {
/*  88 */     this.handler = handler;
/*     */   }
/*     */ 
/*     */   public abstract ElementBinding getArrayItem();
/*     */ 
/*     */   public void addParticle(ParticleBinding particle)
/*     */   {
/* 100 */     if (particle.isRequired())
/*     */     {
/* 102 */       this.requiredParticle = true;
/*     */     }
/*     */   }
/*     */ 
/*     */   public abstract Collection getParticles();
/*     */ 
/*     */   public boolean hasRequiredParticle() {
/* 110 */     return this.requiredParticle;
/*     */   }
/*     */ 
/*     */   public boolean mayStartWith(QName qName)
/*     */   {
/* 121 */     return mayStartWith(qName, Collections.EMPTY_SET);
/*     */   }
/*     */ 
/*     */   public abstract Cursor newCursor(ParticleBinding paramParticleBinding);
/*     */ 
/*     */   public Object clone() throws CloneNotSupportedException {
/* 128 */     return super.clone();
/*     */   }
/*     */ 
/*     */   protected abstract boolean mayStartWith(QName paramQName, Set paramSet);
/*     */ 
/*     */   public boolean isSkip()
/*     */   {
/* 137 */     return this.skip == null ? true : this.skip.booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean isModelGroup()
/*     */   {
/* 142 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isWildcard()
/*     */   {
/* 147 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isElement()
/*     */   {
/* 152 */     return false;
/*     */   }
/*     */ 
/*     */   public abstract class Cursor
/*     */   {
/*     */     protected final ParticleBinding particle;
/* 160 */     protected final boolean trace = ModelGroupBinding.this.log.isTraceEnabled();
/*     */ 
/*     */     protected Cursor(ParticleBinding particle)
/*     */     {
/* 164 */       this.particle = particle;
/*     */     }
/*     */ 
/*     */     public ParticleBinding getParticle()
/*     */     {
/* 169 */       return this.particle;
/*     */     }
/*     */ 
/*     */     public ModelGroupBinding getModelGroup()
/*     */     {
/* 174 */       return (ModelGroupBinding)this.particle.getTerm();
/*     */     }
/*     */     public abstract ParticleBinding getCurrentParticle();
/*     */ 
/*     */     public abstract ElementBinding getElement();
/*     */ 
/*     */     public abstract boolean isPositioned();
/*     */ 
/* 185 */     public List startElement(QName qName, Attributes attrs) { return startElement(qName, attrs, Collections.EMPTY_SET, Collections.EMPTY_LIST, true);
/*     */     }
/*     */ 
/*     */     public ElementBinding getElement(QName qName, Attributes attrs, boolean ignoreWildcards)
/*     */     {
/* 190 */       return getElement(qName, attrs, Collections.EMPTY_SET, ignoreWildcards);
/*     */     }
/*     */ 
/*     */     public abstract void endElement(QName paramQName);
/*     */ 
/*     */     public abstract int getOccurence();
/*     */ 
/*     */     public abstract boolean isWildcardContent();
/*     */ 
/*     */     protected abstract List startElement(QName paramQName, Attributes paramAttributes, Set paramSet, List paramList, boolean paramBoolean);
/*     */ 
/*     */     protected abstract ElementBinding getElement(QName paramQName, Attributes paramAttributes, Set paramSet, boolean paramBoolean);
/*     */ 
/*     */     protected ElementBinding getElement(List group, QName qName, Attributes atts, Set passedGroups, boolean ignoreWildcards)
/*     */     {
/* 211 */       ElementBinding element = null;
/* 212 */       for (int i = 0; i < group.size(); i++)
/*     */       {
/* 214 */         ParticleBinding nextParticle = (ParticleBinding)group.get(i);
/* 215 */         TermBinding item = nextParticle.getTerm();
/* 216 */         if (item.isElement())
/*     */         {
/* 218 */           ElementBinding choice = (ElementBinding)item;
/* 219 */           if (qName.equals(choice.getQName()))
/*     */           {
/* 221 */             element = choice;
/* 222 */             break;
/*     */           }
/*     */         }
/* 225 */         else if (item.isModelGroup())
/*     */         {
/* 227 */           ModelGroupBinding modelGroup = (ModelGroupBinding)item;
/* 228 */           if (!passedGroups.contains(modelGroup))
/*     */           {
/* 230 */             switch (passedGroups.size())
/*     */             {
/*     */             case 0:
/* 233 */               passedGroups = Collections.singleton(this);
/* 234 */               break;
/*     */             case 1:
/* 236 */               passedGroups = new HashSet(passedGroups);
/*     */             default:
/* 238 */               passedGroups.add(this);
/*     */             }
/*     */ 
/* 241 */             ElementBinding e = modelGroup.newCursor(nextParticle).getElement(qName, atts, passedGroups, ignoreWildcards);
/* 242 */             if (e != null)
/*     */             {
/* 244 */               element = e;
/* 245 */               if (qName.equals(e.getQName()))
/*     */                 break;
/* 247 */               throw new JBossXBRuntimeException("There is a bug in ModelGroupBinding.Cursor.getElement(QName,Attributes) impl");
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 255 */           if (ignoreWildcards)
/*     */             continue;
/* 257 */           WildcardBinding wildcard = (WildcardBinding)item;
/* 258 */           ElementBinding e = wildcard.getElement(qName, atts);
/* 259 */           if (e == null)
/*     */             continue;
/* 261 */           element = e;
/* 262 */           if (qName.equals(e.getQName()))
/*     */             break;
/* 264 */           throw new JBossXBRuntimeException("There is a bug in ModelGroupBinding.Cursor.getElement(QName,Attributes) impl");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 272 */       return element;
/*     */     }
/*     */ 
/*     */     protected List addItem(List list, Object o)
/*     */     {
/* 277 */       switch (list.size())
/*     */       {
/*     */       case 0:
/* 280 */         list = Collections.singletonList(o);
/* 281 */         break;
/*     */       case 1:
/* 283 */         list = new ArrayList(list);
/*     */       default:
/* 285 */         list.add(o);
/*     */       }
/* 287 */       return list;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding
 * JD-Core Version:    0.6.0
 */