/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.metadata.AddMethodMetaData;
/*     */ import org.jboss.xb.binding.metadata.ClassMetaData;
/*     */ import org.jboss.xb.binding.metadata.MapEntryMetaData;
/*     */ import org.jboss.xb.binding.metadata.PutMethodMetaData;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ import org.jboss.xb.binding.sunday.marshalling.TermBeforeMarshallingCallback;
/*     */ import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;
/*     */ 
/*     */ public class ElementBinding extends TermBinding
/*     */ {
/*  45 */   protected List interceptors = Collections.EMPTY_LIST;
/*     */   protected QName qName;
/*     */   protected TypeBinding typeBinding;
/*     */   protected boolean nillable;
/*     */   protected XOPUnmarshaller xopUnmarshaller;
/*     */ 
/*     */   public ElementBinding(SchemaBinding schema, QName qName, TypeBinding typeBinding)
/*     */   {
/*  55 */     super(schema);
/*  56 */     this.qName = qName;
/*  57 */     this.typeBinding = typeBinding;
/*     */ 
/*  59 */     if (qName == null)
/*     */     {
/*  61 */       throw new JBossXBRuntimeException("Each element must have a non-null QName!");
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ElementBinding()
/*     */   {
/*     */   }
/*     */ 
/*     */   public QName getQName()
/*     */   {
/*  71 */     return this.qName;
/*     */   }
/*     */ 
/*     */   public List getInterceptors()
/*     */   {
/*  76 */     return this.interceptors;
/*     */   }
/*     */ 
/*     */   public TypeBinding getType()
/*     */   {
/*  81 */     return this.typeBinding;
/*     */   }
/*     */ 
/*     */   public void pushInterceptor(ElementInterceptor interceptor)
/*     */   {
/*  86 */     switch (this.interceptors.size())
/*     */     {
/*     */     case 0:
/*  89 */       this.interceptors = Collections.singletonList(interceptor);
/*  90 */       break;
/*     */     case 1:
/*  92 */       this.interceptors = new ArrayList(this.interceptors);
/*     */     default:
/*  95 */       if (this.interceptors.contains(interceptor)) break;
/*  96 */       this.interceptors.add(interceptor);
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClassMetaData getClassMetaData()
/*     */   {
/* 104 */     ClassMetaData result = this.classMetaData;
/* 105 */     if ((result == null) && (this.mapEntryMetaData == null))
/*     */     {
/* 107 */       result = this.typeBinding.getClassMetaData();
/*     */     }
/* 109 */     return result;
/*     */   }
/*     */ 
/*     */   public MapEntryMetaData getMapEntryMetaData()
/*     */   {
/* 114 */     MapEntryMetaData result = this.mapEntryMetaData;
/* 115 */     if ((result == null) && (this.classMetaData == null))
/*     */     {
/* 117 */       result = this.typeBinding.getMapEntryMetaData();
/*     */     }
/* 119 */     return result;
/*     */   }
/*     */ 
/*     */   public ValueMetaData getValueMetaData()
/*     */   {
/* 124 */     return this.valueMetaData != null ? this.valueMetaData : this.typeBinding.getValueMetaData();
/*     */   }
/*     */ 
/*     */   public PutMethodMetaData getPutMethodMetaData()
/*     */   {
/* 130 */     return this.putMethodMetaData;
/*     */   }
/*     */ 
/*     */   public AddMethodMetaData getAddMethodMetaData()
/*     */   {
/* 135 */     AddMethodMetaData result = this.addMethodMetaData;
/* 136 */     if ((result == null) && (this.putMethodMetaData == null) && (this.propertyMetaData == null))
/*     */     {
/* 138 */       result = this.typeBinding.getAddMethodMetaData();
/*     */     }
/* 140 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean isSkip()
/*     */   {
/* 145 */     return this.skip == null ? this.typeBinding.isSkip() : this.skip.booleanValue();
/*     */   }
/*     */ 
/*     */   public ValueAdapter getValueAdapter()
/*     */   {
/* 150 */     return this.valueAdapter == null ? this.typeBinding.getValueAdapter() : this.valueAdapter;
/*     */   }
/*     */ 
/*     */   public TermBeforeMarshallingCallback getBeforeMarshallingCallback()
/*     */   {
/* 155 */     return this.beforeMarshallingCallback == null ? this.typeBinding.getBeforeMarshallingCallback() : this.beforeMarshallingCallback;
/*     */   }
/*     */ 
/*     */   public TermBeforeSetParentCallback getBeforeSetParentCallback()
/*     */   {
/* 160 */     return this.beforeSetParentCallback == null ? this.typeBinding.getBeforeSetParentCallback() : this.beforeSetParentCallback;
/*     */   }
/*     */ 
/*     */   public boolean isNillable()
/*     */   {
/* 165 */     return this.nillable;
/*     */   }
/*     */ 
/*     */   public void setNillable(boolean nillable)
/*     */   {
/* 170 */     this.nillable = nillable;
/*     */   }
/*     */ 
/*     */   public boolean isModelGroup()
/*     */   {
/* 175 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isWildcard()
/*     */   {
/* 180 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean isElement()
/*     */   {
/* 185 */     return true;
/*     */   }
/*     */ 
/*     */   public XOPUnmarshaller getXopUnmarshaller()
/*     */   {
/* 190 */     return this.xopUnmarshaller == null ? this.typeBinding.getXopUnmarshaller() : this.xopUnmarshaller;
/*     */   }
/*     */ 
/*     */   public void setXopUnmarshaller(XOPUnmarshaller xopUnmarshaller)
/*     */   {
/* 195 */     this.xopUnmarshaller = xopUnmarshaller;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 200 */     return super.toString() + "(" + this.qName + ", type=" + this.typeBinding.getQName() + ")";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.ElementBinding
 * JD-Core Version:    0.6.0
 */