/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class DefaultElementHandler
/*     */   implements ElementHandler, ParticleHandler
/*     */ {
/*  40 */   private static final Logger log = Logger.getLogger(DefaultElementHandler.class);
/*     */ 
/*  42 */   public static final DefaultElementHandler INSTANCE = new DefaultElementHandler();
/*     */   private AttributesHandler attrsHandler;
/*     */ 
/*     */   public DefaultElementHandler()
/*     */   {
/*  48 */     this(AttributesHandler.INSTANCE);
/*     */   }
/*     */ 
/*     */   public DefaultElementHandler(AttributesHandler attrsHandler)
/*     */   {
/*  53 */     this.attrsHandler = attrsHandler;
/*     */   }
/*     */ 
/*     */   public Object startElement(Object parent, QName qName, ElementBinding element)
/*     */   {
/*  58 */     return parent;
/*     */   }
/*     */ 
/*     */   public void attributes(Object o, QName elementName, ElementBinding element, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/*  63 */     if (this.attrsHandler != null)
/*     */     {
/*  65 */       this.attrsHandler.attributes(o, elementName, element.getType(), attrs, nsCtx);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object endElement(Object o, QName qName, ElementBinding element)
/*     */   {
/*  71 */     return o;
/*     */   }
/*     */ 
/*     */   public void setParent(Object parent, Object o, QName qName, ElementBinding element, ElementBinding parentElement)
/*     */   {
/*  76 */     if (log.isTraceEnabled())
/*  77 */       log.trace("Not setting " + o + " on " + parent + " for " + qName);
/*     */   }
/*     */ 
/*     */   public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx)
/*     */   {
/*  88 */     ElementBinding element = (ElementBinding)particle.getTerm();
/*  89 */     Object o = startElement(parent, elementName, element);
/*  90 */     if (o != null)
/*     */     {
/*  92 */       attrs = element.getType().expandWithDefaultAttributes(attrs);
/*  93 */       attributes(o, elementName, element, attrs, nsCtx);
/*     */     }
/*  95 */     return o;
/*     */   }
/*     */ 
/*     */   public Object endParticle(Object o, QName elementName, ParticleBinding particle)
/*     */   {
/* 100 */     return endElement(o, elementName, (ElementBinding)particle.getTerm());
/*     */   }
/*     */ 
/*     */   public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle)
/*     */   {
/* 109 */     ElementBinding element = (ElementBinding)particle.getTerm();
/* 110 */     ElementBinding parentElement = (ElementBinding)parentParticle.getTerm();
/* 111 */     setParent(parent, o, elementName, element, parentElement);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.DefaultElementHandler
 * JD-Core Version:    0.6.0
 */