/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashSet;
/*     */ import java.util.List;
/*     */ import java.util.Set;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class ChoiceBinding extends ModelGroupBinding
/*     */ {
/*  42 */   private List choices = Collections.EMPTY_LIST;
/*     */ 
/*     */   public ChoiceBinding(SchemaBinding schema)
/*     */   {
/*  46 */     super(schema);
/*     */   }
/*     */ 
/*     */   public ElementBinding getArrayItem()
/*     */   {
/*  51 */     return null;
/*     */   }
/*     */ 
/*     */   public void addParticle(ParticleBinding particle)
/*     */   {
/*  56 */     switch (this.choices.size())
/*     */     {
/*     */     case 0:
/*  59 */       this.choices = Collections.singletonList(particle);
/*  60 */       break;
/*     */     case 1:
/*  62 */       this.choices = new ArrayList(this.choices);
/*     */     default:
/*  64 */       this.choices.add(particle);
/*     */     }
/*     */ 
/*  67 */     super.addParticle(particle);
/*     */   }
/*     */ 
/*     */   public Collection getParticles()
/*     */   {
/*  72 */     return Collections.unmodifiableCollection(this.choices);
/*     */   }
/*     */ 
/*     */   public ModelGroupBinding.Cursor newCursor(ParticleBinding particle)
/*     */   {
/*  77 */     return new ModelGroupBinding.Cursor(particle) { private int pos = -1;
/*     */       private ElementBinding element;
/*     */       private int occurence;
/*     */       private boolean wildcardContent;
/*     */ 
/*  86 */       public ParticleBinding getCurrentParticle() { if (this.pos < 0)
/*     */         {
/*  88 */           throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
/*     */         }
/*     */ 
/*  92 */         return (ParticleBinding)ChoiceBinding.this.choices.get(this.pos);
/*     */       }
/*     */ 
/*     */       public ElementBinding getElement()
/*     */       {
/*  97 */         if (this.pos < 0)
/*     */         {
/*  99 */           throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
/*     */         }
/*     */ 
/* 103 */         return this.element;
/*     */       }
/*     */ 
/*     */       public boolean isPositioned()
/*     */       {
/* 108 */         return this.pos != -1;
/*     */       }
/*     */ 
/*     */       public void endElement(QName qName)
/*     */       {
/* 113 */         if ((this.element == null) || (!this.element.getQName().equals(qName)))
/*     */         {
/* 115 */           throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.element == null ? "null" : this.element.getQName().toString()));
/*     */         }
/*     */ 
/* 120 */         if (this.trace)
/*     */         {
/* 122 */           ChoiceBinding.this.log.trace("endElement " + qName + " in " + getModelGroup());
/*     */         }
/*     */       }
/*     */ 
/*     */       public int getOccurence()
/*     */       {
/* 128 */         return this.occurence;
/*     */       }
/*     */ 
/*     */       public boolean isWildcardContent()
/*     */       {
/* 133 */         return this.wildcardContent;
/*     */       }
/*     */ 
/*     */       protected List startElement(QName qName, Attributes atts, Set passedGroups, List groupStack, boolean required)
/*     */       {
/* 138 */         if (this.trace)
/*     */         {
/* 140 */           StringBuffer sb = new StringBuffer();
/* 141 */           sb.append("startElement " + qName + " in " + getModelGroup() + ", " + ChoiceBinding.this.choices.size() + ": ");
/*     */ 
/* 143 */           for (int i = 0; i < ChoiceBinding.this.choices.size(); i++)
/*     */           {
/* 145 */             ParticleBinding particle = (ParticleBinding)ChoiceBinding.this.choices.get(i);
/* 146 */             Object o = particle.getTerm();
/* 147 */             if ((o instanceof ElementBinding))
/*     */             {
/* 149 */               sb.append(((ElementBinding)o).getQName());
/*     */             }
/* 151 */             else if ((o instanceof SequenceBinding))
/*     */             {
/* 153 */               sb.append("sequence");
/*     */             }
/* 155 */             else if ((o instanceof ChoiceBinding))
/*     */             {
/* 157 */               sb.append("choice");
/*     */             }
/* 159 */             else if ((o instanceof AllBinding))
/*     */             {
/* 161 */               sb.append("all");
/*     */             }
/*     */ 
/* 164 */             sb.append(" ");
/*     */           }
/* 166 */           sb.append("]");
/* 167 */           ChoiceBinding.this.log.trace(sb.toString());
/*     */         }
/*     */ 
/* 170 */         this.wildcardContent = false;
/* 171 */         int i = this.pos;
/* 172 */         if (this.pos >= 0)
/*     */         {
/* 174 */           ParticleBinding particle = getCurrentParticle();
/* 175 */           if ((particle.getMaxOccursUnbounded()) || (this.occurence < particle.getMinOccurs()) || (this.occurence < particle.getMaxOccurs()))
/*     */           {
/* 179 */             i--;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 185 */         while (i < ChoiceBinding.this.choices.size() - 1)
/*     */         {
/* 187 */           i++; ParticleBinding particle = (ParticleBinding)ChoiceBinding.this.choices.get(i);
/* 188 */           Object item = particle.getTerm();
/* 189 */           if ((item instanceof ElementBinding))
/*     */           {
/* 191 */             ElementBinding element = (ElementBinding)item;
/* 192 */             if (qName.equals(element.getQName()))
/*     */             {
/* 194 */               if (this.pos == i)
/*     */               {
/* 196 */                 this.occurence += 1;
/*     */               }
/*     */               else
/*     */               {
/* 200 */                 this.pos = i;
/* 201 */                 this.occurence = 1;
/*     */               }
/* 203 */               groupStack = addItem(groupStack, this);
/* 204 */               this.element = element;
/*     */ 
/* 206 */               if (!this.trace)
/*     */                 break;
/* 208 */               ChoiceBinding.this.log.trace("found " + qName + " in " + getModelGroup()); break;
/*     */             }
/*     */           }
/*     */           else
/*     */           {
/*     */             ModelGroupBinding modelGroup;
/* 213 */             if ((item instanceof ModelGroupBinding))
/*     */             {
/* 215 */               modelGroup = (ModelGroupBinding)item;
/* 216 */               if (!passedGroups.contains(modelGroup))
/*     */               {
/* 218 */                 switch (passedGroups.size())
/*     */                 {
/*     */                 case 0:
/* 221 */                   passedGroups = Collections.singleton(this);
/* 222 */                   break;
/*     */                 case 1:
/* 224 */                   passedGroups = new HashSet(passedGroups);
/*     */                 default:
/* 226 */                   passedGroups.add(this);
/*     */                 }
/*     */ 
/* 229 */                 int groupStackSize = groupStack.size();
/* 230 */                 groupStack = modelGroup.newCursor(particle).startElement(qName, atts, passedGroups, groupStack, particle.isRequired(this.occurence));
/*     */ 
/* 234 */                 if (groupStackSize != groupStack.size())
/*     */                 {
/* 236 */                   if (this.pos != i)
/*     */                   {
/* 238 */                     this.pos = i;
/* 239 */                     this.occurence = 1;
/*     */                   }
/*     */                   else
/*     */                   {
/* 243 */                     this.occurence += 1;
/*     */                   }
/* 245 */                   groupStack = addItem(groupStack, this);
/* 246 */                   this.element = null;
/* 247 */                   break;
/*     */                 }
/*     */               }
/*     */             }
/* 251 */             else if ((item instanceof WildcardBinding))
/*     */             {
/* 253 */               WildcardBinding wildcard = (WildcardBinding)item;
/* 254 */               this.element = wildcard.getElement(qName, atts);
/* 255 */               if (this.element != null)
/*     */               {
/* 257 */                 if (this.pos != i)
/*     */                 {
/* 259 */                   this.pos = i;
/* 260 */                   this.occurence = 1;
/*     */                 }
/*     */                 else
/*     */                 {
/* 264 */                   this.occurence += 1;
/*     */                 }
/* 266 */                 groupStack = addItem(groupStack, this);
/* 267 */                 this.wildcardContent = true;
/* 268 */                 if (!this.trace) break;
/* 269 */                 ChoiceBinding.this.log.trace(qName + " is wildcard content"); break;
/*     */               }
/*     */             }
/*     */           }
/*     */         }
/*     */ 
/* 275 */         if (this.trace)
/*     */         {
/* 277 */           if (i == ChoiceBinding.this.choices.size())
/*     */           {
/* 279 */             ChoiceBinding.this.log.trace(qName + " not found in " + getModelGroup());
/*     */           }
/*     */           else
/*     */           {
/* 283 */             ChoiceBinding.this.log.trace("leaving " + getModelGroup() + " i=" + i + ", pos=" + this.pos);
/*     */           }
/*     */         }
/*     */ 
/* 287 */         return groupStack;
/*     */       }
/*     */ 
/*     */       protected ElementBinding getElement(QName qName, Attributes atts, Set passedGroups, boolean ignoreWildcards)
/*     */       {
/* 292 */         return getElement(ChoiceBinding.this.choices, qName, atts, passedGroups, ignoreWildcards);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   protected boolean mayStartWith(QName qName, Set set)
/*     */   {
/* 299 */     boolean result = false;
/* 300 */     for (int i = 0; i < this.choices.size(); i++)
/*     */     {
/* 302 */       ParticleBinding particle = (ParticleBinding)this.choices.get(i);
/* 303 */       Object item = particle.getTerm();
/* 304 */       if ((item instanceof ElementBinding))
/*     */       {
/* 306 */         ElementBinding element = (ElementBinding)item;
/* 307 */         if (qName.equals(element.getQName()))
/*     */         {
/* 309 */           result = true;
/* 310 */           break;
/*     */         }
/*     */       }
/* 313 */       else if ((item instanceof ModelGroupBinding))
/*     */       {
/* 315 */         ModelGroupBinding modelGroup = (ModelGroupBinding)item;
/* 316 */         if (!set.contains(modelGroup))
/*     */         {
/* 318 */           switch (set.size())
/*     */           {
/*     */           case 0:
/* 321 */             set = Collections.singleton(this);
/* 322 */             break;
/*     */           case 1:
/* 324 */             set = new HashSet(set);
/*     */           default:
/* 326 */             set.add(this);
/*     */           }
/*     */ 
/* 329 */           result = modelGroup.mayStartWith(qName, set);
/*     */ 
/* 331 */           if (result)
/*     */           {
/*     */             break;
/*     */           }
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 339 */         throw new JBossXBRuntimeException("Unexpected item type in model group: " + item);
/*     */       }
/*     */     }
/*     */ 
/* 343 */     return result;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.ChoiceBinding
 * JD-Core Version:    0.6.0
 */