/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.List;
/*     */ import javax.xml.namespace.NamespaceContext;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.Constants;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.SimpleTypeBindings;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ 
/*     */ public abstract class CharactersHandler
/*     */ {
/*  41 */   public static CharactersHandler NOOP = new CharactersHandler()
/*     */   {
/*     */     public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value)
/*     */     {
/*  49 */       return value;
/*     */     }
/*  41 */   };
/*     */ 
/*  53 */   public static CharactersHandler DEFAULT = new CharactersHandler() { } ;
/*     */ 
/*     */   public Object unmarshalEmpty(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData)
/*     */   {
/*  59 */     Object result = null;
/*  60 */     QName typeQName = typeBinding.getQName();
/*  61 */     if (Constants.QNAME_STRING.equals(typeQName))
/*     */     {
/*  63 */       result = "";
/*     */     }
/*  65 */     else if (Constants.QNAME_BASE64BINARY.equals(typeQName))
/*     */     {
/*  67 */       result = new byte[0];
/*     */     }
/*  69 */     return result;
/*     */   }
/*     */ 
/*     */   public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value)
/*     */   {
/*  75 */     QName typeQName = typeBinding.getQName();
/*  76 */     TypeBinding itemType = typeBinding.getItemType();
/*     */     Object o;
/*     */     Object o;
/*  77 */     if (itemType != null)
/*     */     {
/*  79 */       QName itemTypeQName = itemType.getQName();
/*     */       Object o;
/*  80 */       if ((itemTypeQName != null) && ("http://www.w3.org/2001/XMLSchema".equals(itemTypeQName.getNamespaceURI())))
/*     */       {
/*  82 */         List list = SimpleTypeBindings.unmarshalList(itemTypeQName.getLocalPart(), value, nsCtx);
/*     */         Object o;
/*  83 */         if (typeBinding.getSchemaBinding().isUnmarshalListsToArrays())
/*     */         {
/*     */           Object o;
/*  85 */           if (list.isEmpty())
/*     */           {
/*  87 */             Class compType = SimpleTypeBindings.classForType(itemTypeQName.getLocalPart(), true);
/*  88 */             o = Array.newInstance(compType, 0);
/*     */           }
/*     */           else
/*     */           {
/*  92 */             Class compType = list.get(0).getClass();
/*  93 */             o = list.toArray((Object[])(Object[])Array.newInstance(compType, list.size()));
/*     */           }
/*     */         }
/*     */         else
/*     */         {
/*  98 */           o = list;
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 104 */         throw new JBossXBRuntimeException("Only list types with item type from http://www.w3.org/2001/XMLSchema namespace are supported currently.");
/*     */       }
/*     */ 
/*     */     }
/* 110 */     else if ((typeQName != null) && ("http://www.w3.org/2001/XMLSchema".equals(typeQName.getNamespaceURI())))
/*     */     {
/*     */       try
/*     */       {
/* 114 */         o = SimpleTypeBindings.unmarshal(typeQName.getLocalPart(), value, nsCtx);
/*     */       }
/*     */       catch (IllegalStateException e)
/*     */       {
/* 118 */         throw new JBossXBRuntimeException("Characters are not allowed here", e);
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 123 */       TypeBinding baseType = typeBinding.getBaseType();
/* 124 */       o = baseType == null ? value : unmarshal(qName, baseType, nsCtx, valueMetaData, value);
/*     */     }
/* 126 */     return o;
/*     */   }
/*     */ 
/*     */   public void setValue(QName qName, ElementBinding element, Object owner, Object value)
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler
 * JD-Core Version:    0.6.0
 */