/*     */ package org.jboss.xb.binding.sunday.unmarshalling;
/*     */ 
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*     */ import org.jboss.xb.binding.metadata.ValueMetaData;
/*     */ import org.jboss.xb.binding.sunday.marshalling.AttributeMarshaller;
/*     */ import org.jboss.xb.binding.sunday.marshalling.DefaultAttributeMarshaller;
/*     */ 
/*     */ public class AttributeBinding
/*     */ {
/*     */   private final SchemaBinding schema;
/*     */   private final QName qName;
/*     */   private final TypeBinding type;
/*     */   private AttributeHandler handler;
/*  41 */   private AttributeMarshaller marshaller = DefaultAttributeMarshaller.INSTANCE;
/*     */   private PropertyMetaData propertyMetaData;
/*     */   private ValueMetaData valueMetaData;
/*     */   private String defaultConstraint;
/*     */   private boolean mapEntryKey;
/*     */   private boolean mapEntryValue;
/*     */   private ValueAdapter valueAdapter;
/*     */   private boolean required;
/*     */ 
/*     */   public AttributeBinding(SchemaBinding schema, QName qName, TypeBinding type, AttributeHandler handler)
/*     */   {
/*  53 */     this.schema = schema;
/*  54 */     this.qName = qName;
/*  55 */     this.type = type;
/*  56 */     this.handler = handler;
/*     */ 
/*  58 */     if (qName == null)
/*     */     {
/*  60 */       throw new JBossXBRuntimeException("Each attribute should have a non-null QName!");
/*     */     }
/*     */   }
/*     */ 
/*     */   public QName getQName()
/*     */   {
/*  66 */     return this.qName;
/*     */   }
/*     */ 
/*     */   public TypeBinding getType()
/*     */   {
/*  71 */     return this.type;
/*     */   }
/*     */ 
/*     */   public AttributeHandler getHandler()
/*     */   {
/*  76 */     return this.handler;
/*     */   }
/*     */ 
/*     */   public void setHandler(AttributeHandler handler)
/*     */   {
/*  81 */     this.handler = handler;
/*     */   }
/*     */ 
/*     */   public AttributeMarshaller getMarshaller()
/*     */   {
/*  86 */     return this.marshaller;
/*     */   }
/*     */ 
/*     */   public void setMarshaller(AttributeMarshaller marshaller)
/*     */   {
/*  91 */     this.marshaller = marshaller;
/*     */   }
/*     */ 
/*     */   public PropertyMetaData getPropertyMetaData()
/*     */   {
/*  96 */     return this.propertyMetaData;
/*     */   }
/*     */ 
/*     */   public void setPropertyMetaData(PropertyMetaData propertyMetaData)
/*     */   {
/* 101 */     this.propertyMetaData = propertyMetaData;
/*     */   }
/*     */ 
/*     */   public ValueMetaData getValueMetaData()
/*     */   {
/* 106 */     return this.valueMetaData != null ? this.valueMetaData : this.type.getValueMetaData();
/*     */   }
/*     */ 
/*     */   public void setValueMetaData(ValueMetaData valueMetaData)
/*     */   {
/* 111 */     this.valueMetaData = valueMetaData;
/*     */   }
/*     */ 
/*     */   public void setMapEntryKey(boolean mapEntryKey)
/*     */   {
/* 116 */     this.mapEntryKey = mapEntryKey;
/*     */   }
/*     */ 
/*     */   public boolean isMapEntryKey()
/*     */   {
/* 121 */     return this.mapEntryKey;
/*     */   }
/*     */ 
/*     */   public boolean isMapEntryValue()
/*     */   {
/* 126 */     return this.mapEntryValue;
/*     */   }
/*     */ 
/*     */   public void setMapEntryValue(boolean mapEntryValue)
/*     */   {
/* 131 */     this.mapEntryValue = mapEntryValue;
/*     */   }
/*     */ 
/*     */   public String getDefaultConstraint()
/*     */   {
/* 136 */     return this.defaultConstraint;
/*     */   }
/*     */ 
/*     */   public void setDefaultConstraint(String value)
/*     */   {
/* 141 */     this.defaultConstraint = value;
/*     */   }
/*     */ 
/*     */   public SchemaBinding getSchema()
/*     */   {
/* 146 */     return this.schema;
/*     */   }
/*     */ 
/*     */   public ValueAdapter getValueAdapter()
/*     */   {
/* 151 */     return this.valueAdapter == null ? this.type.getValueAdapter() : this.valueAdapter;
/*     */   }
/*     */ 
/*     */   public void setValueAdapter(ValueAdapter valueAdapter)
/*     */   {
/* 156 */     this.valueAdapter = valueAdapter;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 161 */     return super.toString() + "[" + this.qName + "]";
/*     */   }
/*     */ 
/*     */   public void setRequired(boolean required)
/*     */   {
/* 166 */     this.required = required;
/*     */   }
/*     */ 
/*     */   public boolean getRequired()
/*     */   {
/* 171 */     return this.required;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding
 * JD-Core Version:    0.6.0
 */