/*     */ package org.jboss.xb.binding.metadata;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.xb.binding.GenericObjectModelFactory;
/*     */ import org.jboss.xb.binding.JBossXBException;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.Unmarshaller;
/*     */ import org.jboss.xb.binding.UnmarshallerFactory;
/*     */ import org.jboss.xb.binding.UnmarshallingContext;
/*     */ import org.xml.sax.Attributes;
/*     */ 
/*     */ public class XsdAnnotation extends XsdElement
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(XsdAnnotation.class);
/*     */ 
/*     */   public XsdAnnotation(QName qName)
/*     */   {
/*  48 */     super(qName);
/*     */   }
/*     */ 
/*     */   public static final XsdAnnotation unmarshal(String annotation)
/*     */   {
/*  53 */     Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
/*  54 */     unmarshaller.mapFactoryToNamespace(JaxbObjectModelFactory.INSTANCE, "http://java.sun.com/xml/ns/jaxb");
/*  55 */     unmarshaller.mapFactoryToNamespace(JbxbObjectModelFactory.INSTANCE, "http://www.jboss.org/xml/ns/jbxb");
/*     */     try
/*     */     {
/*  59 */       return (XsdAnnotation)unmarshaller.unmarshal(new StringReader(annotation), XsdObjectModelFactory.INSTANCE, (Object)null);
/*     */     }
/*     */     catch (JBossXBException e)
/*     */     {
/*     */     }
/*     */ 
/*  66 */     throw new JBossXBRuntimeException("Failed to parse annotation string: " + annotation + ": " + e.getMessage(), e);
/*     */   }
/*     */ 
/*     */   public XsdAppInfo getAppInfo()
/*     */   {
/*  74 */     return (XsdAppInfo)getChild(XsdAppInfo.QNAME);
/*     */   }
/*     */ 
/*     */   static abstract interface AttributeSetter
/*     */   {
/*     */     public abstract void setAttribute(Object paramObject, String paramString1, String paramString2, String paramString3);
/*     */   }
/*     */ 
/*     */   private static final class JbxbObjectModelFactory
/*     */     implements GenericObjectModelFactory
/*     */   {
/* 351 */     public static final JbxbObjectModelFactory INSTANCE = new JbxbObjectModelFactory();
/*     */ 
/*     */     public Object newChild(Object parent, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */     {
/* 359 */       Object child = null;
/*     */ 
/* 361 */       if ("package".equals(localName))
/*     */       {
/* 363 */         child = new PackageMetaData();
/* 364 */         setAttributes(child, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 368 */             if ("name".equals(localName))
/*     */             {
/* 370 */               ((PackageMetaData)o).setName(value);
/*     */             }
/*     */           }
/*     */         });
/*     */       }
/* 376 */       else if ("value".equals(localName))
/*     */       {
/* 378 */         child = new ValueMetaData();
/* 379 */         setAttributes(child, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 383 */             if ("marshalMethod".equals(localName))
/*     */             {
/* 385 */               ((ValueMetaData)o).setMarshalMethod(value);
/*     */             }
/* 387 */             else if ("unmarshalMethod".equals(localName))
/*     */             {
/* 389 */               ((ValueMetaData)o).setUnmarshalMethod(value);
/*     */             }
/*     */           }
/*     */         });
/*     */       }
/* 395 */       else if ("property".equals(localName))
/*     */       {
/* 397 */         PropertyMetaData property = new PropertyMetaData();
/* 398 */         setAttributes(property, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 402 */             if ("name".equals(localName))
/*     */             {
/* 404 */               ((PropertyMetaData)o).setName(value);
/*     */             }
/* 406 */             else if ("collectionType".equals(localName))
/*     */             {
/* 408 */               ((PropertyMetaData)o).setCollectionType(value);
/*     */             }
/*     */           }
/*     */         });
/* 414 */         if ((parent instanceof XsdAppInfo))
/*     */         {
/* 416 */           ((XsdAppInfo)parent).setPropertyMetaData(property);
/*     */         }
/*     */         else
/*     */         {
/* 420 */           ((CharactersMetaData)parent).setProperty(property);
/*     */         }
/*     */       }
/* 423 */       else if ("mapEntryKey".equals(localName))
/*     */       {
/* 425 */         if ((parent instanceof XsdAppInfo))
/*     */         {
/* 427 */           ((XsdAppInfo)parent).setMapEntryKey(true);
/*     */         }
/*     */         else
/*     */         {
/* 431 */           ((CharactersMetaData)parent).setMapEntryKey(true);
/*     */         }
/*     */       }
/* 434 */       else if ("mapEntryValue".equals(localName))
/*     */       {
/* 436 */         if ((parent instanceof XsdAppInfo))
/*     */         {
/* 438 */           ((XsdAppInfo)parent).setMapEntryValue(true);
/*     */         }
/*     */         else
/*     */         {
/* 442 */           ((CharactersMetaData)parent).setMapEntryValue(true);
/*     */         }
/*     */       }
/* 445 */       else if ("skip".equals(localName))
/*     */       {
/* 447 */         XsdAppInfo appInfo = (XsdAppInfo)parent;
/* 448 */         appInfo.setSkip(true);
/*     */       }
/* 453 */       else if ((!"ignoreUnresolvedFieldOrClass".equals(localName)) && (!"replacePropertyRefs".equals(localName)))
/*     */       {
/* 456 */         XsdAnnotation.log.warn("newChild: " + localName);
/*     */       }
/*     */ 
/* 459 */       return child;
/*     */     }
/*     */ 
/*     */     public void addChild(Object parent, Object child, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */     {
/* 468 */       if ((child instanceof PackageMetaData))
/*     */       {
/* 470 */         SchemaMetaData schema = (SchemaMetaData)parent;
/* 471 */         schema.setPackage((PackageMetaData)child);
/*     */       }
/* 473 */       else if ((child instanceof ValueMetaData))
/*     */       {
/* 475 */         ValueMetaData valueMetaData = (ValueMetaData)child;
/* 476 */         if ((parent instanceof XsdAppInfo))
/*     */         {
/* 478 */           ((XsdAppInfo)parent).setValueMetaData(valueMetaData);
/*     */         }
/*     */         else
/*     */         {
/* 482 */           ((CharactersMetaData)parent).setValue(valueMetaData);
/*     */         }
/*     */       }
/* 485 */       else if ((child instanceof CharactersMetaData))
/*     */       {
/* 487 */         CharactersMetaData charMD = (CharactersMetaData)child;
/* 488 */         ((XsdAppInfo)parent).setCharactersMetaData(charMD);
/*     */       }
/*     */       else
/*     */       {
/* 492 */         XsdAnnotation.log.warn("addChild: " + localName + "=" + child);
/*     */       }
/*     */     }
/*     */ 
/*     */     public void setValue(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, String value)
/*     */     {
/* 499 */       if ("ignoreUnresolvedFieldOrClass".equals(localName))
/*     */       {
/* 501 */         SchemaMetaData schema = (SchemaMetaData)o;
/* 502 */         Boolean flag = Boolean.valueOf(value);
/* 503 */         schema.setIgnoreUnresolvedFieldOrClass(flag.booleanValue());
/*     */       }
/* 506 */       else if ("replacePropertyRefs".equals(localName))
/*     */       {
/* 508 */         SchemaMetaData schema = (SchemaMetaData)o;
/* 509 */         Boolean flag = Boolean.valueOf(value);
/* 510 */         schema.setReplacePropertyRefs(flag.booleanValue());
/*     */       }
/*     */       else
/*     */       {
/* 514 */         XsdAnnotation.log.warn("setValue: " + localName + "=" + value);
/*     */       }
/*     */     }
/*     */ 
/*     */     public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */     {
/* 524 */       Object element = null;
/* 525 */       if ("schemaBindings".equals(localName))
/*     */       {
/* 527 */         element = new SchemaMetaData();
/*     */       }
/* 530 */       else if ("schema".equals(localName))
/*     */       {
/* 532 */         element = new SchemaMetaData();
/*     */       }
/* 534 */       else if ("value".equals(localName))
/*     */       {
/* 536 */         element = new ValueMetaData();
/* 537 */         setAttributes(element, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 541 */             if ("marshalMethod".equals(localName))
/*     */             {
/* 543 */               ((ValueMetaData)o).setMarshalMethod(value);
/*     */             }
/* 545 */             else if ("unmarshalMethod".equals(localName))
/*     */             {
/* 547 */               ((ValueMetaData)o).setUnmarshalMethod(value);
/*     */             }
/*     */           }
/*     */         });
/*     */       }
/* 553 */       else if ("class".equals(localName))
/*     */       {
/* 555 */         element = new ClassMetaData();
/* 556 */         setAttributes(element, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 560 */             if ("impl".equals(localName))
/*     */             {
/* 562 */               ((ClassMetaData)o).setImpl(value);
/*     */             }
/*     */           }
/*     */         });
/*     */       }
/* 568 */       else if ("property".equals(localName))
/*     */       {
/* 570 */         PropertyMetaData property = new PropertyMetaData();
/* 571 */         setAttributes(property, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 575 */             if ("name".equals(localName))
/*     */             {
/* 577 */               ((PropertyMetaData)o).setName(value);
/*     */             }
/* 579 */             else if ("collectionType".equals(localName))
/*     */             {
/* 581 */               ((PropertyMetaData)o).setCollectionType(value);
/*     */             }
/*     */           }
/*     */         });
/* 586 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 587 */         appInfo.setPropertyMetaData(property);
/*     */       }
/* 589 */       else if ("putMethod".equals(localName))
/*     */       {
/* 591 */         PutMethodMetaData putMethod = new PutMethodMetaData();
/* 592 */         setAttributes(putMethod, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 596 */             if ("name".equals(localName))
/*     */             {
/* 598 */               ((PutMethodMetaData)o).setName(value);
/*     */             }
/* 600 */             else if ("keyType".equals(localName))
/*     */             {
/* 602 */               ((PutMethodMetaData)o).setKeyType(value);
/*     */             }
/* 604 */             else if ("valueType".equals(localName))
/*     */             {
/* 606 */               ((PutMethodMetaData)o).setValueType(value);
/*     */             }
/*     */           }
/*     */         });
/* 611 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 612 */         appInfo.setPutMethodMetaData(putMethod);
/*     */       }
/* 614 */       else if ("addMethod".equals(localName))
/*     */       {
/* 616 */         AddMethodMetaData addMethod = new AddMethodMetaData();
/* 617 */         setAttributes(addMethod, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 621 */             if ("name".equals(localName))
/*     */             {
/* 623 */               ((AddMethodMetaData)o).setMethodName(value);
/*     */             }
/* 625 */             else if ("valueType".equals(localName))
/*     */             {
/* 627 */               if ("child".equals(value))
/*     */               {
/* 629 */                 ((AddMethodMetaData)o).setChildType(true);
/*     */               }
/*     */               else
/*     */               {
/* 633 */                 ((AddMethodMetaData)o).setValueType(value);
/*     */               }
/*     */             }
/*     */           }
/*     */         });
/* 639 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 640 */         appInfo.setAddMethodMetaData(addMethod);
/*     */       }
/* 642 */       else if ("mapEntry".equals(localName))
/*     */       {
/* 644 */         MapEntryMetaData mapEntry = new MapEntryMetaData();
/* 645 */         setAttributes(mapEntry, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 649 */             if ("impl".equals(localName))
/*     */             {
/* 651 */               ((MapEntryMetaData)o).setImpl(value);
/*     */             }
/* 653 */             else if ("getKeyMethod".equals(localName))
/*     */             {
/* 655 */               ((MapEntryMetaData)o).setGetKeyMethod(value);
/*     */             }
/* 657 */             else if ("setKeyMethod".equals(localName))
/*     */             {
/* 659 */               ((MapEntryMetaData)o).setSetKeyMethod(value);
/*     */             }
/* 661 */             else if ("getValueMethod".equals(localName))
/*     */             {
/* 663 */               ((MapEntryMetaData)o).setGetValueMethod(value);
/*     */             }
/* 665 */             else if ("setValueMethod".equals(localName))
/*     */             {
/* 667 */               ((MapEntryMetaData)o).setSetValueMethod(value);
/*     */             }
/* 669 */             else if ("valueType".equals(localName))
/*     */             {
/* 671 */               ((MapEntryMetaData)o).setValueType(value);
/*     */             }
/* 673 */             else if ("nonNullValue".equals(localName))
/*     */             {
/* 675 */               boolean b = Boolean.valueOf(value).booleanValue();
/* 676 */               ((MapEntryMetaData)o).setNonNullValue(b);
/*     */             }
/*     */           }
/*     */         });
/* 681 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 682 */         appInfo.setMapEntryMetaData(mapEntry);
/*     */       }
/* 684 */       else if ("mapEntryKey".equals(localName))
/*     */       {
/* 686 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 687 */         appInfo.setMapEntryKey(true);
/*     */       }
/* 689 */       else if ("mapEntryValue".equals(localName))
/*     */       {
/* 691 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 692 */         appInfo.setMapEntryValue(true);
/*     */       }
/* 694 */       else if ("characters".equals(localName))
/*     */       {
/* 696 */         element = new CharactersMetaData();
/*     */       }
/* 698 */       else if ("skip".equals(localName))
/*     */       {
/* 700 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 701 */         appInfo.setSkip(true);
/*     */       }
/*     */       else
/*     */       {
/* 705 */         XsdAnnotation.log.warn("Unexpected jbxb annotation: ns=" + namespaceURI + ", localName=" + localName);
/*     */       }
/* 707 */       return element;
/*     */     }
/*     */ 
/*     */     public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */     {
/* 712 */       return root;
/*     */     }
/*     */ 
/*     */     private void setAttributes(Object o, Attributes attrs, XsdAnnotation.AttributeSetter attrSetter)
/*     */     {
/* 719 */       for (int i = 0; i < attrs.getLength(); i++)
/*     */       {
/* 721 */         attrSetter.setAttribute(o, attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class JaxbObjectModelFactory
/*     */     implements GenericObjectModelFactory
/*     */   {
/* 187 */     public static final GenericObjectModelFactory INSTANCE = new JaxbObjectModelFactory();
/*     */ 
/*     */     public Object newChild(Object parent, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */     {
/* 195 */       Object element = null;
/* 196 */       if ("package".equals(localName))
/*     */       {
/* 198 */         element = new PackageMetaData();
/* 199 */         setAttributes(element, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 203 */             if ("name".equals(localName))
/*     */             {
/* 205 */               ((PackageMetaData)o).setName(value);
/*     */             }
/*     */           }
/*     */         });
/*     */       }
/* 211 */       else if ("javaType".equals(localName))
/*     */       {
/* 213 */         ValueMetaData valueMetaData = new ValueMetaData();
/* 214 */         setAttributes(valueMetaData, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 218 */             if ("parseMethod".equals(localName))
/*     */             {
/* 220 */               ((ValueMetaData)o).setUnmarshalMethod(value);
/*     */             }
/* 222 */             else if ("printMethod".equals(localName))
/*     */             {
/* 224 */               ((ValueMetaData)o).setMarshalMethod(value);
/*     */             }
/*     */           }
/*     */         });
/* 231 */         XsdAppInfo appInfo = (XsdAppInfo)parent;
/* 232 */         appInfo.setValueMetaData(valueMetaData);
/*     */       }
/*     */ 
/* 235 */       return element;
/*     */     }
/*     */ 
/*     */     public void addChild(Object parent, Object child, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */     {
/* 244 */       if ((parent instanceof SchemaMetaData))
/*     */       {
/* 246 */         SchemaMetaData schemaMetaData = (SchemaMetaData)parent;
/* 247 */         if ((child instanceof PackageMetaData))
/*     */         {
/* 249 */           schemaMetaData.setPackage((PackageMetaData)child);
/*     */         }
/*     */         else
/*     */         {
/* 253 */           schemaMetaData.addValue((ValueMetaData)child);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     public void setValue(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, String value)
/*     */     {
/*     */     }
/*     */ 
/*     */     public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */     {
/* 268 */       Object element = null;
/* 269 */       if ("schemaBindings".equals(localName))
/*     */       {
/* 271 */         element = new SchemaMetaData();
/*     */       }
/* 273 */       else if ("property".equals(localName))
/*     */       {
/* 275 */         PropertyMetaData property = new PropertyMetaData();
/* 276 */         setAttributes(property, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 280 */             if ("name".equals(localName))
/*     */             {
/* 282 */               ((PropertyMetaData)o).setName(value);
/*     */             }
/* 284 */             else if ("collectionType".equals(localName))
/*     */             {
/* 286 */               ((PropertyMetaData)o).setCollectionType(value);
/*     */             }
/*     */           }
/*     */         });
/* 292 */         XsdAppInfo appInfo = (XsdAppInfo)root;
/* 293 */         appInfo.setPropertyMetaData(property);
/*     */       }
/* 296 */       else if ("class".equals(localName))
/*     */       {
/* 298 */         element = new ClassMetaData();
/* 299 */         setAttributes(element, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 303 */             if ("implClass".equals(localName))
/*     */             {
/* 305 */               ((ClassMetaData)o).setImpl(value);
/*     */             }
/*     */           }
/*     */         });
/*     */       }
/* 311 */       else if ("javaType".equals(localName))
/*     */       {
/* 313 */         element = new ValueMetaData();
/* 314 */         setAttributes(element, attrs, new XsdAnnotation.AttributeSetter()
/*     */         {
/*     */           public void setAttribute(Object o, String nsUri, String localName, String value)
/*     */           {
/* 318 */             if ("printMethod".equals(localName))
/*     */             {
/* 320 */               ((ValueMetaData)o).setMarshalMethod(value);
/*     */             }
/* 322 */             else if ("parseMethod".equals(localName))
/*     */             {
/* 324 */               ((ValueMetaData)o).setUnmarshalMethod(value);
/*     */             }
/*     */           }
/*     */         });
/*     */       }
/*     */ 
/* 331 */       return element;
/*     */     }
/*     */ 
/*     */     public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */     {
/* 336 */       return root;
/*     */     }
/*     */ 
/*     */     private void setAttributes(Object o, Attributes attrs, XsdAnnotation.AttributeSetter attrSetter)
/*     */     {
/* 341 */       for (int i = 0; i < attrs.getLength(); i++)
/*     */       {
/* 343 */         attrSetter.setAttribute(o, attrs.getURI(i), attrs.getLocalName(i), attrs.getValue(i));
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class XsdObjectModelFactory extends XsdAnnotation.AbstractGOMF
/*     */   {
/* 118 */     public static final GenericObjectModelFactory INSTANCE = new XsdObjectModelFactory();
/*     */ 
/*     */     private XsdObjectModelFactory()
/*     */     {
/* 115 */       super();
/*     */     }
/*     */ 
/*     */     public Object newChild(Object parent, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */     {
/* 126 */       XsdElement element = null;
/* 127 */       if ("appinfo".equals(localName))
/*     */       {
/* 129 */         element = new XsdAppInfo();
/* 130 */         for (int i = 0; i < attrs.getLength(); i++)
/*     */         {
/* 132 */           element.addAttribute(new QName(attrs.getURI(i), attrs.getLocalName(i)), attrs.getValue(i));
/*     */         }
/*     */       }
/* 135 */       return element;
/*     */     }
/*     */ 
/*     */     public void addChild(Object parent, Object child, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */     {
/* 144 */       if ((parent instanceof XsdAppInfo))
/*     */       {
/* 146 */         XsdAppInfo appInfo = (XsdAppInfo)parent;
/* 147 */         if ((child instanceof ClassMetaData))
/*     */         {
/* 149 */           appInfo.setClassMetaData((ClassMetaData)child);
/*     */         }
/* 151 */         else if ((child instanceof PropertyMetaData))
/*     */         {
/* 153 */           appInfo.setPropertyMetaData((PropertyMetaData)child);
/*     */         }
/* 155 */         else if ((child instanceof SchemaMetaData))
/*     */         {
/* 157 */           appInfo.setSchemaMetaData((SchemaMetaData)child);
/*     */         }
/* 159 */         else if ((child instanceof ValueMetaData))
/*     */         {
/* 161 */           appInfo.setValueMetaData((ValueMetaData)child);
/*     */         }
/* 163 */         else if ((child instanceof CharactersMetaData))
/*     */         {
/* 165 */           appInfo.setCharactersMetaData((CharactersMetaData)child);
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 170 */         super.addChild(parent, child, ctx, namespaceURI, localName);
/*     */       }
/*     */     }
/*     */ 
/*     */     public Object newRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */     {
/* 180 */       return new XsdAnnotation(new QName(namespaceURI, localName));
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract class AbstractGOMF
/*     */     implements GenericObjectModelFactory
/*     */   {
/*     */     public Object newChild(Object parent, UnmarshallingContext ctx, String namespaceURI, String localName, Attributes attrs)
/*     */     {
/*  88 */       return null;
/*     */     }
/*     */ 
/*     */     public void addChild(Object parent, Object child, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */     {
/*  97 */       XsdElement p = (XsdElement)parent;
/*  98 */       XsdElement c = (XsdElement)child;
/*  99 */       p.addChild(c);
/*     */     }
/*     */ 
/*     */     public void setValue(Object o, UnmarshallingContext ctx, String namespaceURI, String localName, String value)
/*     */     {
/* 104 */       XsdElement e = (XsdElement)o;
/* 105 */       e.setData(value);
/*     */     }
/*     */ 
/*     */     public Object completeRoot(Object root, UnmarshallingContext ctx, String namespaceURI, String localName)
/*     */     {
/* 110 */       return root;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.metadata.XsdAnnotation
 * JD-Core Version:    0.6.0
 */