/*     */ package org.jboss.xb.binding.introspection;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import org.jboss.util.Classes;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ 
/*     */ public class FieldInfo
/*     */ {
/*  38 */   private static final Object[] NO_ARGS = new Object[0];
/*     */   private final Class owner;
/*     */   private final String name;
/*     */   private final Class type;
/*     */   private final GetValueAccess getter;
/*     */   private SetValueAccess setter;
/*     */   private boolean setterInitialized;
/*     */ 
/*     */   static FieldInfo getFieldInfo(ClassInfo clsInfo, String name)
/*     */   {
/* 130 */     FieldInfo fieldInfo = null;
/*     */     try
/*     */     {
/* 133 */       Method getter = Classes.getAttributeGetter(clsInfo.getType(), name);
/* 134 */       fieldInfo = new FieldInfo(clsInfo.getType(), name, getter);
/* 135 */       clsInfo.addFieldInfo(fieldInfo);
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */       try
/*     */       {
/* 141 */         Field field = clsInfo.getType().getField(name);
/* 142 */         fieldInfo = new FieldInfo(clsInfo.getType(), field);
/* 143 */         clsInfo.addFieldInfo(fieldInfo);
/*     */       }
/*     */       catch (NoSuchFieldException e1)
/*     */       {
/* 147 */         fieldInfo = clsInfo.introspect(name);
/*     */       }
/*     */     }
/* 150 */     return fieldInfo;
/*     */   }
/*     */ 
/*     */   public static FieldInfo getFieldInfo(Class cls, String fieldName, boolean required)
/*     */   {
/* 155 */     return ClassInfos.getClassInfo(cls).getFieldInfo(fieldName, required);
/*     */   }
/*     */ 
/*     */   public FieldInfo(Class owner, String name, Method getter)
/*     */   {
/* 167 */     this.owner = owner;
/* 168 */     this.name = name;
/* 169 */     this.type = getter.getReturnType();
/* 170 */     this.getter = GetValueAccessFactory.methodAccess(getter);
/*     */   }
/*     */ 
/*     */   public FieldInfo(Class owner, String name, Method getter, Method setter)
/*     */   {
/* 175 */     this.owner = owner;
/* 176 */     this.name = name;
/* 177 */     this.type = getter.getReturnType();
/* 178 */     this.getter = GetValueAccessFactory.methodAccess(getter);
/* 179 */     this.setter = SetValueAccessFactory.methodAccess(setter);
/* 180 */     this.setterInitialized = true;
/*     */   }
/*     */ 
/*     */   public FieldInfo(Class owner, Field field)
/*     */   {
/* 185 */     this.owner = owner;
/* 186 */     this.name = field.getName();
/* 187 */     this.type = field.getType();
/* 188 */     this.getter = GetValueAccessFactory.fieldAccess(field);
/* 189 */     this.setter = SetValueAccessFactory.fieldAccess(field);
/* 190 */     this.setterInitialized = true;
/*     */   }
/*     */ 
/*     */   public Class getOwner()
/*     */   {
/* 195 */     return this.owner;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 200 */     return this.name;
/*     */   }
/*     */ 
/*     */   public Class getType()
/*     */   {
/* 205 */     return this.type;
/*     */   }
/*     */ 
/*     */   public boolean isReadable()
/*     */   {
/* 210 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isWritable()
/*     */   {
/* 215 */     if (!this.setterInitialized)
/*     */     {
/* 217 */       initializeSetter();
/*     */     }
/* 219 */     return this.setter != null;
/*     */   }
/*     */ 
/*     */   public Object getValue(Object owner)
/*     */   {
/*     */     try
/*     */     {
/* 226 */       return this.getter.get(owner);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 230 */     throw new JBossXBRuntimeException("Failed to get value of the property '" + this.name + "' defined in " + owner + " from instance " + owner, e);
/*     */   }
/*     */ 
/*     */   public void setValue(Object owner, Object value)
/*     */   {
/* 238 */     if (!isWritable())
/*     */     {
/* 240 */       throw new JBossXBRuntimeException("Failed to find setter or field for property '" + this.name + "' in " + owner);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 247 */       this.setter.set(owner, value);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 251 */       throw new JBossXBRuntimeException("Failed to set value '" + value + "' for property '" + this.name + "' defined in " + owner.getClass().getName() + " on instance " + owner, e);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initializeSetter()
/*     */   {
/*     */     try
/*     */     {
/* 262 */       this.setter = SetValueAccessFactory.methodAccess(Classes.getAttributeSetter(this.owner, this.name, this.type));
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/* 267 */     this.setterInitialized = true;
/*     */   }
/*     */ 
/*     */   public static class SetValueAccessFactory
/*     */   {
/*     */     public static FieldInfo.SetValueAccess fieldAccess(Field field)
/*     */     {
/*  79 */       return new FieldInfo.SetValueAccess(field)
/*     */       {
/*     */         public void set(Object owner, Object value) throws IllegalAccessException
/*     */         {
/*  83 */           this.val$field.set(owner, value);
/*     */         }
/*     */       };
/*     */     }
/*     */ 
/*     */     public static FieldInfo.SetValueAccess methodAccess(Method m) {
/*  90 */       return new FieldInfo.SetValueAccess(m)
/*     */       {
/*     */         public void set(Object owner, Object value) throws IllegalAccessException, InvocationTargetException
/*     */         {
/*  94 */           Object[] arguments = { value };
/*     */           try
/*     */           {
/*  97 */             this.val$m.invoke(owner, new Object[] { value });
/*     */           }
/*     */           catch (IllegalArgumentException e)
/*     */           {
/* 101 */             if (owner == null)
/* 102 */               throw new IllegalArgumentException("Null target for " + this.val$m.getName());
/* 103 */             ArrayList expected = new ArrayList();
/* 104 */             Class[] parameters = this.val$m.getParameterTypes();
/* 105 */             if (parameters != null)
/*     */             {
/* 107 */               for (int i = 0; i < parameters.length; i++)
/* 108 */                 expected.add(parameters[i].getName());
/*     */             }
/* 110 */             ArrayList actual = new ArrayList();
/* 111 */             if (arguments != null)
/*     */             {
/* 113 */               for (int i = 0; i < arguments.length; i++)
/*     */               {
/* 115 */                 if (arguments[i] == null)
/* 116 */                   actual.add(null);
/*     */                 else
/* 118 */                   actual.add(arguments[i].getClass().getName());
/*     */               }
/*     */             }
/* 121 */             throw new IllegalArgumentException("Wrong arguments. " + this.val$m.getName() + " for target " + owner + " expected=" + expected + " actual=" + actual);
/*     */           }
/*     */         }
/*     */       };
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface SetValueAccess
/*     */   {
/*     */     public abstract void set(Object paramObject1, Object paramObject2)
/*     */       throws IllegalAccessException, InvocationTargetException;
/*     */   }
/*     */ 
/*     */   public static class GetValueAccessFactory
/*     */   {
/*     */     public static FieldInfo.GetValueAccess fieldAccess(Field field)
/*     */     {
/*  49 */       return new FieldInfo.GetValueAccess(field)
/*     */       {
/*     */         public Object get(Object owner) throws IllegalAccessException
/*     */         {
/*  53 */           return this.val$field.get(owner);
/*     */         }
/*     */       };
/*     */     }
/*     */ 
/*     */     public static FieldInfo.GetValueAccess methodAccess(Method m) {
/*  60 */       return new FieldInfo.GetValueAccess(m)
/*     */       {
/*     */         public Object get(Object owner) throws IllegalAccessException, InvocationTargetException
/*     */         {
/*  64 */           return this.val$m.invoke(owner, FieldInfo.NO_ARGS);
/*     */         }
/*     */       };
/*     */     }
/*     */   }
/*     */ 
/*     */   private static abstract interface GetValueAccess
/*     */   {
/*     */     public abstract Object get(Object paramObject)
/*     */       throws IllegalAccessException, InvocationTargetException;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.introspection.FieldInfo
 * JD-Core Version:    0.6.0
 */