/*     */ package org.jboss.xb.binding.group;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import javax.xml.namespace.QName;
/*     */ import org.jboss.xb.binding.JBossXBRuntimeException;
/*     */ import org.jboss.xb.binding.metadata.PropertyMetaData;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
/*     */ import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtUtil;
/*     */ 
/*     */ public class ValueList
/*     */ {
/*     */   private final ValueListInitializer initializer;
/*     */   private final ValueListHandler handler;
/*     */   private final Class targetClass;
/*  53 */   private List nonRequiredValues = Collections.EMPTY_LIST;
/*     */ 
/*     */   ValueList(ValueListInitializer initializer, ValueListHandler handler, Class targetClass)
/*     */   {
/*  57 */     this.initializer = initializer;
/*  58 */     this.handler = handler;
/*  59 */     this.targetClass = targetClass;
/*     */   }
/*     */ 
/*     */   void setRequiredValue(int index, int stateIncrement, Object value)
/*     */   {
/*  66 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   Object getRequiredValue(int index)
/*     */   {
/*  90 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   int getState()
/*     */   {
/*  96 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   void setAttributeValue(QName qName, AttributeBinding binding, Object value)
/*     */   {
/* 101 */     setNonRequiredValue(qName, binding, null, value, null);
/*     */   }
/*     */ 
/*     */   void addTextValue(QName qName, ParticleBinding particle, CharactersHandler handler, Object value)
/*     */   {
/* 106 */     setNonRequiredValue(qName, particle, handler, value, null);
/*     */   }
/*     */ 
/*     */   void addTermValue(QName qName, ParticleBinding binding, Object handler, Object value, ParticleBinding parentParticle)
/*     */   {
/* 111 */     setNonRequiredValue(qName, binding, handler, value, parentParticle);
/*     */   }
/*     */ 
/*     */   void addRepeatableTermValue(QName qName, ParticleBinding binding, Object handler, Object value, ParticleBinding parentParticle)
/*     */   {
/* 116 */     NonRequiredValue last = (NonRequiredValue)(this.nonRequiredValues.isEmpty() ? null : this.nonRequiredValues.get(this.nonRequiredValues.size() - 1));
/* 117 */     if ((last == null) || (last.binding != binding))
/*     */     {
/* 120 */       PropertyMetaData propMetaData = binding.getTerm().getPropertyMetaData();
/*     */       Collection col;
/* 121 */       if ((propMetaData != null) && (propMetaData.getCollectionType() != null))
/*     */       {
/* 123 */         Class colCls = RtUtil.loadClass(propMetaData.getCollectionType(), true);
/*     */         try
/*     */         {
/* 126 */           col = (Collection)colCls.newInstance();
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */           Collection col;
/* 130 */           throw new JBossXBRuntimeException("Failed to create an instance of " + colCls.getName() + " for property " + propMetaData.getName());
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 135 */         col = new ArrayList();
/*     */       }
/*     */ 
/* 138 */       col.add(value);
/* 139 */       setNonRequiredValue(qName, binding, handler, col, parentParticle);
/*     */     }
/*     */     else
/*     */     {
/* 143 */       Collection col = (Collection)last.value;
/* 144 */       col.add(value);
/*     */     }
/*     */   }
/*     */ 
/*     */   void setNonRequiredValue(QName qName, Object binding, Object handler, Object value, ParticleBinding parentParticle)
/*     */   {
/* 150 */     NonRequiredValue val = new NonRequiredValue(qName, binding, handler, value, parentParticle);
/* 151 */     switch (this.nonRequiredValues.size())
/*     */     {
/*     */     case 0:
/* 154 */       this.nonRequiredValues = Collections.singletonList(val);
/* 155 */       break;
/*     */     case 1:
/* 157 */       this.nonRequiredValues = new ArrayList(this.nonRequiredValues);
/*     */     default:
/* 159 */       this.nonRequiredValues.add(val);
/*     */     }
/*     */   }
/*     */ 
/*     */   Object getNonRequiredValue(QName qName)
/*     */   {
/* 166 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public ValueListInitializer getInitializer()
/*     */   {
/* 171 */     return this.initializer;
/*     */   }
/*     */ 
/*     */   public List getRequiredValues()
/*     */   {
/* 177 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Map getNonRequiredValues()
/*     */   {
/* 183 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public List getNonRequiredBindings()
/*     */   {
/* 189 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public ValueListHandler getHandler()
/*     */   {
/* 194 */     return this.handler;
/*     */   }
/*     */ 
/*     */   public Class getTargetClass()
/*     */   {
/* 199 */     return this.targetClass;
/*     */   }
/*     */ 
/*     */   public NonRequiredValue getValue(int i)
/*     */   {
/* 204 */     return (NonRequiredValue)this.nonRequiredValues.get(i);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 209 */     return this.nonRequiredValues.size();
/*     */   }
/*     */   public static final class NonRequiredValue { public final QName qName;
/*     */     public final Object binding;
/*     */     public final Object handler;
/*     */     public Object value;
/*     */     public ParticleBinding parentParticle;
/*     */ 
/* 222 */     public NonRequiredValue(QName qName, Object binding, Object handler, Object value, ParticleBinding parentParticle) { this.qName = qName;
/* 223 */       this.binding = binding;
/* 224 */       this.handler = handler;
/* 225 */       this.value = value;
/* 226 */       this.parentParticle = parentParticle;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.group.ValueList
 * JD-Core Version:    0.6.0
 */