/*    */ package org.jboss.xb.binding;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.Reader;
/*    */ import java.io.Writer;
/*    */ import javax.xml.parsers.ParserConfigurationException;
/*    */ import org.xml.sax.SAXException;
/*    */ 
/*    */ public abstract interface Marshaller
/*    */ {
/*    */   public static final String PROP_OUTPUT_XML_VERSION = "org.jboss.xml.binding.marshalling.version";
/*    */   public static final String PROP_MARSHALLER = "org.jboss.xml.binding.Marshaller";
/*    */   public static final String PROP_OUTPUT_INDENTATION = "org.jboss.xml.binding.marshalling.indent";
/*    */   public static final String VERSION = "1.0";
/*    */   public static final String ENCODING = "UTF-8";
/*    */ 
/*    */   public abstract void setVersion(String paramString);
/*    */ 
/*    */   public abstract void setEncoding(String paramString);
/*    */ 
/*    */   public abstract void mapPublicIdToSystemId(String paramString1, String paramString2);
/*    */ 
/*    */   public abstract void mapClassToGlobalElement(Class paramClass, String paramString1, String paramString2, String paramString3, ObjectModelProvider paramObjectModelProvider);
/*    */ 
/*    */   public abstract void mapClassToGlobalType(Class paramClass, String paramString1, String paramString2, String paramString3, ObjectModelProvider paramObjectModelProvider);
/*    */ 
/*    */   public abstract void addRootElement(String paramString1, String paramString2, String paramString3);
/*    */ 
/*    */   public abstract void marshal(String paramString, ObjectModelProvider paramObjectModelProvider, Object paramObject, Writer paramWriter)
/*    */     throws IOException, ParserConfigurationException, SAXException;
/*    */ 
/*    */   public abstract void marshal(Reader paramReader, ObjectModelProvider paramObjectModelProvider, Object paramObject, Writer paramWriter)
/*    */     throws IOException, SAXException, ParserConfigurationException;
/*    */ 
/*    */   public abstract void setProperty(String paramString1, String paramString2);
/*    */ 
/*    */   public abstract String getProperty(String paramString);
/*    */ 
/*    */   public static class FACTORY
/*    */   {
/*    */     public static Marshaller getInstance()
/*    */     {
/* 61 */       String impl = System.getProperty("org.jboss.xml.binding.Marshaller");
/* 62 */       if (impl == null)
/*    */       {
/* 64 */         throw new IllegalStateException("Required system property is not set: org.jboss.xml.binding.Marshaller");
/*    */       }
/*    */       Class implCls;
/*    */       try
/*    */       {
/* 70 */         implCls = Thread.currentThread().getContextClassLoader().loadClass(impl);
/*    */       }
/*    */       catch (ClassNotFoundException e)
/*    */       {
/* 74 */         throw new IllegalStateException("Failed to load marshaller implementation class: " + impl);
/*    */       }
/*    */ 
/*    */       try
/*    */       {
/* 79 */         return (Marshaller)implCls.newInstance();
/*    */       }
/*    */       catch (Exception e) {
/*    */       }
/* 83 */       throw new IllegalStateException("Failed to instantiate a marshaller: " + implCls);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.Marshaller
 * JD-Core Version:    0.6.0
 */