/*     */ package org.jboss.xb.binding;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class Immutable
/*     */ {
/*  35 */   private static final Logger log = Logger.getLogger(Immutable.class);
/*     */   public final Class cls;
/*  39 */   final List names = new ArrayList();
/*     */ 
/*  41 */   final List values = new ArrayList();
/*     */ 
/*     */   public Immutable(Class cls)
/*     */   {
/*  45 */     this.cls = cls;
/*  46 */     if (log.isTraceEnabled())
/*     */     {
/*  48 */       log.trace("created immutable container for " + cls);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addChild(String localName, Object child)
/*     */   {
/*  54 */     if ((!this.names.isEmpty()) && (this.names.get(this.names.size() - 1).equals(localName)))
/*     */     {
/*  56 */       throw new IllegalStateException("Attempt to add duplicate element " + localName + ": prev value=" + this.values.get(this.values.size() - 1) + ", new value=" + child);
/*     */     }
/*     */ 
/*  64 */     this.names.add(localName);
/*  65 */     this.values.add(child);
/*     */ 
/*  67 */     if (log.isTraceEnabled())
/*     */     {
/*  69 */       log.trace("added child " + localName + " for " + this.cls + ": " + child);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object getChild(String localName)
/*     */   {
/*  75 */     return this.names.get(this.names.size() - 1).equals(localName) ? this.values.get(this.values.size() - 1) : this.names.isEmpty() ? null : null;
/*     */   }
/*     */ 
/*     */   public Object newInstance()
/*     */   {
/*  82 */     Constructor ctor = null;
/*  83 */     Constructor[] ctors = this.cls.getConstructors();
/*     */ 
/*  85 */     if ((ctors == null) || (ctors.length == 0))
/*     */     {
/*  87 */       throw new JBossXBRuntimeException("The class has no declared constructors: " + this.cls);
/*     */     }
/*     */ 
/*  90 */     for (int i = 0; i < ctors.length; i++)
/*     */     {
/*  92 */       Class[] types = ctors[i].getParameterTypes();
/*     */ 
/*  94 */       if ((types == null) || (types.length == 0))
/*     */       {
/*  96 */         throw new IllegalStateException("Found no-arg constructor for immutable " + this.cls);
/*     */       }
/*     */ 
/*  99 */       if (types.length != this.values.size())
/*     */         continue;
/* 101 */       ctor = ctors[i];
/*     */ 
/* 103 */       int typeInd = 0;
/* 104 */       while (typeInd < types.length)
/*     */       {
/* 106 */         if (types[typeInd].isAssignableFrom(this.values.get(typeInd++).getClass()))
/*     */           continue;
/* 108 */         ctor = null;
/*     */       }
/*     */ 
/* 113 */       if (ctor != null)
/*     */       {
/*     */         break;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 120 */     if (ctor == null)
/*     */     {
/* 122 */       throw new IllegalStateException("No constructor in " + this.cls + " that would take arguments " + this.values);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 127 */       return ctor.newInstance(this.values.toArray());
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 131 */     throw new IllegalStateException("Failed to create immutable instance of " + this.cls + " using arguments: " + this.values + ": " + e.getMessage());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.xb.binding.Immutable
 * JD-Core Version:    0.6.0
 */