/*     */ package org.jboss.wsf.stack.jbws;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.servlet.ServletConfig;
/*     */ import javax.servlet.ServletContext;
/*     */ import javax.servlet.ServletException;
/*     */ import javax.servlet.http.HttpServlet;
/*     */ import javax.servlet.http.HttpServletRequest;
/*     */ import javax.servlet.http.HttpServletResponse;
/*     */ import javax.xml.ws.WebServiceException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
/*     */ import org.jboss.wsf.common.ObjectNameFactory;
/*     */ import org.jboss.wsf.spi.SPIProvider;
/*     */ import org.jboss.wsf.spi.SPIProviderResolver;
/*     */ import org.jboss.wsf.spi.deployment.Deployment;
/*     */ import org.jboss.wsf.spi.deployment.Deployment.DeploymentType;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint;
/*     */ import org.jboss.wsf.spi.deployment.Endpoint.EndpointState;
/*     */ import org.jboss.wsf.spi.deployment.LifecycleHandler;
/*     */ import org.jboss.wsf.spi.deployment.Service;
/*     */ import org.jboss.wsf.spi.invocation.EndpointAssociation;
/*     */ import org.jboss.wsf.spi.invocation.RequestHandler;
/*     */ import org.jboss.wsf.spi.management.EndpointRegistry;
/*     */ import org.jboss.wsf.spi.management.EndpointRegistryFactory;
/*     */ 
/*     */ public class EndpointServlet extends HttpServlet
/*     */ {
/*  60 */   private static final Logger log = Logger.getLogger(EndpointServlet.class);
/*     */   protected Endpoint endpoint;
/*     */   protected EndpointRegistry epRegistry;
/*     */ 
/*     */   public void init(ServletConfig servletConfig)
/*     */     throws ServletException
/*     */   {
/*  67 */     super.init(servletConfig);
/*  68 */     SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
/*  69 */     this.epRegistry = ((EndpointRegistryFactory)spiProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
/*     */   }
/*     */ 
/*     */   public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
/*     */   {
/*  74 */     if (this.endpoint == null)
/*     */     {
/*  76 */       String contextPath = req.getContextPath();
/*  77 */       initServiceEndpoint(contextPath);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  82 */       EndpointAssociation.setEndpoint(this.endpoint);
/*  83 */       RequestHandler requestHandler = this.endpoint.getRequestHandler();
/*  84 */       requestHandler.handleHttpRequest(this.endpoint, req, res, getServletContext());
/*     */     }
/*     */     finally
/*     */     {
/*  88 */       EndpointAssociation.removeEndpoint();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void initServiceEndpoint(String contextPath)
/*     */   {
/*  96 */     initEndpoint(contextPath, getServletName());
/*  97 */     initEndpointConfig();
/*  98 */     startEndpoint();
/*     */   }
/*     */ 
/*     */   private void startEndpoint()
/*     */   {
/* 104 */     Deployment dep = this.endpoint.getService().getDeployment();
/* 105 */     if ((dep.getType() == Deployment.DeploymentType.JAXRPC_JSE) || (dep.getType() == Deployment.DeploymentType.JAXWS_JSE))
/*     */     {
/* 107 */       if (this.endpoint.getState() == Endpoint.EndpointState.CREATED)
/* 108 */         this.endpoint.getLifecycleHandler().start(this.endpoint);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initEndpointConfig()
/*     */   {
/* 115 */     ServletContext ctx = getServletContext();
/* 116 */     String configName = ctx.getInitParameter("jbossws-config-name");
/* 117 */     String configFile = ctx.getInitParameter("jbossws-config-file");
/* 118 */     if ((configName != null) || (configFile != null))
/*     */     {
/* 120 */       ServerEndpointMetaData epMetaData = (ServerEndpointMetaData)this.endpoint.getAttachment(ServerEndpointMetaData.class);
/* 121 */       if (epMetaData == null) {
/* 122 */         throw new IllegalStateException("Cannot obtain endpoint meta data");
/*     */       }
/* 124 */       log.debug("Updating service endpoint config\n  config-name: " + configName + "\n  config-file: " + configFile);
/* 125 */       epMetaData.setConfigName(configName, configFile);
/*     */     }
/*     */   }
/*     */ 
/*     */   private void initEndpoint(String contextPath, String servletName)
/*     */   {
/* 131 */     WebAppResolver resolver = new WebAppResolver(contextPath, servletName);
/* 132 */     this.endpoint = this.epRegistry.resolve(resolver);
/*     */ 
/* 134 */     if (this.endpoint == null)
/*     */     {
/* 136 */       ObjectName oname = ObjectNameFactory.create("jboss.ws:context=" + contextPath + "," + "endpoint" + "=" + getServletName());
/*     */ 
/* 140 */       throw new WebServiceException("Cannot obtain endpoint for: " + oname);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.stack.jbws.EndpointServlet
 * JD-Core Version:    0.6.0
 */