/*     */ package org.jboss.wsf.spi.tools.cmd;
/*     */ 
/*     */ import gnu.getopt.Getopt;
/*     */ import gnu.getopt.LongOpt;
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.wsf.spi.tools.WSContractConsumer;
/*     */ 
/*     */ public class WSConsume
/*     */ {
/*  61 */   private List<File> bindingFiles = new ArrayList();
/*  62 */   private boolean generateSource = false;
/*  63 */   private File catalog = null;
/*  64 */   private String targetPackage = null;
/*  65 */   private String wsdlLocation = null;
/*  66 */   private boolean quiet = false;
/*  67 */   private boolean verbose = false;
/*  68 */   private boolean loadConsumer = false;
/*  69 */   private File outputDir = new File("output");
/*  70 */   private File sourceDir = null;
/*  71 */   private String target = null;
/*     */ 
/*  73 */   public static String PROGRAM_NAME = System.getProperty("program.name", WSConsume.class.getName());
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/*  77 */     WSConsume importer = new WSConsume();
/*  78 */     URL wsdl = importer.parseArguments(args);
/*  79 */     System.exit(importer.importServices(wsdl));
/*     */   }
/*     */ 
/*     */   private URL parseArguments(String[] args)
/*     */   {
/*  84 */     String shortOpts = "b:c:p:w:o:s:t:khqvl";
/*  85 */     LongOpt[] longOpts = { new LongOpt("binding", 1, null, 98), new LongOpt("catalog", 1, null, 99), new LongOpt("package", 1, null, 112), new LongOpt("wsdlLocation", 1, null, 119), new LongOpt("output", 1, null, 111), new LongOpt("source", 1, null, 115), new LongOpt("target", 1, null, 116), new LongOpt("keep", 0, null, 107), new LongOpt("help", 0, null, 104), new LongOpt("quiet", 0, null, 113), new LongOpt("verbose", 0, null, 118), new LongOpt("load-consumer", 0, null, 108) };
/*     */ 
/* 101 */     Getopt getopt = new Getopt(PROGRAM_NAME, args, shortOpts, longOpts);
/*     */     int c;
/* 103 */     while ((c = getopt.getopt()) != -1)
/*     */     {
/* 105 */       switch (c)
/*     */       {
/*     */       case 98:
/* 108 */         this.bindingFiles.add(new File(getopt.getOptarg()));
/* 109 */         break;
/*     */       case 107:
/* 111 */         this.generateSource = true;
/* 112 */         break;
/*     */       case 99:
/* 114 */         this.catalog = new File(getopt.getOptarg());
/* 115 */         break;
/*     */       case 112:
/* 117 */         this.targetPackage = getopt.getOptarg();
/* 118 */         break;
/*     */       case 119:
/* 120 */         this.wsdlLocation = getopt.getOptarg();
/* 121 */         break;
/*     */       case 111:
/* 123 */         this.outputDir = new File(getopt.getOptarg());
/* 124 */         break;
/*     */       case 115:
/* 126 */         this.sourceDir = new File(getopt.getOptarg());
/* 127 */         break;
/*     */       case 116:
/* 129 */         this.target = getopt.getOptarg();
/* 130 */         break;
/*     */       case 113:
/* 132 */         this.quiet = true;
/* 133 */         break;
/*     */       case 118:
/* 135 */         this.verbose = true;
/* 136 */         break;
/*     */       case 108:
/* 138 */         this.loadConsumer = true;
/* 139 */         break;
/*     */       case 104:
/* 141 */         printHelp();
/* 142 */         System.exit(0);
/*     */       case 63:
/* 144 */         System.exit(1);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 149 */     if (this.loadConsumer)
/*     */     {
/* 151 */       WSContractConsumer importer = WSContractConsumer.newInstance();
/* 152 */       System.out.println("WSContractConsumer instance: " + importer.getClass().getCanonicalName());
/* 153 */       System.exit(0);
/*     */     }
/*     */ 
/* 156 */     int wsdlPos = getopt.getOptind();
/* 157 */     if (wsdlPos >= args.length)
/*     */     {
/* 159 */       System.err.println("Error: WSDL URL was not specified!");
/* 160 */       printHelp();
/* 161 */       System.exit(1);
/*     */     }
/*     */ 
/* 164 */     URL url = null;
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 169 */         url = new URL(args[wsdlPos]);
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 173 */         File file = new File(args[wsdlPos]);
/* 174 */         url = file.toURL();
/*     */       }
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 179 */       System.err.println("Error: Invalid URI: " + args[wsdlPos]);
/* 180 */       System.exit(1);
/*     */     }
/*     */ 
/* 183 */     return url;
/*     */   }
/*     */ 
/*     */   private int importServices(URL wsdl)
/*     */   {
/* 189 */     WSContractConsumer importer = WSContractConsumer.newInstance();
/*     */ 
/* 191 */     importer.setGenerateSource(this.generateSource);
/* 192 */     importer.setOutputDirectory(this.outputDir);
/* 193 */     if (this.sourceDir != null) {
/* 194 */       importer.setSourceDirectory(this.sourceDir);
/*     */     }
/* 196 */     if (!this.quiet) {
/* 197 */       importer.setMessageStream(System.out);
/*     */     }
/* 199 */     if (this.catalog != null) {
/* 200 */       importer.setCatalog(this.catalog);
/*     */     }
/* 202 */     if (this.targetPackage != null) {
/* 203 */       importer.setTargetPackage(this.targetPackage);
/*     */     }
/* 205 */     if (this.wsdlLocation != null) {
/* 206 */       importer.setWsdlLocation(this.wsdlLocation);
/*     */     }
/* 208 */     if ((this.bindingFiles != null) && (this.bindingFiles.size() > 0)) {
/* 209 */       importer.setBindingFiles(this.bindingFiles);
/*     */     }
/* 211 */     if (this.target != null) {
/* 212 */       importer.setTarget(this.target);
/*     */     }
/*     */     try
/*     */     {
/* 216 */       importer.consume(wsdl);
/* 217 */       return 0;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 221 */       System.err.println("Error: Could not import. (use --verbose to see full traces)");
/* 222 */       if (!this.verbose)
/*     */       {
/* 224 */         String message = t.getMessage();
/* 225 */         if (message == null)
/* 226 */           message = t.getClass().getSimpleName();
/* 227 */         System.err.println("Error: " + message);
/*     */       }
/*     */       else
/*     */       {
/* 231 */         t.printStackTrace(System.err);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 236 */     return 1;
/*     */   }
/*     */ 
/*     */   private static void printHelp()
/*     */   {
/* 241 */     PrintStream out = System.out;
/* 242 */     out.println("WSConsumeTask is a cmd line tool that generates portable JAX-WS artifacts from a WSDL file.\n");
/* 243 */     out.println("usage: " + PROGRAM_NAME + " [options] <wsdl-url>\n");
/* 244 */     out.println("options: ");
/* 245 */     out.println("    -h, --help                  Show this help message");
/* 246 */     out.println("    -b, --binding=<file>        One or more JAX-WS or JAXB binding files ");
/* 247 */     out.println("    -k, --keep                  Keep/Generate Java source");
/* 248 */     out.println("    -c  --catalog=<file>        Oasis XML Catalog file for entity resolution");
/* 249 */     out.println("    -p  --package=<name>        The target package for generated source");
/* 250 */     out.println("    -w  --wsdlLocation=<loc>    Value to use for @WebService.wsdlLocation");
/* 251 */     out.println("    -o, --output=<directory>    The directory to put generated artifacts");
/* 252 */     out.println("    -s, --source=<directory>    The directory to put Java source");
/* 253 */     out.println("    -t, --target=<2.0|2.1>      The JAX-WS specification target");
/* 254 */     out.println("    -q, --quiet                 Be somewhat more quiet");
/* 255 */     out.println("    -v, --verbose               Show full exception stack traces");
/* 256 */     out.println("    -l, --load-consumer         Load the consumer and exit (debug utility)");
/* 257 */     out.flush();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.tools.cmd.WSConsume
 * JD-Core Version:    0.6.0
 */