/*     */ package org.jboss.wsf.spi.tools.ant;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.net.URLClassLoader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.StringTokenizer;
/*     */ import org.apache.tools.ant.AntClassLoader;
/*     */ import org.apache.tools.ant.BuildException;
/*     */ import org.apache.tools.ant.Task;
/*     */ import org.apache.tools.ant.taskdefs.ExecuteJava;
/*     */ import org.apache.tools.ant.taskdefs.LogOutputStream;
/*     */ import org.apache.tools.ant.types.Commandline;
/*     */ import org.apache.tools.ant.types.Commandline.Argument;
/*     */ import org.apache.tools.ant.types.CommandlineJava;
/*     */ import org.apache.tools.ant.types.Path;
/*     */ import org.apache.tools.ant.types.Reference;
/*     */ import org.jboss.wsf.spi.tools.WSContractProvider;
/*     */ import org.jboss.wsf.spi.tools.cmd.WSProvide;
/*     */ 
/*     */ public class WSProvideTask extends Task
/*     */ {
/*  90 */   private Path classpath = new Path(getProject());
/*  91 */   private CommandlineJava command = new CommandlineJava();
/*  92 */   private String sei = null;
/*  93 */   private File destdir = null;
/*  94 */   private File resourcedestdir = null;
/*  95 */   private File sourcedestdir = null;
/*  96 */   private boolean keep = false;
/*  97 */   private boolean genwsdl = false;
/*  98 */   private boolean verbose = false;
/*  99 */   private boolean fork = false;
/* 100 */   private boolean debug = false;
/*     */ 
/*     */   public void setDebug(boolean debug)
/*     */   {
/* 105 */     this.debug = debug;
/*     */   }
/*     */ 
/*     */   public Commandline.Argument createJvmarg()
/*     */   {
/* 110 */     return this.command.createVmArgument();
/*     */   }
/*     */ 
/*     */   public void setClasspath(Path classpath)
/*     */   {
/* 115 */     this.classpath = classpath;
/*     */   }
/*     */ 
/*     */   public void setClasspathRef(Reference ref)
/*     */   {
/* 120 */     createClasspath().setRefid(ref);
/*     */   }
/*     */ 
/*     */   public Path createClasspath()
/*     */   {
/* 125 */     return this.classpath;
/*     */   }
/*     */ 
/*     */   public void setDestdir(File destdir)
/*     */   {
/* 130 */     this.destdir = destdir;
/*     */   }
/*     */ 
/*     */   public void setKeep(boolean keep)
/*     */   {
/* 135 */     this.keep = keep;
/*     */   }
/*     */ 
/*     */   public void setSei(String sei)
/*     */   {
/* 140 */     this.sei = sei;
/*     */   }
/*     */ 
/*     */   public void setFork(boolean fork)
/*     */   {
/* 145 */     this.fork = fork;
/*     */   }
/*     */ 
/*     */   public void setResourcedestdir(File resourcedestdir)
/*     */   {
/* 150 */     this.resourcedestdir = resourcedestdir;
/*     */   }
/*     */ 
/*     */   public void setSourcedestdir(File sourcedestdir)
/*     */   {
/* 155 */     this.sourcedestdir = sourcedestdir;
/*     */   }
/*     */ 
/*     */   public void setVerbose(boolean verbose)
/*     */   {
/* 160 */     this.verbose = verbose;
/*     */   }
/*     */ 
/*     */   public void setGenwsdl(boolean genwsdl)
/*     */   {
/* 165 */     this.genwsdl = genwsdl;
/*     */   }
/*     */ 
/*     */   private ClassLoader getClasspathLoader(ClassLoader parent)
/*     */   {
/* 170 */     AntClassLoader antLoader = new AntClassLoader(parent, getProject(), this.classpath, false);
/*     */ 
/* 175 */     List urls = new ArrayList();
/* 176 */     StringTokenizer tok = new StringTokenizer(antLoader.getClasspath(), File.separator);
/* 177 */     while (tok.hasMoreTokens())
/*     */     {
/*     */       try
/*     */       {
/* 181 */         String path = tok.nextToken();
/* 182 */         if (!path.startsWith("file://")) {
/* 183 */           path = "file://" + path;
/*     */         }
/* 185 */         urls.add(new URL(path));
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 189 */         throw new IllegalArgumentException("Failed to wrap classloader", e);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 194 */     ClassLoader wrapper = new URLClassLoader((URL[])urls.toArray(new URL[0]), antLoader);
/* 195 */     return wrapper;
/*     */   }
/*     */ 
/*     */   public void executeNonForked()
/*     */   {
/* 200 */     ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
/* 201 */     ClassLoader antLoader = getClass().getClassLoader();
/* 202 */     Thread.currentThread().setContextClassLoader(antLoader);
/*     */     try
/*     */     {
/* 205 */       WSContractProvider gen = WSContractProvider.newInstance(getClasspathLoader(antLoader));
/*     */ 
/* 208 */       if (this.verbose)
/* 209 */         gen.setMessageStream(new PrintStream(new LogOutputStream(this, 2)));
/* 210 */       gen.setGenerateSource(this.keep);
/* 211 */       gen.setGenerateWsdl(this.genwsdl);
/* 212 */       if (this.destdir != null)
/* 213 */         gen.setOutputDirectory(this.destdir);
/* 214 */       if (this.resourcedestdir != null)
/* 215 */         gen.setResourceDirectory(this.resourcedestdir);
/* 216 */       if (this.sourcedestdir != null) {
/* 217 */         gen.setSourceDirectory(this.sourcedestdir);
/*     */       }
/* 219 */       log("Generating from endpoint: " + this.sei, 2);
/*     */ 
/* 221 */       gen.provide(this.sei);
/*     */     }
/*     */     finally
/*     */     {
/* 225 */       Thread.currentThread().setContextClassLoader(prevCL);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void execute() throws BuildException
/*     */   {
/* 231 */     if (this.sei == null) {
/* 232 */       throw new BuildException("The sei attribute must be specified!", getLocation());
/*     */     }
/* 234 */     if (this.fork)
/* 235 */       executeForked();
/*     */     else
/* 237 */       executeNonForked();
/*     */   }
/*     */ 
/*     */   private Path getTaskClassPath()
/*     */   {
/* 243 */     ClassLoader cl = getClass().getClassLoader();
/* 244 */     if ((cl instanceof AntClassLoader))
/*     */     {
/* 246 */       return new Path(getProject(), ((AntClassLoader)cl).getClasspath());
/*     */     }
/*     */ 
/* 249 */     return new Path(getProject());
/*     */   }
/*     */ 
/*     */   private void executeForked() throws BuildException
/*     */   {
/* 254 */     this.command.setClassname(WSProvide.class.getName());
/*     */ 
/* 256 */     Path path = this.command.createClasspath(getProject());
/* 257 */     path.append(getTaskClassPath());
/* 258 */     path.append(this.classpath);
/*     */ 
/* 260 */     if (this.keep) {
/* 261 */       this.command.createArgument().setValue("-k");
/*     */     }
/* 263 */     if (this.genwsdl) {
/* 264 */       this.command.createArgument().setValue("-w");
/*     */     }
/* 266 */     if (this.destdir != null)
/*     */     {
/* 268 */       this.command.createArgument().setValue("-o");
/* 269 */       this.command.createArgument().setFile(this.destdir);
/*     */     }
/* 271 */     if (this.resourcedestdir != null)
/*     */     {
/* 273 */       this.command.createArgument().setValue("-r");
/* 274 */       this.command.createArgument().setFile(this.resourcedestdir);
/*     */     }
/* 276 */     if (this.sourcedestdir != null)
/*     */     {
/* 278 */       this.command.createArgument().setValue("-s");
/* 279 */       this.command.createArgument().setFile(this.sourcedestdir);
/*     */     }
/*     */ 
/* 282 */     if (!this.verbose) {
/* 283 */       this.command.createArgument().setValue("-q");
/*     */     }
/*     */ 
/* 286 */     this.command.createArgument().setValue("-t");
/* 287 */     this.command.createArgument().setValue(this.sei);
/*     */ 
/* 289 */     if (this.verbose) {
/* 290 */       log("Command invoked: " + this.command.getJavaCommand().toString());
/*     */     }
/* 292 */     ExecuteJava execute = new ExecuteJava();
/* 293 */     execute.setClasspath(path);
/* 294 */     execute.setJavaCommand(this.command.getJavaCommand());
/* 295 */     if (execute.fork(this) != 0)
/* 296 */       throw new BuildException("Could not invoke WSProvideTask", getLocation());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.tools.ant.WSProvideTask
 * JD-Core Version:    0.6.0
 */