/*     */ package org.jboss.wsf.spi.tools.ant;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.apache.tools.ant.AntClassLoader;
/*     */ import org.apache.tools.ant.BuildException;
/*     */ import org.apache.tools.ant.DirectoryScanner;
/*     */ import org.apache.tools.ant.Task;
/*     */ import org.apache.tools.ant.taskdefs.ExecuteJava;
/*     */ import org.apache.tools.ant.taskdefs.LogOutputStream;
/*     */ import org.apache.tools.ant.types.Commandline;
/*     */ import org.apache.tools.ant.types.Commandline.Argument;
/*     */ import org.apache.tools.ant.types.CommandlineJava;
/*     */ import org.apache.tools.ant.types.FileSet;
/*     */ import org.apache.tools.ant.types.Path;
/*     */ import org.jboss.wsf.spi.tools.WSContractConsumer;
/*     */ import org.jboss.wsf.spi.tools.cmd.WSConsume;
/*     */ 
/*     */ public class WSConsumeTask extends Task
/*     */ {
/*  82 */   private CommandlineJava command = new CommandlineJava();
/*     */   private String wsdl;
/*     */   private File destdir;
/*     */   private File sourcedestdir;
/*  86 */   private List<File> bindingFiles = new ArrayList();
/*     */   private File catalog;
/*     */   private String wsdlLocation;
/*     */   private String targetPackage;
/*     */   private boolean keep;
/*     */   private boolean verbose;
/*     */   private boolean fork;
/*     */   private boolean debug;
/*     */   private String target;
/*     */ 
/*     */   public void setDebug(boolean debug)
/*     */   {
/*  99 */     this.debug = debug;
/*     */   }
/*     */ 
/*     */   public Commandline.Argument createJvmarg()
/*     */   {
/* 104 */     return this.command.createVmArgument();
/*     */   }
/*     */ 
/*     */   public void setBinding(File bindingFile)
/*     */   {
/* 109 */     this.bindingFiles.add(bindingFile);
/*     */   }
/*     */ 
/*     */   public void setCatalog(File catalog)
/*     */   {
/* 114 */     this.catalog = catalog;
/*     */   }
/*     */ 
/*     */   public void setDestdir(File destdir)
/*     */   {
/* 119 */     this.destdir = destdir;
/*     */   }
/*     */ 
/*     */   public void setFork(boolean fork)
/*     */   {
/* 124 */     this.fork = fork;
/*     */   }
/*     */ 
/*     */   public void setKeep(boolean keep)
/*     */   {
/* 129 */     this.keep = keep;
/*     */   }
/*     */ 
/*     */   public void setSourcedestdir(File sourcedestdir)
/*     */   {
/* 134 */     this.sourcedestdir = sourcedestdir;
/*     */   }
/*     */ 
/*     */   public void setTarget(String target)
/*     */   {
/* 139 */     this.target = target;
/*     */   }
/*     */ 
/*     */   public void setPackage(String targetPackage)
/*     */   {
/* 144 */     this.targetPackage = targetPackage;
/*     */   }
/*     */ 
/*     */   public void setVerbose(boolean verbose)
/*     */   {
/* 149 */     this.verbose = verbose;
/*     */   }
/*     */ 
/*     */   public void setWsdl(String wsdl)
/*     */   {
/* 154 */     this.wsdl = wsdl;
/*     */   }
/*     */ 
/*     */   public void setWsdlLocation(String wsdlLocation)
/*     */   {
/* 159 */     this.wsdlLocation = wsdlLocation;
/*     */   }
/*     */ 
/*     */   public void addConfiguredBinding(FileSet fs)
/*     */   {
/* 164 */     DirectoryScanner ds = fs.getDirectoryScanner(getProject());
/* 165 */     File baseDir = ds.getBasedir();
/* 166 */     for (String file : ds.getIncludedFiles())
/*     */     {
/* 168 */       this.bindingFiles.add(new File(baseDir, file));
/*     */     }
/*     */   }
/*     */ 
/*     */   public void executeNonForked()
/*     */   {
/* 174 */     ClassLoader prevCL = Thread.currentThread().getContextClassLoader();
/* 175 */     ClassLoader antLoader = getClass().getClassLoader();
/* 176 */     Thread.currentThread().setContextClassLoader(antLoader);
/*     */     try
/*     */     {
/* 179 */       WSContractConsumer importer = WSContractConsumer.newInstance();
/* 180 */       importer.setGenerateSource(this.keep);
/* 181 */       if (this.destdir != null)
/* 182 */         importer.setOutputDirectory(this.destdir);
/* 183 */       if (this.sourcedestdir != null)
/* 184 */         importer.setSourceDirectory(this.sourcedestdir);
/* 185 */       if (this.targetPackage != null)
/* 186 */         importer.setTargetPackage(this.targetPackage);
/* 187 */       if (this.wsdlLocation != null)
/* 188 */         importer.setWsdlLocation(this.wsdlLocation);
/* 189 */       if (this.catalog != null)
/* 190 */         importer.setCatalog(this.catalog);
/* 191 */       if ((this.bindingFiles != null) && (this.bindingFiles.size() > 0))
/* 192 */         importer.setBindingFiles(this.bindingFiles);
/* 193 */       if (this.target != null) {
/* 194 */         importer.setTarget(this.target);
/*     */       }
/* 196 */       log("Consuming wsdl: " + this.wsdl, 2);
/*     */ 
/* 198 */       if (this.verbose)
/*     */       {
/* 200 */         importer.setMessageStream(new PrintStream(new LogOutputStream(this, 2)));
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 205 */         importer.setAdditionalCompilerClassPath(getTaskClassPathStrings());
/* 206 */         importer.consume(this.wsdl);
/*     */       }
/*     */       catch (MalformedURLException e)
/*     */       {
/* 210 */         throw new BuildException(e, getLocation());
/*     */       }
/*     */     }
/*     */     finally
/*     */     {
/* 215 */       Thread.currentThread().setContextClassLoader(prevCL);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void execute() throws BuildException
/*     */   {
/* 221 */     if (this.wsdl == null) {
/* 222 */       throw new BuildException("The wsdl attribute must be specified!", getLocation());
/*     */     }
/* 224 */     if (this.fork)
/* 225 */       executeForked();
/* 226 */     else executeNonForked();
/*     */   }
/*     */ 
/*     */   private Path getTaskClassPath()
/*     */   {
/* 232 */     ClassLoader cl = getClass().getClassLoader();
/* 233 */     if ((cl instanceof AntClassLoader))
/*     */     {
/* 235 */       return new Path(getProject(), ((AntClassLoader)cl).getClasspath());
/*     */     }
/*     */ 
/* 238 */     return new Path(getProject());
/*     */   }
/*     */ 
/*     */   private List<String> getTaskClassPathStrings()
/*     */   {
/* 244 */     List strings = new ArrayList();
/* 245 */     ClassLoader cl = getClass().getClassLoader();
/* 246 */     if ((cl instanceof AntClassLoader))
/*     */     {
/* 248 */       for (String string : ((AntClassLoader)cl).getClasspath().split(File.pathSeparator)) {
/* 249 */         strings.add(string);
/*     */       }
/*     */     }
/* 252 */     return strings;
/*     */   }
/*     */ 
/*     */   private void executeForked() throws BuildException
/*     */   {
/* 257 */     this.command.setClassname(WSConsume.class.getName());
/*     */ 
/* 259 */     Path path = this.command.createClasspath(getProject());
/* 260 */     path.append(getTaskClassPath());
/*     */ 
/* 262 */     if (this.keep) {
/* 263 */       this.command.createArgument().setValue("-k");
/*     */     }
/* 265 */     for (File file : this.bindingFiles)
/*     */     {
/* 267 */       this.command.createArgument().setValue("-b");
/* 268 */       this.command.createArgument().setFile(file);
/*     */     }
/*     */ 
/* 271 */     if (this.catalog != null)
/*     */     {
/* 273 */       this.command.createArgument().setValue("-c");
/* 274 */       this.command.createArgument().setFile(this.catalog);
/*     */     }
/*     */ 
/* 277 */     if (this.targetPackage != null)
/*     */     {
/* 279 */       this.command.createArgument().setValue("-p");
/* 280 */       this.command.createArgument().setValue(this.targetPackage);
/*     */     }
/*     */ 
/* 283 */     if (this.wsdlLocation != null)
/*     */     {
/* 285 */       this.command.createArgument().setValue("-w");
/* 286 */       this.command.createArgument().setValue(this.wsdlLocation);
/*     */     }
/*     */ 
/* 289 */     if (this.destdir != null)
/*     */     {
/* 291 */       this.command.createArgument().setValue("-o");
/* 292 */       this.command.createArgument().setFile(this.destdir);
/*     */     }
/*     */ 
/* 295 */     if (this.sourcedestdir != null)
/*     */     {
/* 297 */       this.command.createArgument().setValue("-s");
/* 298 */       this.command.createArgument().setFile(this.sourcedestdir);
/*     */     }
/*     */ 
/* 301 */     if (this.target != null)
/*     */     {
/* 303 */       this.command.createArgument().setValue("-t");
/* 304 */       this.command.createArgument().setValue(this.target);
/*     */     }
/*     */ 
/* 307 */     if (this.verbose) {
/* 308 */       this.command.createArgument().setValue("-v");
/*     */     }
/* 310 */     this.command.createArgument().setValue(this.wsdl);
/*     */ 
/* 312 */     log("Consuming wsdl: " + this.wsdl, 2);
/*     */ 
/* 314 */     if (this.verbose) {
/* 315 */       log("Command invoked: " + this.command.getJavaCommand().toString());
/*     */     }
/* 317 */     ExecuteJava execute = new ExecuteJava();
/* 318 */     execute.setClasspath(path);
/* 319 */     execute.setJavaCommand(this.command.getJavaCommand());
/* 320 */     if (execute.fork(this) != 0)
/* 321 */       throw new BuildException("Could not invoke WSConsumeTask", getLocation());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.wsf.spi.tools.ant.WSConsumeTask
 * JD-Core Version:    0.6.0
 */